/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;

public class BlockParticleExpression {
    private final Expression expression;
    private final String unparsed;
    private final boolean hasTime;
    private final boolean hasX;
    private final boolean hasY;
    private final boolean hasZ;
    private final boolean hasState;
    private static final String TIME = "TIME";
    private static final String POS_X = "POS_X";
    private static final String POS_Y = "POS_Y";
    private static final String POS_Z = "POS_Z";
    private static final String STATE_FUNC = "state_prop";
    private static final Function STATE_PROP = new Function("state_prop", 1){

        public double apply(double ... args) {
            BlockState blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.m_61147_());
            int index = (int)args[0];
            Property p = (Property)properties.get(Mth.m_14045_((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.m_6908_());
            return (float)values.indexOf(blockState.m_61143_(p)) / ((float)properties.size() - 1.0f);
        }
    };
    private static final Function STATE_PROP_INT = new Function("state_prop_i", 1){

        public double apply(double ... args) {
            BlockState blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.m_61147_());
            int index = (int)args[0];
            Property p = (Property)properties.get(Mth.m_14045_((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.m_6908_());
            return values.indexOf(blockState.m_61143_(p));
        }
    };
    private static final ThreadLocal<BlockState> STATE_HACK = new ThreadLocal();
    public static final Codec<BlockParticleExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            Expression compiled = BlockParticleExpression.createExpression(s);
            return DataResult.success((Object)new BlockParticleExpression(compiled, (String)s));
        }
        catch (Exception e) {
            return DataResult.error((String)("Failed to parse expression:" + e.getMessage()));
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.unparsed));

    private static Expression createExpression(String s) {
        return new ExpressionBuilder(s).functions(ExpressionUtils.defFunc(STATE_PROP, STATE_PROP_INT)).variables(new String[]{TIME}).operator(ExpressionUtils.defOp(new Operator[0])).build();
    }

    public BlockParticleExpression(Expression expression, String unparsed) {
        this.expression = expression;
        this.unparsed = unparsed;
        this.hasTime = unparsed.contains(TIME);
        this.hasX = unparsed.contains(POS_X);
        this.hasY = unparsed.contains(POS_Y);
        this.hasZ = unparsed.contains(POS_Z);
        this.hasState = unparsed.contains(STATE_FUNC);
    }

    public double getValue(Level level, BlockPos pos, BlockState state) {
        if (this.hasTime) {
            this.expression.setVariable(TIME, (double)level.m_46467_());
        }
        if (this.hasX) {
            this.expression.setVariable(POS_X, (double)pos.m_123341_());
        }
        if (this.hasY) {
            this.expression.setVariable(POS_Y, (double)pos.m_123342_());
        }
        if (this.hasZ) {
            this.expression.setVariable(POS_Z, (double)pos.m_123343_());
        }
        if (this.hasState) {
            STATE_HACK.set(state);
        }
        return this.expression.evaluate();
    }
}

