/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.Mth;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;

public class ParticleExpression {
    private final Expression expression;
    private final String unparsed;
    private static final String COLOR = "COLOR";
    private static final String SPEED = "SPEED";
    private static final String X = "X";
    private static final String Y = "Y";
    private static final String Z = "Z";
    private static final String DX = "DX";
    private static final String DY = "DY";
    private static final String DZ = "DZ";
    private static final String RED = "RED";
    private static final String GREEN = "GREEN";
    private static final String BLUE = "BLUE";
    private static final String ALPHA = "ALPHA";
    private static final String SIZE = "SIZE";
    private static final String LIFE = "LIFETIME";
    private final boolean hasColor;
    private final boolean hasSpeed;
    private final boolean hasX;
    private final boolean hasY;
    private final boolean hasZ;
    private final boolean hasDx;
    private final boolean hasDy;
    private final boolean hasDz;
    private final boolean hasRed;
    private final boolean hasGreen;
    private final boolean hasBlue;
    private final boolean hasAlpha;
    private final boolean hasSize;
    private final boolean hasLifeTime;
    public static final Codec<ParticleExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            Expression compiled = ParticleExpression.createExpression(s);
            return DataResult.success((Object)new ParticleExpression(compiled, (String)s));
        }
        catch (Exception e) {
            return DataResult.error((String)("Failed to parse expression:" + e.getMessage()));
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.unparsed));

    public ParticleExpression(Expression expression, String unparsed) {
        this.expression = expression;
        this.unparsed = unparsed;
        this.hasColor = unparsed.contains(COLOR);
        this.hasSpeed = unparsed.contains(SPEED);
        this.hasX = unparsed.contains(X);
        this.hasY = unparsed.contains(Y);
        this.hasZ = unparsed.contains(Z);
        this.hasDx = unparsed.contains(DX);
        this.hasDy = unparsed.contains(DY);
        this.hasDz = unparsed.contains(DZ);
        this.hasRed = unparsed.contains(RED);
        this.hasGreen = unparsed.contains(GREEN);
        this.hasBlue = unparsed.contains(BLUE);
        this.hasAlpha = unparsed.contains(ALPHA);
        this.hasSize = unparsed.contains(SIZE);
        this.hasLifeTime = unparsed.contains(LIFE);
    }

    public static ParticleExpression parse(String s) {
        return new ParticleExpression(ParticleExpression.createExpression(s), s);
    }

    private static Expression createExpression(String s) {
        return new ExpressionBuilder(s).functions(ExpressionUtils.defFunc(new Function[0])).variables(new String[]{COLOR, SPEED, X, Y, Z, DX, DY, DZ, RED, GREEN, BLUE, ALPHA, SIZE, LIFE}).operator(ExpressionUtils.defOp(new Operator[0])).build();
    }

    public double get(Particle particle) {
        if (this.hasLifeTime) {
            this.expression.setVariable(LIFE, (double)particle.m_107273_());
        }
        if (this.hasColor) {
            int pack = ColorUtils.pack(particle.f_107227_, particle.f_107228_, particle.f_107229_);
            this.expression.setVariable(COLOR, (double)pack);
        }
        if (this.hasRed) {
            this.expression.setVariable(RED, (double)particle.f_107227_);
        }
        if (this.hasGreen) {
            this.expression.setVariable(GREEN, (double)particle.f_107228_);
        }
        if (this.hasBlue) {
            this.expression.setVariable(BLUE, (double)particle.f_107229_);
        }
        if (this.hasSpeed) {
            this.expression.setVariable(SPEED, Mth.m_184648_((double)particle.f_107215_, (double)particle.f_107216_, (double)particle.f_107217_));
        }
        if (this.hasAlpha) {
            this.expression.setVariable(ALPHA, (double)particle.f_107230_);
        }
        if (this.hasSize) {
            this.expression.setVariable(SIZE, particle.m_107277_().m_82309_());
        }
        if (this.hasDx) {
            this.expression.setVariable(DX, particle.f_107215_);
        }
        if (this.hasDy) {
            this.expression.setVariable(DX, particle.f_107216_);
        }
        if (this.hasDz) {
            this.expression.setVariable(DX, particle.f_107217_);
        }
        if (this.hasX) {
            this.expression.setVariable(DX, particle.f_107212_);
        }
        if (this.hasY) {
            this.expression.setVariable(DX, particle.f_107213_);
        }
        if (this.hasZ) {
            this.expression.setVariable(DX, particle.f_107214_);
        }
        return this.expression.evaluate();
    }
}

