/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.particle.ParticleModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;

public class ParticleModifiersManager
extends JsonPartialReloader {
    private final Map<ParticleType<?>, ParticleModifier> particleModifiers = new HashMap();

    public ParticleModifiersManager() {
        super("particle_modifiers");
    }

    public void maybeModify(ParticleType<?> type, Particle particle) {
        ParticleModifier mod = this.particleModifiers.get(type);
        if (mod != null) {
            mod.modify(particle);
        }
    }

    @Override
    public void process(Map<ResourceLocation, JsonElement> jsons) {
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            ParticleModifier modifier = (ParticleModifier)((Pair)ParticleModifier.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Particle Modifier with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            this.addModifier(id, modifier);
        }
    }

    private void addModifier(ResourceLocation pathId, ParticleModifier mod) {
        ParticleModifier old;
        Optional<Set<ResourceLocation>> explTargets = mod.explicitTargets;
        Optional pathTarget = Registry.f_122829_.m_6612_(pathId);
        if (explTargets.isPresent()) {
            if (pathTarget.isPresent()) {
                Polytone.LOGGER.error("Found Particle Modifier with Explicit Targets ({}) also having a valid IMPLICIT Path Target ({}).Consider moving it under your OWN namespace to avoid overriding other packs modifiers with the same path", explTargets.get(), (Object)pathId);
            }
            for (ResourceLocation explicitId : explTargets.get()) {
                ParticleModifier old2;
                Optional target = Registry.f_122829_.m_6612_(explicitId);
                if (!target.isPresent() || (old2 = this.particleModifiers.put((ParticleType)target.get(), mod)) == null) continue;
                Polytone.LOGGER.info("Found 2 Particle Modifiers with same target ({}). Overriding", (Object)explicitId);
            }
        } else if (pathTarget.isPresent() && (old = this.particleModifiers.put((ParticleType)pathTarget.get(), mod)) != null) {
            Polytone.LOGGER.info("Found 2 Particle Modifiers with same target ({}). Overriding", (Object)pathTarget);
        }
    }

    @Override
    protected void reset() {
        this.particleModifiers.clear();
    }

    public void addCustomParticleColor(ResourceLocation id, String color) {
        Optional opt = Registry.f_122829_.m_6612_(id);
        opt.ifPresent(t -> this.particleModifiers.put((ParticleType<?>)t, ParticleModifier.ofColor(color)));
    }
}

