/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.sound;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.Nullable;

public class SoundTypesManager
extends PartialReloader<Resources> {
    private final Map<ResourceLocation, SoundEvent> customSoundEvents = new HashMap<ResourceLocation, SoundEvent>();
    private final BiMap<ResourceLocation, SoundType> soundTypesIds = HashBiMap.create();
    private static final Map<String, SoundType> SOUND_NAMES = (Map)Util.m_137537_(() -> {
        HashMap<String, SoundType> map = new HashMap<String, SoundType>();
        map.put("wood", SoundType.f_56736_);
        map.put("gravel", SoundType.f_56739_);
        map.put("grass", SoundType.f_56740_);
        map.put("lily_pad", SoundType.f_56741_);
        map.put("stone", SoundType.f_56742_);
        map.put("metal", SoundType.f_56743_);
        map.put("glass", SoundType.f_56744_);
        map.put("wool", SoundType.f_56745_);
        map.put("sand", SoundType.f_56746_);
        map.put("snow", SoundType.f_56747_);
        map.put("powder_snow", SoundType.f_154681_);
        map.put("ladder", SoundType.f_56748_);
        map.put("anvil", SoundType.f_56749_);
        map.put("slime_block", SoundType.f_56750_);
        map.put("honey_block", SoundType.f_56751_);
        map.put("wet_grass", SoundType.f_56752_);
        map.put("coral_block", SoundType.f_56753_);
        map.put("bamboo", SoundType.f_56754_);
        map.put("bamboo_sapling", SoundType.f_56755_);
        map.put("scaffolding", SoundType.f_56756_);
        map.put("sweet_berry_bush", SoundType.f_56757_);
        map.put("crop", SoundType.f_56758_);
        map.put("hard_crop", SoundType.f_56759_);
        map.put("vine", SoundType.f_56760_);
        map.put("nether_wart", SoundType.f_56761_);
        map.put("lantern", SoundType.f_56762_);
        map.put("stem", SoundType.f_56763_);
        map.put("nylium", SoundType.f_56710_);
        map.put("fungus", SoundType.f_56711_);
        map.put("roots", SoundType.f_56712_);
        map.put("shroomlight", SoundType.f_56713_);
        map.put("weeping_vines", SoundType.f_56714_);
        map.put("twisting_vines", SoundType.f_56715_);
        map.put("soul_sand", SoundType.f_56716_);
        map.put("soul_soil", SoundType.f_56717_);
        map.put("basalt", SoundType.f_56718_);
        map.put("wart_block", SoundType.f_56719_);
        map.put("netherrack", SoundType.f_56720_);
        map.put("nether_bricks", SoundType.f_56721_);
        map.put("nether_sprouts", SoundType.f_56722_);
        map.put("nether_ore", SoundType.f_56723_);
        map.put("bone_block", SoundType.f_56724_);
        map.put("netherite_block", SoundType.f_56725_);
        map.put("ancient_debris", SoundType.f_56726_);
        map.put("lodestone", SoundType.f_56727_);
        map.put("chain", SoundType.f_56728_);
        map.put("nether_gold_ore", SoundType.f_56729_);
        map.put("gilded_blackstone", SoundType.f_56730_);
        map.put("candle", SoundType.f_154653_);
        map.put("amethyst", SoundType.f_154654_);
        map.put("amethyst_cluster", SoundType.f_154655_);
        map.put("small_amethyst_bud", SoundType.f_154656_);
        map.put("medium_amethyst_bud", SoundType.f_154657_);
        map.put("large_amethyst_bud", SoundType.f_154658_);
        map.put("tuff", SoundType.f_154659_);
        map.put("calcite", SoundType.f_154660_);
        map.put("dripstone_block", SoundType.f_154661_);
        map.put("pointed_dripstone", SoundType.f_154662_);
        map.put("copper", SoundType.f_154663_);
        map.put("cave_vines", SoundType.f_154664_);
        map.put("spore_blossom", SoundType.f_154665_);
        map.put("azalea", SoundType.f_154666_);
        map.put("flowering_azalea", SoundType.f_154667_);
        map.put("moss_carpet", SoundType.f_154668_);
        map.put("moss", SoundType.f_154669_);
        map.put("big_dripleaf", SoundType.f_154670_);
        map.put("small_dripleaf", SoundType.f_154671_);
        map.put("rooted_dirt", SoundType.f_154672_);
        map.put("hanging_roots", SoundType.f_154673_);
        map.put("azalea_leaves", SoundType.f_154674_);
        map.put("sculk_sensor", SoundType.f_154675_);
        map.put("sculk_catalyst", SoundType.f_222472_);
        map.put("sculk", SoundType.f_222473_);
        map.put("sculk_vein", SoundType.f_222474_);
        map.put("sculk_shrieker", SoundType.f_222475_);
        map.put("glow_lichen", SoundType.f_154676_);
        map.put("deepslate", SoundType.f_154677_);
        map.put("deepslate_bricks", SoundType.f_154678_);
        map.put("deepslate_tiles", SoundType.f_154679_);
        map.put("polished_deepslate", SoundType.f_154680_);
        map.put("froglight", SoundType.f_222465_);
        map.put("frogspawn", SoundType.f_222466_);
        map.put("muddy_mangrove_roots", SoundType.f_222468_);
        map.put("mud", SoundType.f_222469_);
        map.put("mud_bricks", SoundType.f_222470_);
        map.put("packed_mud", SoundType.f_222471_);
        return map;
    });
    private static final Codec<SoundType> SOUND_TYPE_BLOCK_COPY = Registry.f_122824_.m_194605_().xmap(block -> block.m_49962_(block.m_49966_()), soundType1 -> Blocks.f_50016_);
    public static final Codec<SoundType> REFERENCE_OR_COPY_CODEC = Codec.STRING.flatXmap(s -> {
        SoundType custom;
        if (s.startsWith("copy(")) {
            String target = s.replace("copy(", "").replace(")", "");
            ResourceLocation r = ResourceLocation.m_135820_((String)target);
            if (r == null) {
                return DataResult.error((String)("Invalid string for Sound Type Copy function: " + s + ". Expected 'copy([some_mod]:[some_block])'"));
            }
            Optional block = Registry.f_122824_.m_6612_(r);
            if (block.isEmpty()) {
                return DataResult.error((String)("No block with id '" + r + "' found"), (Object)SoundType.f_56742_);
            }
            Block b = (Block)block.get();
            return DataResult.success((Object)b.m_49962_(b.m_49966_()));
        }
        SoundType vanilla = SOUND_NAMES.get(s);
        if (vanilla != null) {
            return DataResult.success((Object)vanilla);
        }
        ResourceLocation r = ResourceLocation.m_135820_((String)s);
        if (r != null && (custom = Polytone.SOUND_TYPES.getCustom(new ResourceLocation(s))) != null) {
            return DataResult.success((Object)custom);
        }
        return DataResult.error((String)("Could not find any custom Sound Type with id " + r + " Did you place it in 'assets/[your pack]/polytone/sound_types/' ?"));
    }, t -> DataResult.error((String)"Encoding SoundTypes not supported"));
    public static final Codec<SoundType> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(Codec.FLOAT, "volume", Float.valueOf(1.0f)).forGetter(SoundType::m_56773_), (App)StrOpt.of(Codec.FLOAT, "pitch", Float.valueOf(1.0f)).forGetter(SoundType::m_56774_), (App)Registry.f_122821_.m_194605_().fieldOf("break_sound").forGetter(SoundType::m_56775_), (App)Registry.f_122821_.m_194605_().fieldOf("step_sound").forGetter(SoundType::m_56776_), (App)Registry.f_122821_.m_194605_().fieldOf("place_sound").forGetter(SoundType::m_56777_), (App)Registry.f_122821_.m_194605_().fieldOf("hit_sound").forGetter(SoundType::m_56778_), (App)Registry.f_122821_.m_194605_().fieldOf("fall_sound").forGetter(SoundType::m_56779_)).apply((Applicative)instance, SoundType::new));
    public static final Codec<SoundType> CODEC = new ReferenceOrDirectCodec<SoundType>(REFERENCE_OR_COPY_CODEC, DIRECT_CODEC);

    public SoundTypesManager() {
        super("sound_types");
    }

    @Nullable
    public SoundType getCustom(ResourceLocation id) {
        return (SoundType)this.soundTypesIds.get((Object)id);
    }

    @Nullable
    public ResourceLocation getCustomKey(SoundType object) {
        return (ResourceLocation)this.soundTypesIds.inverse().get((Object)object);
    }

    @Override
    protected Resources prepare(ResourceManager resourceManager) {
        HashMap<ResourceLocation, JsonElement> jsons = new HashMap<ResourceLocation, JsonElement>();
        SoundTypesManager.scanDirectory(resourceManager, this.path(), GSON, jsons);
        Map<ResourceLocation, List<String>> types = SoundTypesManager.gatherSoundEvents(resourceManager, "polytone");
        return new Resources(jsons, types);
    }

    @Override
    public void process(Resources resources) {
        Map<ResourceLocation, JsonElement> soundJsons = resources.soundTypes;
        Map<ResourceLocation, List<String>> soundEvents = resources.soundEvents;
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, List<String>> entry : soundEvents.entrySet()) {
            for (String s : entry.getValue()) {
                ResourceLocation id = new ResourceLocation(entry.getKey().m_135827_(), s);
                if (this.customSoundEvents.containsKey(id) || Registry.f_122821_.m_7804_(id)) continue;
                SoundEvent event = PlatStuff.registerSoundEvent(id);
                ids.add(id);
                this.customSoundEvents.put(id, event);
            }
        }
        if (!ids.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom Sound Events from Resource Packs: {}", (Object)ids.size(), (Object)(ids + ". Remember to add them to sounds.json!"));
            Minecraft.m_91087_().m_91106_().m_194526_();
        }
        for (Map.Entry<ResourceLocation, List<String>> entry : soundJsons.entrySet()) {
            JsonElement json = (JsonElement)entry.getValue();
            ResourceLocation id = entry.getKey();
            SoundType soundType = (SoundType)((Pair)DIRECT_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Sound Type with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            this.soundTypesIds.put((Object)id, (Object)soundType);
        }
    }

    @Override
    protected void reset() {
        this.soundTypesIds.clear();
        this.customSoundEvents.clear();
    }

    public static Map<ResourceLocation, List<String>> gatherSoundEvents(ResourceManager resourceManager, String path) {
        HashMap<ResourceLocation, List<String>> idList = new HashMap<ResourceLocation, List<String>>();
        Map res = resourceManager.m_214160_(path, resourceLocation -> resourceLocation.m_135815_().endsWith("sound_events.csv"));
        for (Map.Entry e : res.entrySet()) {
            for (Resource r : (List)e.getValue()) {
                try {
                    BufferedReader reader = r.m_215508_();
                    try {
                        BufferedReader bufferedReader = new BufferedReader(reader);
                        List<String> lines = bufferedReader.lines().map(line -> line.split(",")).flatMap(Arrays::stream).map(String::trim).filter(v -> ResourceLocation.m_135820_((String)v) != null && !v.isEmpty()).toList();
                        if (lines.isEmpty()) continue;
                        idList.put((ResourceLocation)e.getKey(), lines);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException ex) {
                    Polytone.LOGGER.error("Couldn't parse Custom Sound Events file {}:", e.getKey(), (Object)ex);
                }
            }
        }
        return idList;
    }

    public record Resources(Map<ResourceLocation, JsonElement> soundTypes, Map<ResourceLocation, List<String>> soundEvents) {
    }
}

