/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;

public record ArrayImage(int[][] pixels, int width, int height) {
    public static Map<ResourceLocation, Int2ObjectMap<ArrayImage>> gatherGroupedImages(ResourceManager manager, String path) {
        return ArrayImage.groupTextures(ArrayImage.gatherImages(manager, path));
    }

    public static Map<ResourceLocation, ArrayImage> gatherImages(ResourceManager manager, String path) {
        HashMap<ResourceLocation, ArrayImage> map = new HashMap<ResourceLocation, ArrayImage>();
        FileToIdConverter helper = new FileToIdConverter(path, ".png");
        for (Map.Entry<ResourceLocation, Resource> entry : helper.listMatchingResources(manager).entrySet()) {
            ResourceLocation fileId = entry.getKey();
            ResourceLocation id = helper.fileToId(fileId);
            try {
                InputStream inputStream = entry.getValue().m_215507_();
                try {
                    NativeImage nativeImage = NativeImage.m_85058_((InputStream)inputStream);
                    try {
                        int[][] pixels = ArrayImage.makePixelMatrix(nativeImage);
                        ArrayImage image = new ArrayImage(pixels, nativeImage.m_84982_(), nativeImage.m_85084_());
                        ArrayImage oldImage = map.put(id, image);
                        if (oldImage == null) continue;
                        throw new IllegalStateException("Duplicate data file ignored with ID " + id);
                    }
                    finally {
                        if (nativeImage == null) continue;
                        nativeImage.close();
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | IllegalArgumentException | UnsupportedOperationException var14) {
                Polytone.LOGGER.error("Couldn't parse texture file {} from {}", (Object)id, (Object)fileId, (Object)var14);
            }
        }
        return map;
    }

    private static int[][] makePixelMatrix(NativeImage nativeImage) {
        if (nativeImage.m_85102_() != NativeImage.Format.RGBA) {
            throw new UnsupportedOperationException("Can only call makePixelMatrix for RGBA images.");
        }
        int width = nativeImage.m_84982_();
        int height = nativeImage.m_85084_();
        int[][] pixelMatrix = new int[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int pixel = nativeImage.m_84985_(j, i);
                pixelMatrix[i][j] = FastColor.ARGB32.m_13660_((int)255, (int)FastColor.ARGB32.m_13669_((int)pixel), (int)FastColor.ARGB32.m_13667_((int)pixel), (int)FastColor.ARGB32.m_13665_((int)pixel));
            }
        }
        return pixelMatrix;
    }

    public static Map<ResourceLocation, Int2ObjectMap<ArrayImage>> groupTextures(Map<ResourceLocation, ArrayImage> texturesColormap) {
        LinkedHashMap<ResourceLocation, Int2ObjectMap<ArrayImage>> groupedMap = new LinkedHashMap<ResourceLocation, Int2ObjectMap<ArrayImage>>();
        Pattern pattern = Pattern.compile("(\\D+)(_\\d+)?");
        for (Map.Entry<ResourceLocation, ArrayImage> e : texturesColormap.entrySet()) {
            ResourceLocation id = e.getKey();
            String str = id.m_135815_();
            Matcher matcher = pattern.matcher(str);
            if (!matcher.matches()) continue;
            String key = matcher.group(1);
            String indexMatch = matcher.group(2);
            int index = -1;
            if (indexMatch != null) {
                index = Integer.parseInt(indexMatch.substring(1));
            }
            groupedMap.computeIfAbsent(new ResourceLocation(id.m_135827_(), key), a -> new Int2ObjectArrayMap()).put(index, (Object)e.getValue());
        }
        return groupedMap;
    }
}

