/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Locale;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.mixins.accessor.BiomeAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public class ColorUtils {
    public static final Codec<Integer> CODEC = Codec.either((Codec)Codec.intRange((int)0, (int)-1), (Codec)Codec.STRING.flatXmap(ColorUtils::isValidStringOrError, s -> ColorUtils.isValidStringOrError(s).map(ColorUtils::formatString))).xmap(either -> (Integer)either.map(integer -> integer, s -> Integer.parseUnsignedInt(s, 16)), integer -> Either.right((Object)("#" + String.format("%08X", integer))));
    public static final ColorResolver TEMPERATURE_RESOLVER = (biome, x, z) -> {
        byte hack = (byte)(Mth.m_14036_((float)ColorUtils.getClimateSettings((Biome)biome).f_47681_, (float)0.0f, (float)1.0f) * 255.0f);
        return ColorUtils.pack(hack, hack, hack, hack);
    };
    public static final ColorResolver INT_TEMPERATURE_RESOLVER = (biome, x, z) -> Float.floatToIntBits(Mth.m_14036_((float)ColorUtils.getClimateSettings((Biome)biome).f_47681_, (float)0.0f, (float)1.0f));
    public static final ColorResolver DOWNFALL_RESOLVER = (biome, x, z) -> {
        byte hack = (byte)(Mth.m_14036_((float)ColorUtils.getClimateSettings((Biome)biome).f_47683_, (float)0.0f, (float)1.0f) * 255.0f);
        return ColorUtils.pack(hack, hack, hack, hack);
    };
    public static final ColorResolver INT_DOWNFALL_RESOLVER = (biome, x, z) -> Float.floatToIntBits(Mth.m_14036_((float)ColorUtils.getClimateSettings((Biome)biome).f_47683_, (float)0.0f, (float)1.0f));

    private static String formatString(String s) {
        return "#" + s.toUpperCase(Locale.ROOT);
    }

    public static DataResult<String> isValidStringOrError(String s) {
        String st = s;
        if (s.startsWith("0x")) {
            st = s.substring(2);
        } else if (s.startsWith("#")) {
            st = s.substring(1);
        }
        if (st.length() > 8) {
            return DataResult.error((String)"Invalid color format. Hex value must have up to 8 characters.");
        }
        try {
            int parsedValue = Integer.parseUnsignedInt(st, 16);
            return DataResult.success((Object)st);
        }
        catch (NumberFormatException e) {
            return DataResult.error((String)"Invalid color format. Must be in hex format (0xff00ff00, #ff00ff00, ff00ff00) or integer value");
        }
    }

    public static boolean isValidString(String s) {
        return ColorUtils.isValidStringOrError(s).result().isPresent();
    }

    public static int pack(float ... components) {
        int n = (int)(components[0] * 255.0f) << 16;
        int o = (int)(components[1] * 255.0f) << 8;
        int p = (int)(components[2] * 255.0f);
        return n & 0xFF0000 | o & 0xFF00 | p & 0xFF;
    }

    public static float[] unpack(int value) {
        int n = (value & 0xFF0000) >> 16;
        int o = (value & 0xFF00) >> 8;
        int p = value & 0xFF;
        return new float[]{(float)n / 255.0f, (float)o / 255.0f, (float)p / 255.0f};
    }

    public static Biome.ClimateSettings getClimateSettings(Level level, BlockPos pos) {
        return ColorUtils.getClimateSettings((Biome)level.m_204166_(pos).m_203334_());
    }

    public static Biome.ClimateSettings getClimateSettings(Biome biome) {
        return ((BiomeAccessor)biome).getClimateSettings();
    }

    public static float temperature(BlockState state, BlockAndTintGetter level, BlockPos pos) {
        if (Polytone.sodiumOn) {
            if (level instanceof Level) {
                Level l = (Level)level;
                Biome.ClimateSettings b = ColorUtils.getClimateSettings(l, pos);
                return b.f_47681_;
            }
            return 0.5f;
        }
        int t = level.m_6171_(pos, TEMPERATURE_RESOLVER) & 0xFF;
        return (float)t / 255.0f;
    }

    public static float downfall(BlockState state, BlockAndTintGetter level, BlockPos pos) {
        if (Polytone.sodiumOn) {
            if (level instanceof Level) {
                Level l = (Level)level;
                return ColorUtils.getClimateSettings((Level)l, (BlockPos)pos).f_47683_;
            }
            return 0.5f;
        }
        int t = level.m_6171_(pos, DOWNFALL_RESOLVER) & 0xFF;
        return (float)t / 255.0f;
    }
}

