/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import java.util.stream.Stream;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;

public class ExpressionUtils {
    private static final RandomSource RANDOM_SOURCE = RandomSource.m_216343_();
    private static final Function RAND = new Function("rand", 0){

        public double apply(double ... args) {
            return RANDOM_SOURCE.m_188501_();
        }
    };
    private static final Function COS = new Function("cos", 1){

        public double apply(double ... args) {
            return Mth.m_14089_((float)((float)args[0]));
        }
    };
    private static final Function SIN = new Function("sin", 1){

        public double apply(double ... args) {
            return Mth.m_14031_((float)((float)args[0]));
        }
    };
    private static final Function RED = new Function("red", 1){

        public double apply(double ... args) {
            return (float)FastColor.ARGB32.m_13665_((int)((int)args[0])) / 255.0f;
        }
    };
    private static final Function GREEN = new Function("green", 1){

        public double apply(double ... args) {
            return (float)FastColor.ARGB32.m_13667_((int)((int)args[0])) / 255.0f;
        }
    };
    private static final Function BLUE = new Function("blue", 1){

        public double apply(double ... args) {
            return (float)FastColor.ARGB32.m_13669_((int)((int)args[0])) / 255.0f;
        }
    };
    private static final Function ALPHA = new Function("alpha", 1){

        public double apply(double ... args) {
            return (float)FastColor.ARGB32.m_13655_((int)((int)args[0])) / 255.0f;
        }
    };
    private static final Function COLOR = new Function("color", 4){

        public double apply(double ... args) {
            return FastColor.ARGB32.m_13660_((int)((int)(args[0] * 255.0)), (int)((int)(args[1] * 255.0)), (int)((int)(args[2] * 255.0)), (int)((int)(args[3] * 255.0)));
        }
    };
    private static final Function ATAN2 = new Function("atan2", 2){

        public double apply(double ... args) {
            return Mth.m_14136_((double)((float)args[0]), (double)args[1]);
        }
    };
    private static final Function STEP = new Function("step", 2){

        public double apply(double ... args) {
            return args[0] >= args[1] ? 1.0 : 0.0;
        }
    };
    private static final Function MAX = new Function("max", 2){

        public double apply(double ... args) {
            return Math.max(args[0], args[1]);
        }
    };
    private static final Function MIN = new Function("min", 2){

        public double apply(double ... args) {
            return Math.min(args[0], args[1]);
        }
    };
    private static final Function LERP = new Function("min", 3){

        public double apply(double ... args) {
            return Mth.m_14139_((double)args[0], (double)args[1], (double)args[2]);
        }
    };
    public static final Function SMOOTHSTEP = new Function("smoothstep", 3){

        public double apply(double ... args) {
            double t = Math.max(0.0, Math.min(1.0, (args[0] - args[1]) / (args[2] - args[1])));
            return t * t * (3.0 - 2.0 * t);
        }
    };
    private static final Operator EQUALS = new Operator("==", 2, true, 499){

        public double apply(double[] values) {
            return values[0] == values[1] ? 1.0 : 0.0;
        }
    };
    private static final Operator LESS_EQUAL = new Operator("<=", 2, true, 498){

        public double apply(double[] values) {
            if (values[0] <= values[1]) {
                return 1.0;
            }
            return 0.0;
        }
    };
    private static final Operator GREATER_EQUAL = new Operator(">=", 2, true, 497){

        public double apply(double[] values) {
            if (values[0] >= values[1]) {
                return 1.0;
            }
            return 0.0;
        }
    };
    private static final Operator LESS = new Operator("<", 2, true, 496){

        public double apply(double[] values) {
            return values[0] < values[1] ? 1.0 : 0.0;
        }
    };
    private static final Operator GREATER = new Operator(">", 2, true, 495){

        public double apply(double[] values) {
            return values[0] > values[1] ? 1.0 : 0.0;
        }
    };
    private static final Operator FACTORIAL = new Operator("!", 1, true, 10001){

        public double apply(double ... args) {
            int arg = (int)args[0];
            if ((double)arg != args[0]) {
                throw new IllegalArgumentException("Operand for factorial has to be an integer");
            }
            if (arg < 0) {
                throw new IllegalArgumentException("The operand of the factorial can not be less than zero");
            }
            double result = 1.0;
            for (int i = 1; i <= arg; ++i) {
                result *= (double)i;
            }
            return result;
        }
    };

    public static Function[] defFunc(Function ... others) {
        return (Function[])Stream.concat(Stream.of(ATAN2, RAND, STEP, SMOOTHSTEP, MAX, MIN, LERP, RED, GREEN, BLUE, ALPHA, COLOR), Stream.of(others)).toArray(Function[]::new);
    }

    public static Operator[] defOp(Operator ... others) {
        return (Operator[])Stream.concat(Stream.of(EQUALS, GREATER, LESS, GREATER_EQUAL, LESS_EQUAL, FACTORIAL), Stream.of(others)).toArray(Operator[]::new);
    }
}

