/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;

public abstract class PartialReloader<T> {
    public static final Gson GSON = new Gson();
    protected String name;

    protected PartialReloader(String name) {
        this.name = name;
    }

    public String path() {
        return "polytone/" + this.name;
    }

    protected abstract T prepare(ResourceManager var1);

    protected abstract void reset();

    protected abstract void process(T var1);

    protected void apply() {
    }

    public static void scanDirectory(ResourceManager resourceManager, String string, Gson gson, Map<ResourceLocation, JsonElement> map) {
        FileToIdConverter fileToIdConverter = FileToIdConverter.json(string);
        for (Map.Entry<ResourceLocation, Resource> entry : fileToIdConverter.listMatchingResources(resourceManager).entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            ResourceLocation resourceLocation2 = fileToIdConverter.fileToId(resourceLocation);
            try {
                BufferedReader reader = entry.getValue().m_215508_();
                try {
                    JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)gson, (Reader)reader, JsonElement.class);
                    JsonElement jsonElement2 = map.put(resourceLocation2, jsonElement);
                    if (jsonElement2 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + resourceLocation2);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException var14) {
                Polytone.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{resourceLocation2, resourceLocation, var14});
            }
        }
    }
}

