/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.mehvahdjukaar.polytone.utils.PropertiesUtils;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;

public abstract class SingleJsonOrPropertiesReloadListener
extends PartialReloader<List<Properties>> {
    private static final Gson GSON = new Gson();
    private final String[] locations;
    private final String propertiesName;
    private final String jsonName;

    protected SingleJsonOrPropertiesReloadListener(String propertiesName, String jsonName, String ... possibleLocations) {
        super("color_manager");
        this.locations = possibleLocations;
        this.propertiesName = propertiesName;
        this.jsonName = jsonName;
    }

    @Override
    protected List<Properties> prepare(ResourceManager resourceManager) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        for (String paths : this.locations) {
            BufferedReader reader;
            Collection res = resourceManager.m_214160_(paths, resourceLocation -> resourceLocation.m_135815_().endsWith(this.propertiesName)).values();
            for (List l : res) {
                for (Resource r : l) {
                    try {
                        reader = r.m_215508_();
                        try {
                            Properties properties = new Properties();
                            properties.load(reader);
                            list.add(properties);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (JsonParseException | IOException | IllegalArgumentException ex) {
                        Polytone.LOGGER.error("Couldn't parse data file {}:", (Object)l, (Object)ex);
                    }
                }
            }
            res = resourceManager.m_214160_(paths, resourceLocation -> resourceLocation.m_135815_().endsWith(this.jsonName)).values();
            for (List l : res) {
                for (Resource r : l) {
                    try {
                        reader = r.m_215508_();
                        try {
                            JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                            Properties prop = PropertiesUtils.jsonToProperties(jsonElement);
                            list.add(prop);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (JsonParseException | IOException | IllegalArgumentException ex) {
                        Polytone.LOGGER.error("Couldn't parse data file {}:", (Object)l, (Object)ex);
                    }
                }
            }
        }
        return list;
    }
}

