/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.recipe.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface StandardRecipeHandler<T extends AbstractContainerMenu>
extends EmiRecipeHandler<T> {
    public List<Slot> getInputSources(T var1);

    public List<Slot> getCraftingSlots(T var1);

    default public List<Slot> getCraftingSlots(EmiRecipe recipe, T handler) {
        return this.getCraftingSlots(handler);
    }

    @Nullable
    default public Slot getOutputSlot(T handler) {
        return null;
    }

    @Override
    default public EmiPlayerInventory getInventory(AbstractContainerScreen<T> screen) {
        return new EmiPlayerInventory(this.getInputSources(screen.m_6262_()).stream().map(Slot::m_7993_).map(EmiStack::of).toList());
    }

    @Override
    default public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
        return context.getInventory().canCraft(recipe);
    }

    @Override
    default public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        List<ItemStack> stacks = EmiRecipeFiller.getStacks(this, recipe, context.getScreen(), context.getAmount());
        if (stacks != null && stacks != null) {
            Minecraft.m_91087_().m_91152_(context.getScreen());
            if (!EmiClient.onServer) {
                return EmiRecipeFiller.clientFill(this, recipe, context.getScreen(), stacks, context.getDestination());
            }
            AbstractContainerScreen<T> abstractContainerScreen = context.getScreen();
            int n = ((AbstractContainerMenu)context.getScreenHandler()).f_38840_;
            EmiClient.sendFillRecipe(this, abstractContainerScreen, n, switch (context.getDestination()) {
                default -> throw new IncompatibleClassChangeError();
                case EmiCraftContext.Destination.NONE -> 0;
                case EmiCraftContext.Destination.CURSOR -> 1;
                case EmiCraftContext.Destination.INVENTORY -> 2;
            }, stacks, recipe);
            return true;
        }
        return false;
    }

    @Override
    default public void render(EmiRecipe recipe, EmiCraftContext<T> context, List<Widget> widgets, PoseStack matrices) {
        StandardRecipeHandler.renderMissing(recipe, context.getInventory(), widgets, matrices);
    }

    @ApiStatus.Internal
    public static void renderMissing(EmiRecipe recipe, EmiPlayerInventory inv, List<Widget> widgets, PoseStack matrices) {
        EmiDrawContext context = EmiDrawContext.wrap(matrices);
        RenderSystem.m_69482_();
        Map<EmiIngredient, Boolean> availableForCrafting = StandardRecipeHandler.getAvailable(recipe, inv);
        for (Widget w : widgets) {
            if (!(w instanceof SlotWidget)) continue;
            SlotWidget sw = (SlotWidget)w;
            EmiIngredient stack = sw.getStack();
            Bounds bounds = sw.getBounds();
            if (sw.getRecipe() != null || !availableForCrafting.containsKey(stack) || stack.isEmpty() || availableForCrafting.get(stack).booleanValue()) continue;
            context.fill(bounds.x(), bounds.y(), bounds.width(), bounds.height(), 0x44FF0000);
        }
    }

    private static Map<EmiIngredient, Boolean> getAvailable(EmiRecipe recipe, EmiPlayerInventory inventory) {
        IdentityHashMap<EmiIngredient, Boolean> availableForCrafting = new IdentityHashMap<EmiIngredient, Boolean>();
        List<Boolean> list = inventory.getCraftAvailability(recipe);
        List<EmiIngredient> inputs = recipe.getInputs();
        if (list.size() != inputs.size()) {
            return Map.of();
        }
        for (int i = 0; i < list.size(); ++i) {
            availableForCrafting.put(inputs.get(i), list.get(i));
        }
        return availableForCrafting;
    }
}

