/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.platform.EmiAgnos;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FluidEmiStack
extends EmiStack {
    private final Fluid fluid;
    private final CompoundTag nbt;

    public FluidEmiStack(Fluid fluid) {
        this(fluid, null);
    }

    public FluidEmiStack(Fluid fluid, @Nullable CompoundTag nbt) {
        this(fluid, nbt, 0L);
    }

    public FluidEmiStack(Fluid fluid, @Nullable CompoundTag nbt, long amount) {
        this.fluid = fluid;
        this.nbt = nbt;
        this.amount = amount;
    }

    @Override
    public EmiStack copy() {
        FluidEmiStack e = new FluidEmiStack(this.fluid, this.nbt, this.amount);
        e.setChance(this.chance);
        e.setRemainder(this.getRemainder().copy());
        e.comparison = this.comparison;
        return e;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public CompoundTag getNbt() {
        return this.nbt;
    }

    @Override
    public Object getKey() {
        return this.fluid;
    }

    @Override
    public ResourceLocation getId() {
        return EmiPort.getFluidRegistry().m_7981_((Object)this.fluid);
    }

    @Override
    public void render(PoseStack matrices, int x, int y, float delta, int flags) {
        if ((flags & 1) != 0) {
            EmiAgnos.renderFluid(this, matrices, x, y, delta);
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon(this, matrices, x, y);
        }
    }

    @Override
    public List<Component> getTooltipText() {
        return EmiAgnos.getFluidTooltip(this.fluid, this.nbt);
    }

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        List<ClientTooltipComponent> list = this.getTooltipText().stream().map(EmiTooltipComponents::of).collect(Collectors.toList());
        if (this.amount > 1L) {
            list.add(EmiTooltipComponents.getAmount(this));
        }
        String namespace = EmiPort.getFluidRegistry().m_7981_((Object)this.fluid).m_135827_();
        EmiTooltipComponents.appendModName(list, namespace);
        list.addAll(super.getTooltip());
        return list;
    }

    @Override
    public Component getName() {
        return EmiAgnos.getFluidName(this.fluid, this.nbt);
    }

    static class FluidEntry {
        FluidEntry() {
        }
    }
}

