/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.mixin.accessor.BakedModelManagerAccessor;
import dev.emi.emi.mixin.accessor.ItemRendererAccessor;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.tooltip.RemainderTooltipComponent;
import dev.emi.emi.screen.tooltip.TagTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TagEmiIngredient
implements EmiIngredient {
    private final ResourceLocation id;
    private List<EmiStack> stacks;
    public final TagKey<?> key;
    private long amount;
    private float chance = 1.0f;

    @ApiStatus.Internal
    public TagEmiIngredient(TagKey<?> key, long amount) {
        this(key, EmiTags.getValues(key), amount);
    }

    @ApiStatus.Internal
    public TagEmiIngredient(TagKey<?> key, List<EmiStack> stacks, long amount) {
        this.id = key.f_203868_();
        this.key = key;
        this.stacks = stacks;
        this.amount = amount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TagEmiIngredient)) return false;
        TagEmiIngredient tag = (TagEmiIngredient)obj;
        if (!tag.key.equals(this.key)) return false;
        return true;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public EmiIngredient copy() {
        TagEmiIngredient stack = new TagEmiIngredient(this.key, this.amount);
        stack.setChance(this.chance);
        return stack;
    }

    @Override
    public List<EmiStack> getEmiStacks() {
        return this.stacks;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public EmiIngredient setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public EmiIngredient setChance(float chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public void render(PoseStack matrices, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(matrices);
        Minecraft client = Minecraft.m_91087_();
        if ((flags & 1) != 0) {
            if (!EmiTags.hasCustomModel(this.key)) {
                if (this.stacks.size() > 0) {
                    this.stacks.get(0).render(context.raw(), x, y, delta, -3);
                }
            } else {
                BakedModel model = ((BakedModelManagerAccessor)client.m_91304_()).getModels().getOrDefault(EmiTags.getCustomModel(this.key), client.m_91304_().m_119409_());
                PoseStack vs = RenderSystem.m_157191_();
                vs.m_85836_();
                vs.m_166854_(context.matrices().m_85850_().m_85861_());
                vs.m_85837_((double)x, (double)y, 100.0);
                vs.m_85837_(8.0, 8.0, 0.0);
                vs.m_85841_(1.0f, -1.0f, 1.0f);
                vs.m_85841_(16.0f, 16.0f, 16.0f);
                RenderSystem.m_157182_();
                PoseStack ms = new PoseStack();
                model.m_7442_().m_111808_(ItemTransforms.TransformType.GUI).m_111763_(false, ms);
                ms.m_85837_(-0.5, -0.5, -0.5);
                if (!model.m_7547_()) {
                    Lighting.m_84930_();
                }
                MultiBufferSource.BufferSource immediate = client.m_91269_().m_110104_();
                ((ItemRendererAccessor)client.m_91291_()).invokeRenderBakedItemModel(model, ItemStack.f_41583_, 0xF000F0, OverlayTexture.f_118083_, ms, ItemRenderer.m_115222_((MultiBufferSource)immediate, (RenderType)Sheets.m_110791_(), (boolean)true, (boolean)false));
                immediate.m_109911_();
                if (!model.m_7547_()) {
                    Lighting.m_84931_();
                }
                vs.m_85849_();
                RenderSystem.m_157182_();
            }
        }
        if ((flags & 2) != 0 && !this.key.f_203867_().equals(EmiPort.getFluidRegistry().m_123023_())) {
            Object count = "";
            if (this.amount != 1L) {
                count = (String)count + this.amount;
            }
            EmiRenderHelper.renderAmount(context, x, y, (Component)EmiPort.literal((String)count));
        }
        if ((flags & 4) != 0) {
            EmiRender.renderTagIcon(this, context.raw(), x, y);
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon(this, context.raw(), x, y);
        }
    }

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered(EmiTags.getTagName(this.key))));
        if (EmiUtil.showAdvancedTooltips()) {
            list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal("#" + this.id, ChatFormatting.DARK_GRAY))));
        }
        if (this.key.f_203867_().equals(EmiPort.getFluidRegistry().m_123023_()) && this.amount > 1L) {
            list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered(EmiRenderHelper.getAmountText((EmiIngredient)this, this.amount))));
        }
        if (EmiConfig.appendModId) {
            String mod = EmiUtil.getModName(this.id.m_135827_());
            list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal(mod, ChatFormatting.BLUE, ChatFormatting.ITALIC))));
        }
        list.add(new TagTooltipComponent(this.stacks));
        for (EmiStack stack : this.stacks) {
            if (stack.getRemainder().isEmpty()) continue;
            list.add(new RemainderTooltipComponent(this));
            break;
        }
        return list;
    }
}

