/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetTooltipHolder;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;

public class DrawableWidget
extends Widget
implements WidgetTooltipHolder<DrawableWidget> {
    protected final DrawableWidgetConsumer consumer;
    protected final Bounds bounds;
    protected final int x;
    protected final int y;
    protected BiFunction<Integer, Integer, List<ClientTooltipComponent>> tooltipSupplier = (mouseX, mouseY) -> List.of();

    public DrawableWidget(int x, int y, int w, int h, DrawableWidgetConsumer consumer) {
        this.x = x;
        this.y = y;
        this.bounds = new Bounds(x, y, w, h);
        this.consumer = consumer;
    }

    @Override
    public DrawableWidget tooltip(BiFunction<Integer, Integer, List<ClientTooltipComponent>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        return this.tooltipSupplier.apply(mouseX, mouseY);
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(matrices);
        context.push();
        context.matrices().m_85837_((double)this.x, (double)this.y, 0.0);
        this.consumer.render(context.raw(), mouseX, mouseY, delta);
        context.pop();
    }

    public static interface DrawableWidgetConsumer {
        public void render(PoseStack var1, int var2, int var3, float var4);
    }
}

