/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiResolutionRecipe;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.HelpLevel;
import dev.emi.emi.input.EmiBind;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiFavorites;
import dev.emi.emi.runtime.EmiHistory;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.screen.RecipeScreen;
import dev.emi.emi.screen.tooltip.EmiTooltip;
import dev.emi.emi.screen.tooltip.RecipeCostTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class SlotWidget
extends Widget {
    protected final EmiIngredient stack;
    protected final int x;
    protected final int y;
    protected ResourceLocation textureId;
    protected int u;
    protected int v;
    protected int customWidth;
    protected int customHeight;
    protected boolean drawBack = true;
    protected boolean output = false;
    protected boolean catalyst = false;
    protected boolean custom = false;
    protected List<Supplier<ClientTooltipComponent>> tooltipSuppliers = Lists.newArrayList();
    protected Bounds bounds;
    private EmiRecipe recipe;

    public SlotWidget(EmiIngredient stack, int x, int y) {
        this.stack = stack;
        this.x = x;
        this.y = y;
    }

    public EmiIngredient getStack() {
        return this.stack;
    }

    public EmiRecipe getRecipe() {
        return this.recipe;
    }

    public SlotWidget drawBack(boolean drawBack) {
        this.drawBack = drawBack;
        return this;
    }

    public SlotWidget large(boolean large) {
        this.output = large;
        return this;
    }

    public SlotWidget catalyst(boolean catalyst) {
        this.catalyst = catalyst;
        return this;
    }

    public SlotWidget appendTooltip(Function<EmiIngredient, ClientTooltipComponent> function) {
        return this.appendTooltip(() -> (ClientTooltipComponent)function.apply(this.getStack()));
    }

    public SlotWidget appendTooltip(Supplier<ClientTooltipComponent> supplier) {
        this.tooltipSuppliers.add(supplier);
        return this;
    }

    public SlotWidget appendTooltip(Component text) {
        this.tooltipSuppliers.add(() -> ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered(text)));
        return this;
    }

    public SlotWidget recipeContext(EmiRecipe recipe) {
        this.recipe = recipe;
        return this;
    }

    public SlotWidget backgroundTexture(ResourceLocation id, int u, int v) {
        this.textureId = id;
        this.u = u;
        this.v = v;
        return this;
    }

    public SlotWidget customBackground(ResourceLocation id, int u, int v, int width, int height) {
        this.backgroundTexture(id, u, v);
        this.custom = true;
        this.customWidth = width;
        this.customHeight = height;
        return this;
    }

    @Override
    public Bounds getBounds() {
        if (this.custom) {
            return new Bounds(this.x, this.y, this.customWidth, this.customHeight);
        }
        if (this.output) {
            return new Bounds(this.x, this.y, 26, 26);
        }
        return new Bounds(this.x, this.y, 18, 18);
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        EmiPort.setPositionTexShader();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackground(matrices, mouseX, mouseY, delta);
        this.drawStack(matrices, mouseX, mouseY, delta);
        RenderSystem.m_69465_();
        this.drawOverlay(matrices, mouseX, mouseY, delta);
    }

    public void drawBackground(PoseStack matrices, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(matrices);
        Bounds bounds = this.getBounds();
        int width = bounds.width();
        int height = bounds.height();
        if (this.drawBack) {
            if (this.textureId != null) {
                context.drawTexture(this.textureId, bounds.x(), bounds.y(), width, height, this.u, this.v, width, height, 256, 256);
            } else {
                int v;
                int n = v = this.getStack().getChance() != 1.0f ? bounds.height() : 0;
                if (this.output) {
                    context.drawTexture(EmiRenderHelper.WIDGETS, bounds.x(), bounds.y(), 26, 26, 18.0f, v, 26, 26, 256, 256);
                } else {
                    context.drawTexture(EmiRenderHelper.WIDGETS, bounds.x(), bounds.y(), 18, 18, 0.0f, v, 18, 18, 256, 256);
                }
            }
        }
    }

    public void drawStack(PoseStack matrices, int mouseX, int mouseY, float delta) {
        Bounds bounds = this.getBounds();
        int xOff = (bounds.width() - 16) / 2;
        int yOff = (bounds.height() - 16) / 2;
        this.getStack().render(matrices, bounds.x() + xOff, bounds.y() + yOff, delta);
    }

    public void drawOverlay(PoseStack matrices, int mouseX, int mouseY, float delta) {
        Bounds bounds = this.getBounds();
        int width = bounds.width();
        int height = bounds.height();
        int xOff = (width - 16) / 2;
        int yOff = (height - 16) / 2;
        if (this.catalyst) {
            EmiRender.renderCatalystIcon(this.getStack(), matrices, this.x + xOff, this.y + yOff);
        }
        if (this.shouldDrawSlotHighlight(mouseX, mouseY)) {
            this.drawSlotHighlight(matrices, bounds);
        }
    }

    public boolean shouldDrawSlotHighlight(int mouseX, int mouseY) {
        return this.getBounds().contains(mouseX, mouseY) && EmiConfig.showHoverOverlay;
    }

    public void drawSlotHighlight(PoseStack matrices, Bounds bounds) {
        EmiRenderHelper.drawSlotHightlight(EmiDrawContext.wrap(matrices), bounds.x() + 1, bounds.y() + 1, bounds.width() - 2, bounds.height() - 2, 200);
    }

    @Override
    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        ArrayList list = Lists.newArrayList();
        if (this.getStack().isEmpty()) {
            return list;
        }
        list.addAll(this.getStack().getTooltip());
        this.addSlotTooltip(list);
        return list;
    }

    protected void addSlotTooltip(List<ClientTooltipComponent> list) {
        EmiRecipe recipe;
        for (Supplier<ClientTooltipComponent> supplier : this.tooltipSuppliers) {
            list.add(supplier.get());
        }
        if (this.getStack().getChance() != 1.0f) {
            list.add(EmiTooltip.chance(this.recipe != null ? "produce" : "consume", this.getStack().getChance()));
        }
        if ((recipe = this.getRecipe()) != null) {
            RecipeCostTooltipComponent rctc;
            if (recipe.getId() != null && EmiConfig.showRecipeIds) {
                list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal(recipe.getId().toString(), ChatFormatting.GRAY))));
            }
            if (this.canResolve() && EmiConfig.helpLevel.has(HelpLevel.NORMAL)) {
                if (EmiConfig.viewRecipes.isBound()) {
                    list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable("emi.resolve.resolve", EmiConfig.viewRecipes.getBindText()))));
                }
                if (EmiConfig.defaultStack.isBound()) {
                    list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable("emi.resolve.default", EmiConfig.defaultStack.getBindText()))));
                }
            } else if (EmiConfig.favorite.isBound() && EmiConfig.helpLevel.has(HelpLevel.NORMAL) && EmiFavorites.canFavorite(this.getStack(), this.getRecipe())) {
                list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable("emi.favorite_recipe", EmiConfig.favorite.getBindText()))));
            }
            if (EmiConfig.showCostPerBatch && recipe.supportsRecipeTree() && !(recipe instanceof EmiResolutionRecipe) && (rctc = new RecipeCostTooltipComponent(recipe)).shouldDisplay()) {
                list.add(rctc);
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.slotInteraction(bind -> bind.matchesMouse(button))) {
            return true;
        }
        return EmiScreenManager.stackInteraction(new EmiStackInteraction(this.getStack(), this.getRecipe(), true), bind -> bind.matchesMouse(button));
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.slotInteraction(bind -> bind.matchesKey(keyCode, scanCode))) {
            return true;
        }
        return EmiScreenManager.stackInteraction(new EmiStackInteraction(this.getStack(), this.getRecipe(), true), bind -> bind.matchesKey(keyCode, scanCode));
    }

    private boolean canResolve() {
        EmiRecipe recipe = this.getRecipe();
        return recipe != null && recipe.supportsRecipeTree() && RecipeScreen.resolve != null;
    }

    private boolean slotInteraction(Function<EmiBind, Boolean> function) {
        EmiRecipe recipe = this.getRecipe();
        if (this.canResolve()) {
            if (function.apply(EmiConfig.defaultStack).booleanValue()) {
                BoM.addRecipe(RecipeScreen.resolve, recipe);
                EmiHistory.pop();
                return true;
            }
            if (function.apply(EmiConfig.viewRecipes).booleanValue()) {
                BoM.addResolution(RecipeScreen.resolve, recipe);
                EmiHistory.pop();
                return true;
            }
        } else if (recipe != null && recipe.supportsRecipeTree() && function.apply(EmiConfig.defaultStack).booleanValue()) {
            BoM.addRecipe(this.getStack(), recipe);
            return true;
        }
        return false;
    }
}

