/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.mixin.accessor.SmithingRecipeAccessor;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.UpgradeRecipe;

public class EmiSmithingRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final EmiIngredient input;
    private final EmiIngredient addition;
    private final EmiStack output;

    public EmiSmithingRecipe(UpgradeRecipe recipe) {
        this.id = recipe.m_6423_();
        this.input = EmiIngredient.of(((SmithingRecipeAccessor)recipe).getBase());
        this.addition = EmiIngredient.of(((SmithingRecipeAccessor)recipe).getAddition());
        this.output = EmiStack.of(EmiPort.getOutput(recipe));
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.SMITHING;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(this.input, this.addition);
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    @Override
    public int getDisplayWidth() {
        return 125;
    }

    @Override
    public int getDisplayHeight() {
        return 18;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.PLUS, 27, 3);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 75, 1);
        widgets.addSlot(this.input, 0, 0);
        widgets.addSlot(this.addition, 49, 0);
        widgets.addSlot(this.output, 107, 0).recipeContext(this);
    }
}

