/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.handler.CoercedRecipeHandler;
import dev.emi.emi.mixin.accessor.CraftingResultSlotAccessor;
import dev.emi.emi.runtime.EmiSidebars;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EmiRecipeFiller {
    public static Map<MenuType<?>, List<EmiRecipeHandler<?>>> handlers = Maps.newHashMap();
    public static BiFunction<AbstractContainerMenu, EmiRecipe, EmiRecipeHandler<?>> extraHandlers = (h, r) -> null;

    public static void clear() {
        handlers.clear();
        extraHandlers = (h, r) -> null;
    }

    public static boolean isSupported(EmiRecipe recipe) {
        for (List<EmiRecipeHandler<?>> list : handlers.values()) {
            for (EmiRecipeHandler<?> handler : list) {
                if (!handler.supportsRecipe(recipe) || !handler.alwaysDisplaySupport(recipe)) continue;
                return true;
            }
        }
        AbstractContainerScreen<?> hs = EmiApi.getHandledScreen();
        if (hs != null) {
            for (EmiRecipeHandler<?> emiRecipeHandler : EmiRecipeFiller.getAllHandlers(hs)) {
                if (!emiRecipeHandler.supportsRecipe(recipe)) continue;
                return true;
            }
            EmiRecipeHandler<?> emiRecipeHandler = extraHandlers.apply(hs.m_6262_(), recipe);
            if (emiRecipeHandler != null && emiRecipeHandler.supportsRecipe(recipe)) {
                return true;
            }
        }
        return false;
    }

    public static <T extends AbstractContainerMenu> List<EmiRecipeHandler<T>> getAllHandlers(AbstractContainerScreen<T> screen) {
        if (screen != null) {
            MenuType type;
            AbstractContainerMenu screenHandler = screen.m_6262_();
            try {
                type = screenHandler instanceof InventoryMenu ? null : screenHandler.m_6772_();
            }
            catch (UnsupportedOperationException e) {
                type = null;
            }
            if ((type != null || screenHandler instanceof InventoryMenu) && handlers.containsKey(type)) {
                return handlers.get(type);
            }
            for (Slot slot : screen.m_6262_().f_38839_) {
                ResultSlot crs;
                CraftingContainer inv;
                if (!(slot instanceof ResultSlot) || (inv = ((CraftingResultSlotAccessor)(crs = (ResultSlot)slot)).getInput()) == null || inv.m_39347_() <= 0 || inv.m_39346_() <= 0) continue;
                return List.of(new CoercedRecipeHandler(crs));
            }
        }
        return List.of();
    }

    @Nullable
    public static <T extends AbstractContainerMenu> EmiRecipeHandler<T> getFirstValidHandler(EmiRecipe recipe, AbstractContainerScreen<T> screen) {
        EmiRecipeHandler<?> extra;
        EmiRecipeHandler<Object> ret = null;
        for (EmiRecipeHandler<T> handler : EmiRecipeFiller.getAllHandlers(screen)) {
            if (!handler.supportsRecipe(recipe)) continue;
            ret = handler;
            break;
        }
        if ((ret == null || ret instanceof CoercedRecipeHandler && !(screen instanceof InventoryScreen)) && (extra = extraHandlers.apply(screen.m_6262_(), recipe)) != null) {
            ret = extra;
        }
        return ret;
    }

    public static <T extends AbstractContainerMenu> boolean performFill(EmiRecipe recipe, AbstractContainerScreen<T> screen, EmiCraftContext.Type type, EmiCraftContext.Destination destination, int amount) {
        EmiPlayerInventory inv;
        EmiCraftContext<T> context;
        EmiRecipeHandler<T> handler = EmiRecipeFiller.getFirstValidHandler(recipe, screen);
        if (handler != null && handler.supportsRecipe(recipe) && handler.canCraft(recipe, context = new EmiCraftContext<T>(screen, inv = handler.getInventory(screen), type, destination, amount))) {
            EmiSidebars.craft(recipe);
            return handler.craft(recipe, context);
        }
        return false;
    }

    @Nullable
    public static <T extends AbstractContainerMenu> List<ItemStack> getStacks(StandardRecipeHandler<T> handler, EmiRecipe recipe, AbstractContainerScreen<T> screen, int amount) {
        try {
            AbstractContainerMenu screenHandler = screen.m_6262_();
            if (handler != null) {
                List<Slot> slots = handler.getInputSources(screenHandler);
                List<Slot> craftingSlots = handler.getCraftingSlots(recipe, screenHandler);
                List<EmiIngredient> ingredients = recipe.getInputs();
                ArrayList discovered = Lists.newArrayList();
                Object2IntOpenHashMap weightDivider = new Object2IntOpenHashMap();
                for (int i = 0; i < ingredients.size(); ++i) {
                    Object stack;
                    ArrayList d = Lists.newArrayList();
                    EmiIngredient ingredient = ingredients.get(i);
                    List<EmiStack> emiStacks = ingredient.getEmiStacks();
                    if (ingredient.isEmpty()) {
                        discovered.add(null);
                        continue;
                    }
                    for (int e = 0; e < emiStacks.size(); ++e) {
                        stack = emiStacks.get(e);
                        block4: for (Slot s : slots) {
                            ItemStack ss = s.m_7993_();
                            if (!EmiStack.of(s.m_7993_()).isEqual((EmiStack)stack)) continue;
                            Iterator iterator = d.iterator();
                            while (iterator.hasNext()) {
                                DiscoveredItem di = (DiscoveredItem)iterator.next();
                                if (!ItemStack.m_150942_((ItemStack)ss, (ItemStack)di.stack)) continue;
                                di.amount += ss.m_41613_();
                                continue block4;
                            }
                            d.add(new DiscoveredItem((EmiStack)stack, ss, ss.m_41613_(), (int)ingredient.getAmount(), ss.m_41741_()));
                        }
                    }
                    DiscoveredItem biggest = null;
                    stack = d.iterator();
                    while (stack.hasNext()) {
                        DiscoveredItem di = (DiscoveredItem)stack.next();
                        if (biggest == null) {
                            biggest = di;
                            continue;
                        }
                        int a = di.amount / (weightDivider.getOrDefault((Object)di.ingredient, 0) + di.consumed);
                        int ba = biggest.amount / (weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                        if (ba >= a) continue;
                        biggest = di;
                    }
                    if (biggest == null || i >= craftingSlots.size()) {
                        return null;
                    }
                    Slot slot = craftingSlots.get(i);
                    if (slot == null) {
                        return null;
                    }
                    weightDivider.put((Object)biggest.ingredient, weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                    biggest.max = Math.min(biggest.max, slot.m_6641_());
                    discovered.add(biggest);
                }
                if (discovered.isEmpty()) {
                    return null;
                }
                ArrayList unique = Lists.newArrayList();
                block7: for (Object di : discovered) {
                    if (di == null) continue;
                    for (DiscoveredItem ui : unique) {
                        if (!ItemStack.m_150942_((ItemStack)((DiscoveredItem)di).stack, (ItemStack)ui.stack)) continue;
                        ui.consumed += ((DiscoveredItem)di).consumed;
                        continue block7;
                    }
                    unique.add(new DiscoveredItem(((DiscoveredItem)di).ingredient, ((DiscoveredItem)di).stack, ((DiscoveredItem)di).amount, ((DiscoveredItem)di).consumed, ((DiscoveredItem)di).max));
                }
                int maxAmount = Integer.MAX_VALUE;
                for (DiscoveredItem ui : unique) {
                    if (ui.catalyst()) continue;
                    maxAmount = Math.min(maxAmount, ui.amount / ui.consumed);
                    maxAmount = Math.min(maxAmount, ui.max);
                }
                if ((maxAmount = Math.min(maxAmount, amount + EmiRecipeFiller.batchesAlreadyPresent(recipe, handler, screen))) == 0) {
                    return null;
                }
                ArrayList desired = Lists.newArrayList();
                for (int i = 0; i < discovered.size(); ++i) {
                    DiscoveredItem di = (DiscoveredItem)discovered.get(i);
                    if (di != null) {
                        ItemStack is = di.stack.m_41777_();
                        int a = di.catalyst() ? di.consumed : di.consumed * maxAmount;
                        is.m_41764_(a);
                        desired.add(is);
                        continue;
                    }
                    desired.add(ItemStack.f_41583_);
                }
                return desired;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T extends AbstractContainerMenu> int batchesAlreadyPresent(EmiRecipe recipe, StandardRecipeHandler<T> handler, AbstractContainerScreen<T> screen) {
        List<EmiIngredient> inputs = recipe.getInputs();
        ArrayList stacks = Lists.newArrayList();
        Slot output = handler.getOutputSlot(screen.m_6262_());
        if (output != null && !output.m_7993_().m_41619_() && recipe.getOutputs().size() > 0 && !output.m_7993_().m_41726_(recipe.getOutputs().get(0).getItemStack())) {
            return 0;
        }
        for (Slot slot : handler.getCraftingSlots(recipe, screen.m_6262_())) {
            if (slot != null) {
                stacks.add(slot.m_7993_());
                continue;
            }
            stacks.add(ItemStack.f_41583_);
        }
        long amount = Long.MAX_VALUE;
        block1: for (int i = 0; i < inputs.size(); ++i) {
            EmiIngredient input = inputs.get(i);
            if (input.isEmpty()) {
                if (((ItemStack)stacks.get(i)).m_41619_()) continue;
                return 0;
            }
            if (i >= stacks.size()) {
                return 0;
            }
            EmiStack es = EmiStack.of((ItemStack)stacks.get(i));
            for (EmiStack v : input.getEmiStacks()) {
                if (v.isEmpty() || !v.isEqual(es) || es.getAmount() < v.getAmount()) continue;
                amount = Math.min(amount, es.getAmount() / v.getAmount());
                continue block1;
            }
            return 0;
        }
        if (amount < Long.MAX_VALUE && amount > 0L) {
            return (int)amount;
        }
        return 0;
    }

    public static <T extends AbstractContainerMenu> boolean clientFill(StandardRecipeHandler<T> handler, EmiRecipe recipe, AbstractContainerScreen<T> screen, List<ItemStack> stacks, EmiCraftContext.Destination destination) {
        AbstractContainerMenu screenHandler = screen.m_6262_();
        if (handler != null && screenHandler.m_142621_().m_41619_()) {
            Minecraft client = Minecraft.m_91087_();
            MultiPlayerGameMode manager = client.f_91072_;
            LocalPlayer player = client.f_91074_;
            List<Slot> clear = handler.getCraftingSlots(screenHandler);
            for (Slot slot : clear) {
                if (slot == null) continue;
                manager.m_171799_(screenHandler.f_38840_, slot.f_40219_, 0, ClickType.QUICK_MOVE, (Player)player);
            }
            List<Slot> inputs = handler.getInputSources(screenHandler);
            List<Slot> slots = handler.getCraftingSlots(recipe, screenHandler);
            block1: for (int i = 0; i < stacks.size(); ++i) {
                ItemStack stack = stacks.get(i);
                if (stack.m_41619_()) continue;
                if (i >= slots.size()) {
                    return false;
                }
                Slot crafting = slots.get(i);
                if (crafting == null) {
                    return false;
                }
                int needed = stack.m_41613_();
                for (Slot input : inputs) {
                    if (slots.contains(input)) continue;
                    ItemStack is = input.m_7993_().m_41777_();
                    if (ItemStack.m_150942_((ItemStack)is, (ItemStack)stack)) {
                        manager.m_171799_(screenHandler.f_38840_, input.f_40219_, 0, ClickType.PICKUP, (Player)player);
                        if (is.m_41613_() <= needed) {
                            needed -= is.m_41613_();
                            manager.m_171799_(screenHandler.f_38840_, crafting.f_40219_, 0, ClickType.PICKUP, (Player)player);
                        } else {
                            while (needed > 0) {
                                manager.m_171799_(screenHandler.f_38840_, crafting.f_40219_, 1, ClickType.PICKUP, (Player)player);
                                --needed;
                            }
                            manager.m_171799_(screenHandler.f_38840_, input.f_40219_, 0, ClickType.PICKUP, (Player)player);
                        }
                    }
                    if (needed != 0) continue;
                    continue block1;
                }
                return false;
            }
            Slot slot = handler.getOutputSlot(screenHandler);
            if (slot != null) {
                if (destination == EmiCraftContext.Destination.CURSOR) {
                    manager.m_171799_(screenHandler.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)player);
                } else if (destination == EmiCraftContext.Destination.INVENTORY) {
                    manager.m_171799_(screenHandler.f_38840_, slot.f_40219_, 0, ClickType.QUICK_MOVE, (Player)player);
                }
            }
            return true;
        }
        return false;
    }

    private static class DiscoveredItem {
        private static final Comparison COMPARISON = Comparison.DEFAULT_COMPARISON;
        public EmiStack ingredient;
        public ItemStack stack;
        public int consumed;
        public int amount;
        public int max;

        public DiscoveredItem(EmiStack ingredient, ItemStack stack, int amount, int consumed, int max) {
            this.ingredient = ingredient;
            this.stack = stack.m_41777_();
            this.amount = amount;
            this.consumed = consumed;
            this.max = max;
        }

        public boolean catalyst() {
            return this.ingredient.getRemainder().isEqual(this.ingredient, COMPARISON);
        }
    }
}

