/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.IndexSource;
import dev.emi.emi.data.EmiData;
import dev.emi.emi.data.IndexStackData;
import dev.emi.emi.registry.EmiComparisonDefaults;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiLog;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class EmiStackList {
    private static final TagKey<Item> ITEM_HIDDEN = TagKey.m_203882_((ResourceKey)EmiPort.getItemRegistry().m_123023_(), (ResourceLocation)EmiTags.HIDDEN_FROM_RECIPE_VIEWERS);
    private static final TagKey<Block> BLOCK_HIDDEN = TagKey.m_203882_((ResourceKey)EmiPort.getBlockRegistry().m_123023_(), (ResourceLocation)EmiTags.HIDDEN_FROM_RECIPE_VIEWERS);
    private static final TagKey<Fluid> FLUID_HIDDEN = TagKey.m_203882_((ResourceKey)EmiPort.getFluidRegistry().m_123023_(), (ResourceLocation)EmiTags.HIDDEN_FROM_RECIPE_VIEWERS);
    public static List<Predicate<EmiStack>> invalidators = Lists.newArrayList();
    public static List<EmiStack> stacks = List.of();
    public static List<EmiStack> filteredStacks = List.of();
    private static Object2IntMap<EmiStack> strictIndices = new Object2IntOpenCustomHashMap((Hash.Strategy)new StrictHashStrategy());
    private static Object2IntMap<Object> keyIndices = new Object2IntOpenHashMap();

    public static void clear() {
        invalidators.clear();
        stacks = List.of();
        strictIndices.clear();
        keyIndices.clear();
    }

    public static void reload() {
        String itemName;
        ArrayList groups = Lists.newArrayList();
        LinkedHashMap<String, IndexGroup> namespaceGroups = new LinkedHashMap<String, IndexGroup>();
        LinkedHashMap<String, IndexGroup> creativeGroups = new LinkedHashMap<String, IndexGroup>();
        for (Item item : EmiPort.getItemRegistry()) {
            itemName = "null";
            try {
                itemName = item.toString();
                EmiStack stack = EmiStack.of((ItemLike)item);
                namespaceGroups.computeIfAbsent(stack.getId().m_135827_(), (Function<String, IndexGroup>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$reload$0(java.lang.String ), (Ljava/lang/String;)Ldev/emi/emi/registry/EmiStackList$IndexGroup;)()).stacks.add(stack);
            }
            catch (Exception e) {
                EmiLog.error("Item " + itemName + " threw while EMI was attempting to construct the index, items may be missing.");
                EmiLog.error(e);
            }
        }
        for (Item item : EmiPort.getItemRegistry()) {
            itemName = "null";
            try {
                itemName = item.toString();
                NonNullList itemStacks = NonNullList.m_122779_();
                item.m_6787_(CreativeModeTab.f_40754_, itemStacks);
                List<EmiStack> stacks = itemStacks.stream().filter(s -> !s.m_41619_()).map(EmiStack::of).toList();
                if (stacks.isEmpty()) continue;
                creativeGroups.computeIfAbsent(stacks.get((int)0).getId().m_135827_(), (Function<String, IndexGroup>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$reload$2(java.lang.String ), (Ljava/lang/String;)Ldev/emi/emi/registry/EmiStackList$IndexGroup;)()).stacks.addAll(stacks);
            }
            catch (Exception e) {
                EmiLog.error("Item " + itemName + " threw while EMI was attempting to construct the index, items may be missing.");
                EmiLog.error(e);
            }
        }
        if (EmiConfig.indexSource == IndexSource.CREATIVE) {
            for (Object namespace : namespaceGroups.keySet()) {
                if (!creativeGroups.containsKey(namespace)) continue;
                IndexGroup ng = (IndexGroup)namespaceGroups.get(namespace);
                IndexGroup cg = (IndexGroup)creativeGroups.get(namespace);
                if (cg.stacks.size() * 3 < ng.stacks.size()) continue;
                ng.suppressedBy.add(cg);
            }
        }
        if (EmiConfig.indexSource != IndexSource.REGISTERED) {
            groups.addAll(creativeGroups.values());
        }
        groups.addAll(namespaceGroups.values());
        IndexGroup fluidGroup = new IndexGroup();
        for (Fluid fluid : EmiPort.getFluidRegistry()) {
            String fluidName = null;
            try {
                FlowingFluid ff;
                fluidName = fluid.toString();
                if (!fluid.m_7444_(fluid.m_76145_()) && (!(fluid instanceof FlowingFluid) || (ff = (FlowingFluid)fluid).m_5613_() != Fluids.f_76191_)) continue;
                EmiStack fs = EmiStack.of(fluid);
                fluidGroup.stacks.add(fs);
            }
            catch (Exception e) {
                EmiLog.error("Fluid  " + fluidName + " threw while EMI was attempting to construct the index, stack may be missing.");
                EmiLog.error(e);
            }
        }
        groups.add(fluidGroup);
        ObjectOpenCustomHashSet added = new ObjectOpenCustomHashSet((Hash.Strategy)new StrictHashStrategy());
        stacks = Lists.newLinkedList();
        for (IndexGroup group : groups) {
            if (!group.shouldDisplay()) continue;
            for (EmiStack stack : group.stacks) {
                if (added.contains(stack)) continue;
                stacks.add(stack);
                added.add(stack);
            }
        }
    }

    public static void bake() {
        stacks.removeIf(s -> {
            try {
                if (s.isEmpty()) {
                    return true;
                }
                for (Predicate<EmiStack> invalidator : invalidators) {
                    if (!invalidator.test((EmiStack)s)) continue;
                    return true;
                }
                Object patt5329$temp = s.getKey();
                if (patt5329$temp instanceof Item) {
                    BlockItem bi;
                    Item i = (Item)patt5329$temp;
                    if (i instanceof BlockItem && (bi = (BlockItem)i).m_40614_().m_49966_().m_204336_(BLOCK_HIDDEN)) {
                        return true;
                    }
                    if (s.getItemStack().m_204117_(ITEM_HIDDEN)) {
                        return true;
                    }
                } else {
                    Fluid f;
                    Object patt5567$temp = s.getKey();
                    if (patt5567$temp instanceof Fluid && (f = (Fluid)patt5567$temp).m_205067_(FLUID_HIDDEN)) {
                        return true;
                    }
                }
                return false;
            }
            catch (Throwable t) {
                EmiLog.error("Stack threw error while baking");
                t.printStackTrace();
                return true;
            }
        });
        for (Supplier supplier : EmiData.stackData) {
            IndexStackData ssd = (IndexStackData)supplier.get();
            if (!ssd.removed().isEmpty()) {
                HashSet removed = Sets.newHashSet();
                for (EmiIngredient invalidator : ssd.removed()) {
                    for (EmiStack stack2 : invalidator.getEmiStacks()) {
                        removed.add(stack2.copy().comparison(c -> EmiPort.compareStrict()));
                    }
                }
                stacks.removeAll(removed);
            }
            if (!ssd.filters().isEmpty()) {
                stacks.removeIf(s -> {
                    String id = "" + s.getId();
                    for (IndexStackData.Filter filter : ssd.filters()) {
                        if (!filter.filter().test(id)) continue;
                        return true;
                    }
                    return false;
                });
            }
            for (IndexStackData.Added added : ssd.added()) {
                if (added.added().isEmpty()) continue;
                if (added.after().isEmpty()) {
                    stacks.add(added.added().getEmiStacks().get(0));
                    continue;
                }
                int i = stacks.indexOf(added.after());
                if (i == -1) {
                    i = stacks.size() - 1;
                }
                stacks.add(i + 1, added.added().getEmiStacks().get(0));
            }
        }
        stacks = stacks.stream().filter(stack -> {
            String name = "Unknown";
            String id = "unknown";
            try {
                if (stack.isEmpty()) {
                    return false;
                }
                name = stack.toString();
                id = stack.getId().toString();
                if (name != null && stack.getKey() != null && stack.getName() != null) {
                    return true;
                }
                EmiLog.warn("Hiding stack " + name + " with id " + id + " from index due to returning dangerous values");
                return false;
            }
            catch (Throwable t) {
                EmiLog.warn("Hiding stack " + name + " with id " + id + " from index due to throwing errors");
                t.printStackTrace();
                return false;
            }
        }).toList();
        for (int i = 0; i < stacks.size(); ++i) {
            EmiStack emiStack = stacks.get(i);
            strictIndices.put((Object)emiStack, i);
            keyIndices.put(emiStack.getKey(), i);
        }
        EmiStackList.bakeFiltered();
    }

    public static void bakeFiltered() {
        filteredStacks = stacks.stream().filter(s -> !EmiHidden.isDisabled(s) && !EmiHidden.isHidden(s)).toList();
    }

    public static int getIndex(EmiIngredient ingredient) {
        EmiStack stack = ingredient.getEmiStacks().get(0);
        int ret = strictIndices.getOrDefault((Object)stack, Integer.MAX_VALUE);
        if (ret == Integer.MAX_VALUE) {
            ret = keyIndices.getOrDefault((Object)stack, ret);
        }
        return ret;
    }

    private static /* synthetic */ IndexGroup lambda$reload$2(String k) {
        return new IndexGroup();
    }

    private static /* synthetic */ IndexGroup lambda$reload$0(String k) {
        return new IndexGroup();
    }

    public static class IndexGroup {
        public List<EmiStack> stacks = Lists.newArrayList();
        public Set<IndexGroup> suppressedBy = Sets.newHashSet();

        public boolean shouldDisplay() {
            for (IndexGroup suppressor : this.suppressedBy) {
                if (!suppressor.shouldDisplay()) continue;
                return false;
            }
            return true;
        }
    }

    public static class StrictHashStrategy
    implements Hash.Strategy<EmiStack> {
        public boolean equals(EmiStack a, EmiStack b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.isEmpty() && b.isEmpty()) {
                return true;
            }
            return a.isEqual(b, EmiPort.compareStrict());
        }

        public int hashCode(EmiStack stack) {
            if (stack != null) {
                CompoundTag nbtCompound = stack.getNbt();
                int i = 31 + stack.getKey().hashCode();
                return 31 * i + (nbtCompound == null ? 0 : nbtCompound.hashCode());
            }
            return 0;
        }
    }

    public static class ComparisonHashStrategy
    implements Hash.Strategy<EmiStack> {
        public boolean equals(EmiStack a, EmiStack b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.isEmpty() && b.isEmpty()) {
                return true;
            }
            return a.isEqual(b, EmiComparisonDefaults.get(a.getKey()));
        }

        public int hashCode(EmiStack stack) {
            if (stack != null) {
                int i = 31 + stack.getKey().hashCode();
                return 31 * i + EmiComparisonDefaults.get(stack.getKey()).getHash(stack);
            }
            return 0;
        }
    }
}

