/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class EmiDrawContext {
    private final Minecraft client = Minecraft.m_91087_();
    private final PoseStack matrices;

    private EmiDrawContext(PoseStack matrices) {
        this.matrices = matrices;
    }

    public static EmiDrawContext wrap(PoseStack matrices) {
        return new EmiDrawContext(matrices);
    }

    public PoseStack raw() {
        return this.matrices;
    }

    public PoseStack matrices() {
        return this.matrices;
    }

    public void push() {
        this.matrices.m_85836_();
    }

    public void pop() {
        this.matrices.m_85849_();
    }

    public void drawTexture(ResourceLocation texture, int x, int y, int u, int v, int width, int height) {
        this.drawTexture(texture, x, y, width, height, u, v, width, height, 256, 256);
    }

    public void drawTexture(ResourceLocation texture, int x, int y, int z, float u, float v, int width, int height) {
        this.drawTexture(texture, x, y, z, u, v, width, height, 256, 256);
    }

    public void drawTexture(ResourceLocation texture, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        EmiPort.setPositionTexShader();
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93143_((PoseStack)this.matrices, (int)x, (int)y, (int)z, (float)u, (float)v, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
    }

    public void drawTexture(ResourceLocation texture, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        EmiPort.setPositionTexShader();
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93160_((PoseStack)this.matrices, (int)x, (int)y, (int)width, (int)height, (float)u, (float)v, (int)regionWidth, (int)regionHeight, (int)textureWidth, (int)textureHeight);
    }

    public void fill(int x, int y, int width, int height, int color) {
        GuiComponent.m_93172_((PoseStack)this.matrices, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    public void drawText(Component text, int x, int y) {
        this.drawText(text, x, y, -1);
    }

    public void drawText(Component text, int x, int y, int color) {
        this.client.f_91062_.m_92889_(this.matrices, text, (float)x, (float)y, color);
    }

    public void drawText(FormattedCharSequence text, int x, int y, int color) {
        this.client.f_91062_.m_92877_(this.matrices, text, (float)x, (float)y, color);
    }

    public void drawTextWithShadow(Component text, int x, int y) {
        this.drawTextWithShadow(text, x, y, -1);
    }

    public void drawTextWithShadow(Component text, int x, int y, int color) {
        this.client.f_91062_.m_92763_(this.matrices, text, (float)x, (float)y, color);
    }

    public void drawTextWithShadow(FormattedCharSequence text, int x, int y, int color) {
        this.client.f_91062_.m_92744_(this.matrices, text, (float)x, (float)y, color);
    }

    public void drawCenteredText(Component text, int x, int y) {
        this.drawCenteredText(text, x, y, -1);
    }

    public void drawCenteredText(Component text, int x, int y, int color) {
        this.client.f_91062_.m_92889_(this.matrices, text, (float)(x - this.client.f_91062_.m_92852_((FormattedText)text) / 2), (float)y, color);
    }

    public void drawCenteredTextWithShadow(Component text, int x, int y) {
        this.drawCenteredTextWithShadow(text, x, y, -1);
    }

    public void drawCenteredTextWithShadow(Component text, int x, int y, int color) {
        GuiComponent.m_168749_((PoseStack)this.matrices, (Font)this.client.f_91062_, (FormattedCharSequence)text.m_7532_(), (int)x, (int)y, (int)color);
    }

    public void resetColor() {
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void setColor(float r, float g, float b) {
        this.setColor(r, g, b, 1.0f);
    }

    public void setColor(float r, float g, float b, float a) {
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
    }

    public void drawStack(EmiIngredient stack, int x, int y) {
        stack.render(this.raw(), x, y, this.client.m_91296_());
    }

    public void drawStack(EmiIngredient stack, int x, int y, int flags) {
        this.drawStack(stack, x, y, this.client.m_91296_(), flags);
    }

    public void drawStack(EmiIngredient stack, int x, int y, float delta, int flags) {
        stack.render(this.raw(), x, y, delta, flags);
    }
}

