/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import dev.emi.emi.EmiPort;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiLog;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class EmiScreenshotRecorder {
    private static final String SCREENSHOTS_DIRNAME = "screenshots";

    public static void saveScreenshot(String path, int width, int height, Runnable renderer) {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> EmiScreenshotRecorder.saveScreenshotInner(path, width, height, renderer));
        } else {
            EmiScreenshotRecorder.saveScreenshotInner(path, width, height, renderer);
        }
    }

    private static void saveScreenshotInner(String path, int width, int height, Runnable renderer) {
        Minecraft client = Minecraft.m_91087_();
        int scale = EmiConfig.recipeScreenshotScale < 1 ? EmiPort.getGuiScale(client) : EmiConfig.recipeScreenshotScale;
        TextureTarget framebuffer = new TextureTarget(width * scale, height * scale, true, Minecraft.f_91002_);
        framebuffer.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        framebuffer.m_83954_(Minecraft.f_91002_);
        framebuffer.m_83947_(true);
        PoseStack view = RenderSystem.m_157191_();
        view.m_85836_();
        view.m_166856_();
        view.m_85837_(-1.0, 1.0, 0.0);
        view.m_85841_(2.0f / (float)width, -2.0f / (float)height, -0.001f);
        view.m_85837_(0.0, 0.0, 10.0);
        RenderSystem.m_157182_();
        Matrix4f backupProj = RenderSystem.m_157192_();
        RenderSystem.m_157425_((Matrix4f)((Matrix4f)Util.m_137469_((Object)new Matrix4f(), Matrix4f::m_27624_)));
        renderer.run();
        RenderSystem.m_157425_((Matrix4f)backupProj);
        view.m_85849_();
        RenderSystem.m_157182_();
        framebuffer.m_83970_();
        client.m_91385_().m_83947_(true);
        EmiScreenshotRecorder.saveScreenshotInner(client.f_91069_, path, (RenderTarget)framebuffer, (Component message) -> client.execute(() -> client.f_91065_.m_93076_().m_93785_(message)));
    }

    private static void saveScreenshotInner(File gameDirectory, String suggestedPath, RenderTarget framebuffer, Consumer<Component> messageReceiver) {
        NativeImage nativeImage = EmiScreenshotRecorder.takeScreenshot(framebuffer);
        File screenshots = new File(gameDirectory, SCREENSHOTS_DIRNAME);
        screenshots.mkdir();
        String filename = EmiScreenshotRecorder.getScreenshotFilename(screenshots, suggestedPath);
        File file = new File(screenshots, filename);
        File parent = file.getParentFile();
        parent.mkdirs();
        Util.m_183992_().execute(() -> {
            try {
                nativeImage.m_85056_(file);
                MutableComponent text = EmiPort.literal(filename, Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
                messageReceiver.accept((Component)EmiPort.translatable("screenshot.success", text));
            }
            catch (Throwable e) {
                EmiLog.error("Failed to write screenshot");
                e.printStackTrace();
                messageReceiver.accept((Component)EmiPort.translatable("screenshot.failure", e.getMessage()));
            }
            finally {
                nativeImage.close();
            }
        });
    }

    private static NativeImage takeScreenshot(RenderTarget framebuffer) {
        int i = framebuffer.f_83915_;
        int j = framebuffer.f_83916_;
        NativeImage nativeImage = new NativeImage(i, j, false);
        RenderSystem.m_69396_((int)framebuffer.m_83975_());
        nativeImage.m_85045_(0, false);
        nativeImage.m_85122_();
        return nativeImage;
    }

    private static String getScreenshotFilename(File directory, String path) {
        int i = 1;
        while (new File(directory, path + (String)(i == 1 ? "" : "_" + i) + ".png").exists()) {
            ++i;
        }
        return path + (String)(i == 1 ? "" : "_" + i) + ".png";
    }
}

