/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.ConfigScreen;
import dev.emi.emi.screen.widget.config.EmiNameWidget;
import dev.emi.emi.screen.widget.config.ListWidget;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;

public class ConfigEnumScreen<T>
extends Screen {
    private final ConfigScreen last;
    private final List<Entry<T>> entries;
    private final Consumer<T> selection;
    private ListWidget list;

    public ConfigEnumScreen(ConfigScreen last, List<Entry<T>> entries, Consumer<T> selection) {
        super((Component)EmiPort.translatable("screen.emi.config"));
        this.last = last;
        this.entries = entries;
        this.selection = selection;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_169394_(new EmiNameWidget(this.f_96543_ / 2, 16));
        int w = 200;
        int x = (this.f_96543_ - w) / 2;
        this.m_142416_((GuiEventListener)EmiPort.newButton(x, this.f_96544_ - 30, w, 20, (Component)EmiPort.translatable("gui.done"), button -> this.m_7379_()));
        this.list = new ListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 40, this.f_96544_ - 40);
        for (Entry<T> e : this.entries) {
            this.list.addEntry(new SelectionWidget<T>(this, e));
        }
        this.m_7787_((GuiEventListener)this.list);
    }

    public void m_6305_(PoseStack raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.list.setScrollAmount(this.list.getScrollAmount());
        this.m_96626_(0);
        this.list.m_6305_(context.raw(), mouseX, mouseY, delta);
        super.m_6305_(context.raw(), mouseX, mouseY, delta);
        ListWidget.Entry entry = this.list.getHoveredEntry();
        if (entry instanceof SelectionWidget) {
            SelectionWidget widget = (SelectionWidget)entry;
            if (widget.button.m_198029_()) {
                EmiRenderHelper.drawTooltip(this, context, widget.tooltip, mouseX, mouseY);
            }
        }
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_((Screen)this.last);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        if (keyCode == 258) {
            return false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public record Entry<T>(T value, Component name, List<ClientTooltipComponent> tooltip) {
    }

    public static class SelectionWidget<T>
    extends ListWidget.Entry {
        private final Button button;
        private final List<ClientTooltipComponent> tooltip;

        public SelectionWidget(ConfigEnumScreen<T> screen, Entry<T> e) {
            this.button = EmiPort.newButton(0, 0, 200, 20, e.name(), t -> {
                screen.selection.accept(e.value());
                screen.m_7379_();
            });
            this.tooltip = e.tooltip();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.button);
        }

        @Override
        public void render(PoseStack raw, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            this.button.f_93621_ = y;
            this.button.f_93620_ = x + width / 2 - this.button.m_5711_() / 2;
            this.button.m_6305_(raw, mouseX, mouseY, delta);
        }

        @Override
        public int getHeight() {
            return 20;
        }
    }
}

