/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.widget.DrawableWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.widget.RecipeBackground;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;

public class WidgetGroup
implements WidgetHolder {
    public final EmiRecipe recipe;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final List<Widget> widgets = Lists.newArrayList();

    public WidgetGroup(EmiRecipe recipe, int x, int y, int width, int height) {
        this.recipe = recipe;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (recipe != null) {
            this.widgets.add(new RecipeBackground(-4, -4, width + 8, height + 8));
        }
    }

    public void error(Throwable e) {
        this.widgets.clear();
        this.widgets.add(new RecipeBackground(-4, -4, this.width + 8, this.height + 8));
        this.widgets.add(new TextWidget(EmiPort.ordered((Component)EmiPort.translatable("emi.error.recipe.render")), this.width / 2, this.height / 2 - 5, ChatFormatting.RED.m_126665_(), true).horizontalAlign(TextWidget.Alignment.CENTER));
        this.widgets.add((Widget)new DrawableWidget(0, 0, this.width, this.height, (raw, mouseX, mouseY, delta) -> {}).tooltip((i, j) -> EmiUtil.getStackTrace(e).stream().map(EmiPort::literal).map(EmiPort::ordered).map(ClientTooltipComponent::m_169948_).toList()));
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public <T extends Widget> T add(T widget) {
        this.widgets.add(widget);
        return widget;
    }
}

