/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget.config;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.widget.config.GroupNameWidget;
import dev.emi.emi.screen.widget.config.ListWidget;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;

public abstract class ConfigEntryWidget
extends ListWidget.Entry {
    private final Component name;
    private final List<ClientTooltipComponent> tooltip;
    protected final Supplier<String> search;
    private final int height;
    public EmiConfig.ConfigGroup group;
    public boolean endGroup = false;
    private List<? extends GuiEventListener> children = List.of();
    public List<GroupNameWidget> parentGroups = Lists.newArrayList();

    public ConfigEntryWidget(Component name, List<ClientTooltipComponent> tooltip, Supplier<String> search, int height) {
        this.name = name;
        this.tooltip = tooltip;
        this.search = search;
        this.height = height;
    }

    public void setChildren(List<? extends GuiEventListener> children) {
        this.children = children;
    }

    public void update(int y, int x, int width, int height) {
    }

    @Override
    public void render(PoseStack raw, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        if (this.group != null) {
            context.fill(x + 4, y + height / 2 - 1, 6, 2, -1);
            if (this.endGroup) {
                context.fill(x + 2, y - 4, 2, height / 2 + 5, -1);
            } else {
                context.fill(x + 2, y - 4, 2, height + 4, -1);
            }
            x += 10;
            width -= 10;
        }
        this.update(y, x, width, height);
        context.fill(x, y, width, height, 0x66000000);
        Objects.requireNonNull(this.parentList.client.f_91062_);
        context.drawTextWithShadow(this.name, x + 6, y + 10 - 9 / 2, 0xFFFFFF);
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!(guiEventListener instanceof Widget)) continue;
            Widget drawable = (Widget)guiEventListener;
            drawable.m_6305_(context.raw(), mouseX, mouseY, delta);
        }
    }

    @Override
    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        return this.tooltip;
    }

    public String getSearchableText() {
        return this.name.getString();
    }

    public boolean isParentVisible() {
        for (GroupNameWidget g : this.parentGroups) {
            if (!g.collapsed) continue;
            return false;
        }
        return true;
    }

    public boolean isVisible() {
        String s = this.search.get().toLowerCase();
        if (this.getSearchableText().toLowerCase().contains(s)) {
            return true;
        }
        for (GroupNameWidget g : this.parentGroups) {
            if (!g.text.getString().toLowerCase().contains(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getHeight() {
        if (this.isParentVisible() && this.isVisible()) {
            return this.height;
        }
        return 0;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }
}

