/*
 * Decompiled with CFR 0.152.
 */
package net.onvoid.copperized.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.onvoid.copperized.common.CopperizedLootModifiers;
import net.onvoid.copperized.common.config.CopperizedConfig;
import org.jetbrains.annotations.NotNull;

public class AddItemLootModifier
extends LootModifier {
    public static final Codec<AddItemLootModifier> CODEC = RecordCodecBuilder.create(inst -> AddItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(g -> g.item)).and((App)Codec.INT.fieldOf("minAmount").forGetter(g -> g.minAmount)).and((App)Codec.INT.fieldOf("minAmount").forGetter(g -> g.maxAmount)).and((App)Codec.BOOL.fieldOf("unique").forGetter(g -> g.unique)).apply((Applicative)inst, AddItemLootModifier::new));
    private final Item item;
    private final int minAmount;
    private final int maxAmount;
    private final boolean unique;

    public AddItemLootModifier(LootItemCondition[] conditions, Item item, int minAmount, int maxAmount, boolean unique) {
        super(conditions);
        this.item = item;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.unique = unique;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String name = ForgeRegistries.ITEMS.getKey((Object)this.item).m_135815_();
        if (CopperizedConfig.CONFIG.stuff.containsKey(name) && (Boolean)CopperizedConfig.CONFIG.stuff.get(name).get() != false || this.unique && generatedLoot.stream().anyMatch(stack -> stack.m_41720_().equals(this.item)) || this.maxAmount < 1) {
            return generatedLoot;
        }
        int amount = context.m_230907_().m_188503_(this.maxAmount + 1 - this.minAmount) + this.minAmount;
        return amount >= 1 ? AddItemLootModifier.with(generatedLoot, new ItemStack((ItemLike)this.item, amount)) : generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CopperizedLootModifiers.ADD_ITEM.get();
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, ItemStack addition) {
        before.add((Object)addition);
        return before;
    }
}

