/*
 * Decompiled with CFR 0.152.
 */
package net.onvoid.copperized.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.onvoid.copperized.common.CopperizedLootModifiers;
import org.jetbrains.annotations.NotNull;

public class EnchantedAddItemLootModifier
extends LootModifier {
    public static final Codec<EnchantedAddItemLootModifier> CODEC = RecordCodecBuilder.create(inst -> EnchantedAddItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(g -> g.item)).and((App)ForgeRegistries.ENCHANTMENTS.getCodec().fieldOf("enchantment").forGetter(g -> g.enchantment)).and((App)Codec.INT.fieldOf("level").forGetter(g -> g.level)).and((App)Codec.BOOL.fieldOf("unique").forGetter(g -> g.unique)).apply((Applicative)inst, EnchantedAddItemLootModifier::new));
    private final Item item;
    private final Enchantment enchantment;
    private final int level;
    private final boolean unique;

    public EnchantedAddItemLootModifier(LootItemCondition[] conditions, Item item, Enchantment enchantment, int level, boolean unique) {
        super(conditions);
        this.item = item;
        this.enchantment = enchantment;
        this.level = level;
        this.unique = unique;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.unique && generatedLoot.stream().anyMatch(stack -> stack.m_41720_().equals(this.item))) {
            return generatedLoot;
        }
        ItemStack ench = new ItemStack((ItemLike)this.item);
        EnchantmentHelper.m_44865_(Map.of(this.enchantment, this.level), (ItemStack)ench);
        return EnchantedAddItemLootModifier.with(generatedLoot, ench);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CopperizedLootModifiers.ADD_ITEM.get();
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, ItemStack addition) {
        before.add((Object)addition);
        return before;
    }
}

