/*
 * Decompiled with CFR 0.152.
 */
package net.onvoid.copperized.common.compat.jei;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraftforge.fml.ModList;
import net.onvoid.copperized.common.CopperMaps;
import net.onvoid.copperized.common.compat.jei.AxeScrapingRecipe;
import net.onvoid.copperized.common.compat.jei.AxeScrapingRecipeCategory;
import net.onvoid.copperized.common.compat.jei.OxidationRecipe;
import net.onvoid.copperized.common.compat.jei.OxidationRecipeCategory;
import net.onvoid.copperized.common.compat.jei.WaxingRecipe;
import net.onvoid.copperized.common.compat.jei.WaxingRecipeCategory;
import net.onvoid.copperized.common.compat.quark.QuarkMaps;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class CopperizedJEIPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("copperized", "jei");
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("copperized", "textures/jei/gui.png");
    private static final ArrayList<OxidationRecipe> oxidationRecipes = new ArrayList();
    private static final ArrayList<WaxingRecipe> waxingRecipes = new ArrayList();
    private static final ArrayList<AxeScrapingRecipe> axeScrapingRecipes = new ArrayList();
    public static final RecipeType<OxidationRecipe> OXIDATION = RecipeType.create((String)"copperized", (String)"oxidation", OxidationRecipe.class);
    public static final RecipeType<WaxingRecipe> WAXING = RecipeType.create((String)"copperized", (String)"waxing", WaxingRecipe.class);
    public static final RecipeType<AxeScrapingRecipe> AXE_SCRAPING = RecipeType.create((String)"copperized", (String)"axe_scraping", AxeScrapingRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        super.registerCategories(registration);
        registration.addRecipeCategories(new IRecipeCategory[]{new OxidationRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new WaxingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AxeScrapingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        super.registerRecipes(registration);
        ((BiMap)WeatheringCopper.f_154886_.get()).forEach((blockFrom, blockTo) -> oxidationRecipes.add(new OxidationRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
        CopperMaps.NEXT_BY_BLOCK.get().forEach((blockFrom, blockTo) -> oxidationRecipes.add(new OxidationRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
        if (ModList.get().isLoaded("quark")) {
            QuarkMaps.NEXT_BY_BLOCK.get().forEach((blockFrom, blockTo) -> oxidationRecipes.add(new OxidationRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
        }
        registration.addRecipes(OXIDATION, oxidationRecipes);
        ((BiMap)HoneycombItem.f_150863_.get()).forEach((blockFrom, blockTo) -> waxingRecipes.add(new WaxingRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
        CopperMaps.WAXABLES.get().forEach((blockFrom, blockTo) -> waxingRecipes.add(new WaxingRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
        if (ModList.get().isLoaded("quark")) {
            QuarkMaps.WAXABLES.get().forEach((blockFrom, blockTo) -> waxingRecipes.add(new WaxingRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
        }
        registration.addRecipes(WAXING, waxingRecipes);
        ((BiMap)HoneycombItem.f_150864_.get()).forEach((blockFrom, blockTo) -> axeScrapingRecipes.add(new AxeScrapingRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
        CopperMaps.WAX_OFF_BY_BLOCK.get().forEach((blockFrom, blockTo) -> axeScrapingRecipes.add(new AxeScrapingRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
        ((BiMap)WeatheringCopper.f_154887_.get()).forEach((blockFrom, blockTo) -> axeScrapingRecipes.add(new AxeScrapingRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
        CopperMaps.PREVIOUS_BY_BLOCK.get().forEach((blockFrom, blockTo) -> axeScrapingRecipes.add(new AxeScrapingRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
        if (ModList.get().isLoaded("quark")) {
            QuarkMaps.PREVIOUS_BY_BLOCK.get().forEach((blockFrom, blockTo) -> axeScrapingRecipes.add(new AxeScrapingRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
            QuarkMaps.WAX_OFF_BY_BLOCK.get().forEach((blockFrom, blockTo) -> axeScrapingRecipes.add(new AxeScrapingRecipe(new ItemStack((ItemLike)blockFrom), new ItemStack((ItemLike)blockTo))));
        }
        registration.addRecipes(AXE_SCRAPING, axeScrapingRecipes);
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        super.registerRecipeCatalysts(registration);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42784_), new RecipeType[]{WAXING});
    }
}

