/*
 * Decompiled with CFR 0.152.
 */
package net.onvoid.copperized.common.config;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.onvoid.copperized.common.config.CopperizedConfig;

public class EnabledCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("copperized", "enabled");
    private final String value;

    public EnabledCondition(String value) {
        this.value = value;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return CopperizedConfig.CONFIG.stuff.containsKey(this.value) && (Boolean)CopperizedConfig.CONFIG.stuff.get(this.value).get() != false;
    }

    public String toString() {
        return "enabled(\"" + this.value + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<EnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, EnabledCondition condition) {
            json.addProperty("value", condition.value);
        }

        public EnabledCondition read(JsonObject json) {
            return new EnabledCondition(GsonHelper.m_13906_((JsonObject)json, (String)"value"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

