/*
 * Decompiled with CFR 0.152.
 */
package com.github.creoii.survivality.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SurvivalityConfig {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static final General GENERAL;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(General::new);
        GENERAL_SPEC = (ForgeConfigSpec)specPair.getRight();
        GENERAL = (General)specPair.getLeft();
    }

    public static class General {
        public final ForgeConfigSpec.BooleanValue safeCactus;
        public final ForgeConfigSpec.BooleanValue featheryFallingBoots;
        public final ForgeConfigSpec.BooleanValue snowyLeaves;
        public final ForgeConfigSpec.BooleanValue unstableDripstone;
        public final ForgeConfigSpec.BooleanValue editableSigns;
        public final ForgeConfigSpec.BooleanValue armorSwapping;
        public final ForgeConfigSpec.BooleanValue betterNightVision;
        public final ForgeConfigSpec.DoubleValue maxNightVisionModifier;
        public final ForgeConfigSpec.IntValue maxMultishotLevel;
        public final ForgeConfigSpec.DoubleValue maxMinecartSpeed;
        public final ForgeConfigSpec.DoubleValue tridentDropRate;
        public final ForgeConfigSpec.DoubleValue eyeOfEnderBreakChance;
        public final ForgeConfigSpec.BooleanValue zombieHorseTransmutation;
        public final ForgeConfigSpec.BooleanValue rideableZombieHorses;
        public final ForgeConfigSpec.DoubleValue playerXpModifier;
        public final ForgeConfigSpec.BooleanValue colorfulSheep;
        public final ForgeConfigSpec.IntValue maxSlimeSize;
        public final ForgeConfigSpec.IntValue maxMagmaCubeSize;
        public final ForgeConfigSpec.BooleanValue moreSnacks;
        public final ForgeConfigSpec.BooleanValue shovelableSnow;
        public final ForgeConfigSpec.BooleanValue variantSpawners;
        public final ForgeConfigSpec.BooleanValue randomWorldStartTime;
        public final ForgeConfigSpec.BooleanValue randomWorldStartWeather;
        public final ForgeConfigSpec.BooleanValue randomWorldStartSpawnPos;
        public final ForgeConfigSpec.BooleanValue randomWorldStartBiome;
        public final ForgeConfigSpec.BooleanValue rocketBoosting;
        public final ForgeConfigSpec.IntValue spawnerRequiredPlayerRange;
        public final ForgeConfigSpec.BooleanValue unrestrictedSpawners;
        public final ForgeConfigSpec.BooleanValue unboundEnchant;
        public final ForgeConfigSpec.BooleanValue boatsIgnoreWaterlilies;
        public final ForgeConfigSpec.DoubleValue polarBearCavalryChance;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.safeCactus = builder.comment("Cactus blocks don't destroy Cactus items").define("safe_cactus", true);
            this.featheryFallingBoots = builder.comment("Feather Falling boots don't trample farmland").define("feathery_falling_boots", true);
            this.snowyLeaves = builder.comment("Leaves turn white when snowing").define("snowy_leaves", true);
            this.unstableDripstone = builder.comment("Pointed Dripstone falls when hit by projectiles").define("unstable_dripstone", true);
            this.editableSigns = builder.comment("Signs can be re-edited").define("editable_signs", true);
            this.armorSwapping = builder.comment("Armor in the hotbar can be swapped with equipped armor").define("armor_swapping", true);
            this.betterNightVision = builder.comment("Night Vision is affected by its amplifier").define("better_night_vision", true);
            this.maxNightVisionModifier = builder.comment("Max amount Night Vision can affect brightness").defineInRange("max_night_vision_modifier", 5.0, 0.0, 25.0);
            this.maxMultishotLevel = builder.comment("Max level for Multishot enchantment").defineInRange("max_multishot_level", 4, 1, 7);
            this.maxMinecartSpeed = builder.comment("Max speed Minecarts can reach").defineInRange("max_minecart_speed", 1.6, 0.0, 64.0);
            this.tridentDropRate = builder.comment("Drop rate of Tridents from Drowned").defineInRange("trident_drop_rate", 0.15, 0.0, 1.0);
            this.eyeOfEnderBreakChance = builder.comment("Chance for Eyes of Enders to break").defineInRange("eye_of_ender_break_chance", 0.0, 0.0, 1.0);
            this.zombieHorseTransmutation = builder.comment("Horses struck by lightning become Zombie Horses").define("zombie_horse_transmutation", true);
            this.rideableZombieHorses = builder.comment("Zombie Horses are rideable").define("rideable_zombie_horses", true);
            this.playerXpModifier = builder.comment("Amount of xp to drop on death").defineInRange("player_xp_modifier", 12.0, 0.0, 256.0);
            this.colorfulSheep = builder.comment("Sheep can rarely spawn with any color wool").define("colorful_sheep", true);
            this.maxSlimeSize = builder.comment("Max size a Slime can spawn as").defineInRange("max_slime_size", 4, 1, 16);
            this.maxMagmaCubeSize = builder.comment("Max size a Magma Cube can spawn as").defineInRange("max_magma_cube_size", 4, 1, 16);
            this.moreSnacks = builder.comment("Cookies, Sweet Berries, and Glow Berries are eaten faster").define("more_snacks", true);
            this.shovelableSnow = builder.comment("Snow Layers can be decreased with Shovels").define("shovelable_snow", true);
            this.variantSpawners = builder.comment("Spawners are affected by the biome they generate in").define("variant_spawners", true);
            this.randomWorldStartTime = builder.comment("Freshly generated worlds can start at any time").define("random_world_start_time", true);
            this.randomWorldStartWeather = builder.comment("Freshly generated worlds can start with any weather").define("random_world_start_weather", true);
            this.randomWorldStartSpawnPos = builder.comment("Freshly generated worlds can start with a random position").define("random_world_start_spawn_pos", true);
            this.randomWorldStartBiome = builder.comment("Freshly generated worlds can start in any biome").define("random_world_start_biome", true);
            this.rocketBoosting = builder.comment("Rockets boost vehicles and ridden mobs").define("rocket_boosting", true);
            this.spawnerRequiredPlayerRange = builder.comment("Default range for players to activate spawners").defineInRange("spawner_required_player_range", 32, 0, 128);
            this.unrestrictedSpawners = builder.comment("Spawners will spawn regardless of how many mobs are nearby").define("unrestricted_spawners", true);
            this.unboundEnchant = builder.comment("/enchant allows any level of enchantment").define("unbound_enchant", true);
            this.boatsIgnoreWaterlilies = builder.comment("Boats do not collide with Lily Pads, but they still break them").define("boats_ignore_waterlilies", true);
            this.polarBearCavalryChance = builder.comment("Chance for Polar Bears to spawn with a Stray on their back").defineInRange("polar_bear_cavalry_chance", 0.01, 0.0, 1.0);
            builder.pop();
        }
    }
}

