/*
 * Decompiled with CFR 0.152.
 */
package com.github.creoii.survivality.mixin.block;

import com.github.creoii.survivality.config.SurvivalityConfig;
import com.github.creoii.survivality.util.SurvivalityTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PointedDripstoneBlock.class})
public class PointedDripstoneBlockMixin {
    @Inject(method={"onProjectileHit"}, at={@At(value="TAIL")}, cancellable=true)
    private void survivality_unstableDripstone(Level world, BlockState state, BlockHitResult hit, Projectile projectile, CallbackInfo ci) {
        if (!((Boolean)SurvivalityConfig.GENERAL.unstableDripstone.get()).booleanValue()) {
            return;
        }
        BlockPos hitPos = hit.m_82425_();
        if (!world.f_46443_ && projectile.m_142265_(world, hitPos) && projectile.m_6095_().m_204039_(SurvivalityTags.EntityTypes.BREAK_DRIPSTONE) && projectile.m_20184_().m_82553_() > 0.6) {
            world.m_46961_(hitPos, true);
        }
        ci.cancel();
    }

    @Inject(method={"randomTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/PointedDripstoneBlock;growStalactiteOrStalagmiteIfPossible(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V")}, cancellable=true)
    private void survivality_dripstoneRandomlyFall(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (((Boolean)SurvivalityConfig.GENERAL.unstableDripstone.get()).booleanValue() && random.m_188503_(3) == 0 && !world.f_46443_) {
            world.m_46961_(pos, true);
            ci.cancel();
        }
    }
}

