/*
 * Decompiled with CFR 0.152.
 */
package com.github.creoii.survivality.mixin.entity;

import com.github.creoii.survivality.util.SurvivalityTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={FireworkRocketEntity.class})
public class FireworkRocketEntityMixin {
    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isFallFlying()Z"))
    private boolean survivality_rocketBoosting(LivingEntity instance) {
        Entity vehicle = instance.m_20202_();
        if (vehicle != null && vehicle.m_6095_().m_204039_(SurvivalityTags.EntityTypes.BOOSTABLE_VEHICLES)) {
            if (vehicle instanceof AbstractMinecart) {
                AbstractMinecart minecartEntity = (AbstractMinecart)vehicle;
                return RailBlock.m_49416_((BlockState)minecartEntity.m_20075_());
            }
            if (vehicle instanceof Boat) {
                Boat boatEntity = (Boat)vehicle;
                return boatEntity.f_38279_ == Boat.Status.IN_WATER;
            }
        }
        return instance.m_21255_();
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"))
    private void survivality_fixVehicleBoostVelocity(LivingEntity instance, Vec3 vec3d) {
        double velocityX = vec3d.f_82479_ * 0.1 + (vec3d.f_82479_ * 1.5 - vec3d.f_82479_) * 0.5;
        double velocityZ = vec3d.f_82481_ * 0.1 + (vec3d.f_82481_ * 1.5 - vec3d.f_82481_) * 0.5;
        Entity vehicle = instance.m_20202_();
        if (vehicle != null && vehicle.m_6095_().m_204039_(SurvivalityTags.EntityTypes.BOOSTABLE_VEHICLES)) {
            Vec3 vehicleVelocity = new Vec3(vec3d.f_82479_, 0.0, vec3d.f_82481_);
            vehicle.m_20256_(vehicleVelocity.m_82520_(velocityX, 0.0, velocityZ));
        } else {
            instance.m_20256_(vec3d.m_82520_(velocityX, vec3d.f_82480_ * 0.1 + (vec3d.f_82480_ * 1.5 - vec3d.f_82480_) * 0.5, velocityZ));
        }
    }
}

