/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.enchantato_loot;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Mod(value="enchantato_loot")
public class EnchantatoLoot {
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> ENCHANTMENT_LIST;
    public static ForgeConfigSpec.BooleanValue INVERTED_MODE;

    public EnchantatoLoot() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG, "enchantato-loot.toml");
    }

    public static ItemStack enchantItem(RandomSource pRandom, ItemStack pStack, int pLevel, boolean pAllowTreasure) {
        List<EnchantmentInstance> list = EnchantatoLoot.selectEnchantment(pRandom, pStack, pLevel, pAllowTreasure);
        boolean flag = pStack.m_150930_(Items.f_42517_);
        if (flag) {
            pStack = new ItemStack((ItemLike)Items.f_42690_);
        }
        for (EnchantmentInstance enchantmentinstance : list) {
            if (flag) {
                EnchantedBookItem.m_41153_((ItemStack)pStack, (EnchantmentInstance)enchantmentinstance);
                continue;
            }
            pStack.m_41663_(enchantmentinstance.f_44947_, enchantmentinstance.f_44948_);
        }
        return pStack;
    }

    @NotNull
    public static List<EnchantmentInstance> selectEnchantment(RandomSource pRandom, @NotNull ItemStack pItemStack, int pLevel, boolean pAllowTreasure) {
        ObjectArrayList list = new ObjectArrayList();
        int i = pItemStack.getEnchantmentValue();
        if (i <= 0) {
            return list;
        }
        pLevel += 1 + pRandom.m_188503_(i / 4 + 1) + pRandom.m_188503_(i / 4 + 1);
        float f = (pRandom.m_188501_() + pRandom.m_188501_() - 1.0f) * 0.15f;
        List<EnchantmentInstance> list1 = EnchantatoLoot.getAvailableEnchantmentResults(pLevel = Mth.m_14045_((int)Math.round((float)pLevel + (float)pLevel * f), (int)1, (int)Integer.MAX_VALUE), pItemStack, pAllowTreasure);
        if (!list1.isEmpty()) {
            WeightedRandom.m_216822_((RandomSource)pRandom, list1).ifPresent(((List)list)::add);
            while (pRandom.m_188503_(50) <= pLevel) {
                if (!list.isEmpty()) {
                    EnchantmentHelper.m_44862_(list1, (EnchantmentInstance)((EnchantmentInstance)Util.m_137509_((List)list)));
                }
                if (list1.isEmpty()) break;
                WeightedRandom.m_216822_((RandomSource)pRandom, list1).ifPresent(((List)list)::add);
                pLevel /= 2;
            }
        }
        return list;
    }

    @NotNull
    public static List<EnchantmentInstance> getAvailableEnchantmentResults(int pLevel, @NotNull ItemStack pStack, boolean pAllowTreasure) {
        ObjectArrayList list = new ObjectArrayList();
        boolean flag = pStack.m_150930_(Items.f_42517_);
        block0: for (Enchantment enchantment : Registry.f_122825_) {
            if (enchantment.m_6591_() && !pAllowTreasure || !EnchantatoLoot.canEnchantLoot(enchantment) || !enchantment.canApplyAtEnchantingTable(pStack) && (!flag || !enchantment.isAllowedOnBooks())) continue;
            for (int i = enchantment.m_6586_(); i > enchantment.m_44702_() - 1; --i) {
                if (pLevel < enchantment.m_6183_(i) || pLevel > enchantment.m_6175_(i)) continue;
                list.add(new EnchantmentInstance(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    public static boolean canEnchantLoot(Enchantment enchantment) {
        if (!((Boolean)INVERTED_MODE.get()).booleanValue()) {
            if (((List)ENCHANTMENT_LIST.get()).contains(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).toString())) {
                return false;
            }
            return enchantment.m_6592_();
        }
        return enchantment.m_6592_() && ((List)ENCHANTMENT_LIST.get()).contains(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).toString());
    }

    static {
        ForgeConfigSpec.Builder CONFIG_BUILDER = new ForgeConfigSpec.Builder();
        CONFIG_BUILDER.push("Enchantato-Loot");
        INVERTED_MODE = CONFIG_BUILDER.comment("If you enable this, the 'DisabledEnchantments' will become 'AllowedEnchantments'").define("InvertedMode", false);
        ENCHANTMENT_LIST = CONFIG_BUILDER.defineList("DisabledEnchantments", (List)new ObjectArrayList(), o -> true);
        CONFIG_BUILDER.pop();
        COMMON_CONFIG = CONFIG_BUILDER.build();
    }
}

