/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.common.block.AloeVeraTallBlock;
import com.teamabnormals.atmospheric.core.other.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.other.AtmosphericDamageSources;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class AloeVeraBlock
extends BushBlock
implements BonemealableBlock {
    public static final VoxelShape SHAPE_SMALL = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    public static final VoxelShape SHAPE_MEDIUM = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public static final VoxelShape SHAPE_LARGE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public static final IntegerProperty AGE = BlockStateProperties.f_61408_;

    public AloeVeraBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.m_61143_((Property)AGE);
        VoxelShape shape = age >= 4 ? SHAPE_LARGE : (age >= 2 ? SHAPE_MEDIUM : SHAPE_SMALL);
        Vec3 vec3d = state.m_60824_(worldIn, pos);
        return shape.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i == 5 && player.m_21120_(handIn).m_41720_() == Items.f_42574_) {
            RandomSource rand = RandomSource.m_216327_();
            player.m_21120_(handIn).m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21190_(handIn));
            worldIn.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            worldIn.m_5594_(null, pos, SoundEvents.f_12389_, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2)));
            AloeVeraBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.ALOE_LEAVES.get(), rand.m_188503_(5) + 3));
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && !(entityIn instanceof Bee)) {
            double chance = 0.1;
            if ((Integer)state.m_61143_((Property)AGE) == 3) {
                chance = 0.1;
            }
            if ((Integer)state.m_61143_((Property)AGE) == 4) {
                chance = 0.2;
            }
            if ((Integer)state.m_61143_((Property)AGE) == 5) {
                chance = 0.4;
            }
            if (!worldIn.f_46443_ && (Integer)state.m_61143_((Property)AGE) > 2 && Math.random() <= chance) {
                entityIn.m_7601_(state, new Vec3((double)0.2f, 0.2, (double)0.2f));
                entityIn.m_6469_(AtmosphericDamageSources.ALOE_LEAVES, 1.0f);
                if (entityIn instanceof ServerPlayer) {
                    ServerPlayer serverplayerentity = (ServerPlayer)entityIn;
                    if (!entityIn.m_20193_().m_5776_() && !serverplayerentity.m_7500_()) {
                        AtmosphericCriteriaTriggers.ALOE_VERA_PRICK.trigger(serverplayerentity);
                    }
                }
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState downState = worldIn.m_8055_(pos.m_7495_());
        return downState.m_204336_(AtmosphericBlockTags.ALOE_PLACEABLE);
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.DESERT;
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return level.m_8055_(pos.m_7495_()).m_204336_(AtmosphericBlockTags.TALL_ALOE_GROWABLE_ON) || (Integer)state.m_61143_((Property)AGE) < 5;
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return level.m_8055_(pos.m_7495_()).m_204336_(AtmosphericBlockTags.TALL_ALOE_GROWABLE_ON) || (Integer)state.m_61143_((Property)AGE) < 5;
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 5) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
        } else if (world.m_8055_(pos.m_7494_()).m_60795_() && world.m_8055_(pos.m_7495_()).m_204336_(AtmosphericBlockTags.TALL_ALOE_GROWABLE_ON)) {
            this.placeAt((LevelAccessor)world, pos, 2);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        int chance;
        super.m_213897_(state, worldIn, pos, random);
        boolean flag = worldIn.m_8055_(pos.m_7495_()).m_204336_(AtmosphericBlockTags.TALL_ALOE_GROWABLE_ON);
        int n = chance = flag ? 7 : 5;
        if (worldIn.m_45524_(pos.m_7494_(), 0) >= 12 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.m_188503_(chance) == 0 ? 1 : 0) != 0)) {
            if ((Integer)state.m_61143_((Property)AGE) < 5) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)));
            } else if (flag && ((Block)AtmosphericBlocks.TALL_ALOE_VERA.get()).m_49966_().m_60710_((LevelReader)worldIn, pos) && worldIn.m_46859_(pos.m_7494_())) {
                AloeVeraTallBlock.m_153173_((LevelAccessor)worldIn, (BlockState)((Block)AtmosphericBlocks.TALL_ALOE_VERA.get()).m_49966_(), (BlockPos)pos, (int)2);
            }
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.DAMAGE_CACTUS;
    }

    public void placeAt(LevelAccessor world, BlockPos pos, int flags) {
        world.m_7731_(pos, (BlockState)((Block)AtmosphericBlocks.TALL_ALOE_VERA.get()).m_49966_().m_61124_((Property)AloeVeraTallBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER), flags);
        world.m_7731_(pos.m_7494_(), (BlockState)((Block)AtmosphericBlocks.TALL_ALOE_VERA.get()).m_49966_().m_61124_((Property)AloeVeraTallBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER), flags);
    }
}

