/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.common.block.AloeVeraBlock;
import com.teamabnormals.atmospheric.core.other.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.other.AtmosphericDamageSources;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericParticleTypes;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class AloeVeraTallBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape SHAPE_TOP = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)6, (int)8);

    public AloeVeraTallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(6))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.m_60824_(worldIn, pos);
        VoxelShape shape = state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER ? SHAPE_TOP : SHAPE;
        return shape.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52858_, AGE});
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        BlockState downState = worldIn.m_8055_(pos.m_7495_());
        if (state.m_60734_() instanceof AloeVeraTallBlock) {
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)f_52858_);
            if (half == DoubleBlockHalf.UPPER) {
                return downState.m_60734_() instanceof AloeVeraTallBlock;
            }
            return downState.m_204336_(AtmosphericBlockTags.ALOE_PLACEABLE);
        }
        return super.m_6266_(state, worldIn, pos);
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.DESERT;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            if (!(entityIn instanceof Bee)) {
                entityIn.m_7601_(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
            }
            RandomSource rand = RandomSource.m_216327_();
            for (int i = 0; i < 3; ++i) {
                double offsetX = rand.m_188501_() * 0.6f;
                double offsetZ = rand.m_188501_() * 0.45f;
                double x = (double)pos.m_123341_() + 0.5 + offsetX;
                double y = (double)pos.m_123342_() + 0.5 + (double)(rand.m_188501_() * 0.05f);
                double z = (double)pos.m_123343_() + 0.65 + offsetZ;
                if (state.m_61143_((Property)f_52858_) != DoubleBlockHalf.UPPER || !worldIn.f_46443_ || worldIn.m_46467_() % (long)(9 / ((Integer)state.m_61143_((Property)AGE) - 5)) != 0L) continue;
                worldIn.m_7106_((ParticleOptions)AtmosphericParticleTypes.ALOE_BLOSSOM.get(), x, y, z, 0.03, 0.0, 0.03);
            }
            if (!worldIn.f_46443_ && (Integer)state.m_61143_((Property)AGE) > 3 && Math.random() <= 0.4 && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER && !(entityIn instanceof Bee)) {
                entityIn.m_7601_(state, new Vec3((double)0.2f, 0.2, (double)0.2f));
                entityIn.m_6469_(AtmosphericDamageSources.ALOE_LEAVES, 1.0f);
                if (entityIn instanceof ServerPlayer) {
                    ServerPlayer serverplayerentity = (ServerPlayer)entityIn;
                    if (!entityIn.m_20193_().m_5776_() && !serverplayerentity.m_7500_()) {
                        AtmosphericCriteriaTriggers.ALOE_VERA_PRICK.trigger(serverplayerentity);
                    }
                }
            }
        }
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)AtmosphericItems.ALOE_KERNELS.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level worldIn, BlockPos pos, RandomSource rand) {
        double offsetX = rand.m_188501_() * 0.6f;
        double offsetZ = rand.m_188501_() * 0.45f;
        double x = (double)pos.m_123341_() + 0.5 + offsetX;
        double y = (double)pos.m_123342_() + 0.5 + (double)(rand.m_188501_() * 0.05f);
        double z = (double)pos.m_123343_() + 0.65 + offsetZ;
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER && worldIn.f_46443_ && worldIn.m_46467_() % (long)(6 / ((Integer)state.m_61143_((Property)AGE) - 5)) == 0L) {
            worldIn.m_7106_((ParticleOptions)AtmosphericParticleTypes.ALOE_BLOSSOM.get(), x, y, z, 0.03, 0.0, 0.03);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        int age = (Integer)state.m_61143_((Property)AGE);
        RandomSource rand = RandomSource.m_216327_();
        if (player.m_21120_(handIn).m_41720_() == Items.f_42574_) {
            player.m_21120_(handIn).m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21190_(handIn));
            for (int i = 0; i < 50 + rand.m_188503_(50); ++i) {
                double offsetX = rand.m_188501_();
                double offsetZ = rand.m_188501_();
                double x = (double)pos.m_123341_() + offsetX;
                double y = (double)pos.m_123342_() + 0.5 + (double)rand.m_188501_();
                double z = (double)pos.m_123343_() + 0.15 + offsetZ;
                if (!worldIn.f_46443_) continue;
                worldIn.m_7106_((ParticleOptions)AtmosphericParticleTypes.ALOE_BLOSSOM.get(), x, y, z, 0.03, 0.0, 0.03);
            }
            worldIn.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            AloeVeraTallBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.YELLOW_BLOSSOMS.get(), age - 5));
            AloeVeraTallBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.ALOE_KERNELS.get()));
            if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
                worldIn.m_5594_(null, pos, SoundEvents.f_12389_, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
                worldIn.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 18);
                worldIn.m_7731_(pos, (BlockState)((Block)AtmosphericBlocks.ALOE_VERA.get()).m_49966_().m_61124_((Property)AloeVeraBlock.AGE, (Comparable)Integer.valueOf(2)), 18);
                AloeVeraTallBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.ALOE_LEAVES.get(), rand.m_188503_(5) + 3));
            } else {
                worldIn.m_7731_(pos.m_7495_(), (BlockState)((Block)AtmosphericBlocks.ALOE_VERA.get()).m_49966_().m_61124_((Property)AloeVeraBlock.AGE, (Comparable)Integer.valueOf(5)), 18);
                worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.m_6266_(state, (BlockGetter)worldIn, pos);
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 8;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 8;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.DAMAGE_CACTUS;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        boolean flag;
        super.m_213897_(state, worldIn, pos, random);
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER && (flag = worldIn.m_8055_(pos.m_7495_()).m_204336_(AtmosphericBlockTags.TALL_ALOE_GROWABLE_ON)) && (Integer)state.m_61143_((Property)AGE) < 8 && worldIn.m_45524_(pos.m_7494_(), 0) >= 12 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.m_188503_(7) == 0 ? 1 : 0) != 0)) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)));
            worldIn.m_46597_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)));
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        int age = (Integer)state.m_61143_((Property)AGE);
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)f_52858_);
        if (age < 8) {
            if (half == DoubleBlockHalf.LOWER) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
                world.m_46597_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
            } else if (half == DoubleBlockHalf.UPPER) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
                world.m_46597_(pos.m_7495_(), (BlockState)((BlockState)state.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
            }
        }
    }
}

