/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.common.block.CrustoseLogBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class CrustoseBlock
extends Block {
    public CrustoseBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean canBeGrass(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = world.m_8055_(blockpos);
        int i = LayerLightEngine.m_75667_((BlockGetter)world, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)world, blockpos));
        return i < world.m_7469_();
    }

    private static boolean canPropagate(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return CrustoseBlock.canBeGrass(state, world, pos) && !world.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
    }

    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (toolAction == ToolActions.SHOVEL_FLATTEN) {
            return ((Block)AtmosphericBlocks.CRUSTOSE_PATH.get()).m_49966_();
        }
        return super.getToolModifiedState(state, context, toolAction, simulate);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter blockReader, BlockPos pos, Direction direction, IPlantable iPlantable) {
        BlockPos plantPos = new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
        PlantType plantType = iPlantable.getPlantType(blockReader, plantPos);
        return plantType == PlantType.PLAINS;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.f_46443_) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            if (!CrustoseBlock.canBeGrass(state, (LevelReader)worldIn, pos)) {
                worldIn.m_46597_(pos, Blocks.f_50493_.m_49966_());
            } else if (worldIn.m_46803_(pos.m_7494_()) >= 9) {
                BlockState blockstate = this.m_49966_();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                    if (worldIn.m_8055_(blockpos).m_60734_() == Blocks.f_50493_ && CrustoseBlock.canPropagate(blockstate, (LevelReader)worldIn, blockpos)) {
                        worldIn.m_46597_(blockpos, this.m_49966_());
                        continue;
                    }
                    if (worldIn.m_8055_(blockpos).m_60734_() != AtmosphericBlocks.ASPEN_LOG.get() || !CrustoseBlock.canPropagate(blockstate, (LevelReader)worldIn, blockpos)) continue;
                    worldIn.m_46597_(blockpos, (BlockState)((Block)AtmosphericBlocks.CRUSTOSE_LOG.get()).m_49966_().m_61124_((Property)CrustoseLogBlock.f_55923_, (Comparable)((Direction.Axis)worldIn.m_8055_(blockpos).m_61143_((Property)CrustoseLogBlock.f_55923_))));
                }
            }
        }
    }
}

