/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.google.common.base.Supplier;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.block.wood.LogBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LayerLightEngine;

public class CrustoseLogBlock
extends LogBlock {
    public CrustoseLogBlock(Supplier<Block> block, BlockBehaviour.Properties properties) {
        super(block, properties);
    }

    private static boolean canBeGrass(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = world.m_8055_(blockpos);
        int i = LayerLightEngine.m_75667_((BlockGetter)world, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)world, blockpos));
        return i < world.m_7469_();
    }

    private static boolean canPropagate(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return CrustoseLogBlock.canBeGrass(state, world, pos) && !world.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.f_46443_) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            if (!CrustoseLogBlock.canBeGrass(state, (LevelReader)worldIn, pos)) {
                worldIn.m_46597_(pos, (BlockState)((Block)AtmosphericBlocks.ASPEN_LOG.get()).m_49966_().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)f_55923_))));
            } else if (worldIn.m_46803_(pos.m_7494_()) >= 9) {
                BlockState blockstate = this.m_49966_();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                    if (worldIn.m_8055_(blockpos).m_60734_() == Blocks.f_50493_ && CrustoseLogBlock.canPropagate(blockstate, (LevelReader)worldIn, blockpos)) {
                        worldIn.m_46597_(blockpos, ((Block)AtmosphericBlocks.CRUSTOSE.get()).m_49966_());
                        continue;
                    }
                    if (worldIn.m_8055_(blockpos).m_60734_() != AtmosphericBlocks.ASPEN_LOG.get() || !CrustoseLogBlock.canPropagate(blockstate, (LevelReader)worldIn, blockpos)) continue;
                    worldIn.m_46597_(blockpos, (BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)worldIn.m_8055_(blockpos).m_61143_((Property)f_55923_))));
                }
            }
        }
    }
}

