/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.common.levelgen.feature.MonkeyBrushFeature;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import com.teamabnormals.blueprint.common.block.BlueprintFlowerBlock;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;

public class MonkeyBrushBlock
extends BlueprintFlowerBlock
implements BonemealableBlock,
IPlantable {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.VERTICAL);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public MonkeyBrushBlock(BlockBehaviour.Properties properties) {
        super(AtmosphericMobEffects.RELIEF, 6, properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(AtmosphericBlockTags.MONKEY_BRUSH_PLACEABLE);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        return this.m_6266_(worldIn.m_8055_(blockpos), (BlockGetter)worldIn, blockpos);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return context.m_43719_().m_122434_().m_122478_() ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_()) : this.m_49966_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.m_60824_(worldIn, pos);
        return SHAPE.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return worldIn.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos blockPos, BlockState state) {
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < x / 16; ++y) {
                if (!state.m_60710_((LevelReader)world, blockPos = blockPos.m_7918_(random.m_188503_(3) - 1, (random.m_188503_(3) - 1) * random.m_188503_(3) / 2, random.m_188503_(3) - 1)) || !world.m_46859_(blockPos)) continue;
                Direction randomD = Direction.m_235672_((RandomSource)random);
                while (!MonkeyBrushFeature.monkeyBrushState(state, randomD).m_60710_((LevelReader)world, blockPos)) {
                    randomD = Direction.m_235672_((RandomSource)random);
                }
                world.m_7731_(blockPos, MonkeyBrushFeature.monkeyBrushState(state, randomD), 2);
                return;
            }
        }
    }
}

