/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class PassionVineBlock
extends Block
implements BonemealableBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)4);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
        }
        return EAST_AABB;
    }

    public PassionVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        boolean randomNum;
        super.m_213897_(state, worldIn, pos, random);
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean light = worldIn.m_45524_(pos.m_7494_(), 0) >= 5;
        boolean notOld = i < 4;
        boolean canFlower = i >= 1;
        boolean canFruit = notOld && light;
        boolean bl = randomNum = worldIn.f_46441_.m_188503_(2) == 1;
        if (canFlower) {
            if (canFruit) {
                if (randomNum) {
                    this.attemptGrowDown(state, (Level)worldIn, pos, random);
                } else {
                    this.attemptGrowFruit(state, (Level)worldIn, pos, random);
                }
            } else {
                this.attemptGrowDown(state, (Level)worldIn, pos, random);
            }
        } else if (canFruit) {
            this.attemptGrowFruit(state, (Level)worldIn, pos, random);
        }
    }

    public void attemptGrowFruit(BlockState state, Level worldIn, BlockPos pos, RandomSource random) {
        int i = (Integer)state.m_61143_((Property)AGE);
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState hanging = worldIn.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (hanging.m_204336_(AtmosphericBlockTags.PASSION_VINE_GROWABLE_ON)) {
            if (i < 4 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.m_188503_(7) == 0 ? 1 : 0) != 0)) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
            }
        } else if (i < 1 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.m_188503_(7) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void attemptGrowDown(BlockState state, Level worldIn, BlockPos pos, RandomSource random) {
        BlockState below;
        if (ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.m_188503_(7) == 0 ? 1 : 0) != 0) && (below = worldIn.m_8055_(pos.m_7495_())).m_60734_() == Blocks.f_50016_) {
            worldIn.m_46597_(pos.m_7495_(), (BlockState)((BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean flag;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean bl = flag = i == 4;
        if (!flag && player.m_21120_(handIn).m_41720_() == Items.f_42499_) {
            return InteractionResult.PASS;
        }
        if (i == 4) {
            PassionVineBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.PASSIONFRUIT.get(), 1 + worldIn.f_46441_.m_188503_(2) + worldIn.f_46441_.m_188503_(2) + worldIn.f_46441_.m_188503_(3)));
            worldIn.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return InteractionResult.SUCCESS;
        }
        if (i == 1 && player.m_21120_(handIn).m_41720_() == Items.f_42574_) {
            Direction direction = hit.m_82434_();
            Direction direction1 = direction.m_122434_() == Direction.Axis.Y ? player.m_6350_().m_122424_() : direction;
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5 + (double)direction1.m_122429_() * 0.65, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5 + (double)direction1.m_122431_() * 0.65, new ItemStack((ItemLike)Items.f_42535_, 1));
            itementity.m_20334_(0.05 * (double)direction1.m_122429_() + worldIn.f_46441_.m_188500_() * 0.02, 0.05, 0.05 * (double)direction1.m_122431_() + worldIn.f_46441_.m_188500_() * 0.02);
            worldIn.m_7967_((Entity)itementity);
            player.m_21120_(handIn).m_41622_(1, (LivingEntity)player, p_213442_1_ -> p_213442_1_.m_21190_(handIn));
            worldIn.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, FACING});
    }

    private boolean canAttachTo(BlockGetter p_196471_1_, BlockPos p_196471_2_, Direction p_196471_3_) {
        BlockState blockstate = p_196471_1_.m_8055_(p_196471_2_);
        return !blockstate.m_60803_() && (blockstate.m_60783_(p_196471_1_, p_196471_2_, p_196471_3_) || blockstate.m_204336_(BlockTags.f_13035_));
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return this.canAttachTo((BlockGetter)worldIn, pos.m_121945_(direction.m_122424_()), direction) || worldIn.m_8055_(pos.m_7494_()).m_60734_() == AtmosphericBlocks.PASSION_VINE.get() && worldIn.m_8055_(pos.m_7494_()).m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate;
        if (!context.m_7058_() && (blockstate = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()))).m_60734_() == this && blockstate.m_61143_((Property)FACING) == context.m_43719_()) {
            return null;
        }
        BlockState blockstate1 = this.m_49966_();
        Level iworldreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockstate1 = (BlockState)blockstate1.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)iworldreader, blockpos)) continue;
            return blockstate1;
        }
        return null;
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 4;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = Math.min(4, (Integer)state.m_61143_((Property)AGE) + 1);
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

