/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.teamabnormals.atmospheric.common.levelgen.feature.MonkeyBrushFeature;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import com.teamabnormals.blueprint.common.block.BlueprintFlowerBlock;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;

public class WallMonkeyBrushBlock
extends BlueprintFlowerBlock
implements BonemealableBlock,
IPlantable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));

    public WallMonkeyBrushBlock(BlockBehaviour.Properties properties) {
        super(() -> AtmosphericMobEffects.RELIEF.get(), 120, properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public String m_7705_() {
        return this.m_5456_().m_5524_();
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(AtmosphericBlockTags.MONKEY_BRUSH_PLACEABLE);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
        return this.m_6266_(worldIn.m_8055_(blockpos), (BlockGetter)worldIn, blockpos);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43719_().m_122434_().m_122478_()) {
            return null;
        }
        Direction direction = context.m_43719_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? Half.TOP : Half.BOTTOM));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return WallMonkeyBrushBlock.getShapeForState(state);
    }

    public static VoxelShape getShapeForState(BlockState state) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return worldIn.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos blockPos, BlockState state) {
        for (int x = 0; x < 64; ++x) {
            if (state.m_60734_() == AtmosphericBlocks.WARM_WALL_MONKEY_BRUSH.get()) {
                state = ((Block)AtmosphericBlocks.WARM_MONKEY_BRUSH.get()).m_49966_();
            }
            if (state.m_60734_() == AtmosphericBlocks.HOT_WALL_MONKEY_BRUSH.get()) {
                state = ((Block)AtmosphericBlocks.HOT_MONKEY_BRUSH.get()).m_49966_();
            }
            if (state.m_60734_() == AtmosphericBlocks.SCALDING_WALL_MONKEY_BRUSH.get()) {
                state = ((Block)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get()).m_49966_();
            }
            for (int y = 0; y < x / 16; ++y) {
                if (!state.m_60710_((LevelReader)world, blockPos = blockPos.m_7918_(random.m_188503_(3) - 1, (random.m_188503_(3) - 1) * random.m_188503_(3) / 2, random.m_188503_(3) - 1)) || !world.m_46859_(blockPos)) continue;
                Direction randomD = Direction.m_235672_((RandomSource)random);
                while (!MonkeyBrushFeature.monkeyBrushState(state, randomD).m_60710_((LevelReader)world, blockPos)) {
                    randomD = Direction.m_235672_((RandomSource)random);
                }
                world.m_7731_(blockPos, MonkeyBrushFeature.monkeyBrushState(state, randomD), 2);
                return;
            }
        }
    }
}

