/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.core.util.TreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public class AspenTreeFeature
extends Feature<TreeConfiguration> {
    public AspenTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        WorldGenLevel worldIn = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos position = context.m_159777_();
        int height = 12 + rand.m_188503_(4) + rand.m_188503_(5) + rand.m_188503_(6);
        boolean flag = true;
        if (position.m_123342_() > worldIn.m_141937_() && position.m_123342_() + height + 1 <= worldIn.m_151558_()) {
            for (int j = position.m_123342_(); j <= position.m_123342_() + 1 + height; ++j) {
                int k = 1;
                if (j == position.m_123342_()) {
                    k = 0;
                }
                if (j >= position.m_123342_() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (int l = position.m_123341_() - k; l <= position.m_123341_() + k && flag; ++l) {
                    for (int i1 = position.m_123343_() - k; i1 <= position.m_123343_() + k && flag; ++i1) {
                        if (j >= worldIn.m_141937_() && j < worldIn.m_151558_()) {
                            if (TreeUtil.isAirOrLeaves((LevelSimulatedReader)worldIn, (BlockPos)mutable.m_122178_(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeUtil.isValidGround((LevelAccessor)worldIn, (BlockPos)position.m_7495_(), (SaplingBlock)((SaplingBlock)AtmosphericBlocks.ASPEN_SAPLING.get())) && position.m_123342_() < worldIn.m_151558_()) {
                TreeUtil.setDirtAt((LevelAccessor)worldIn, (BlockPos)position.m_7495_());
                HashSet logsPlaced = Sets.newHashSet();
                int logX = position.m_123341_();
                int logZ = position.m_123343_();
                int leafHeight = height - 7 - rand.m_188503_(3) - rand.m_188503_(3);
                int branchHeight = leafHeight - 2 - rand.m_188503_(3);
                int bonusBranchHeight = branchHeight - 2 - rand.m_188503_(3);
                for (int k1 = 0; k1 < height; ++k1) {
                    int logY = position.m_123342_() + k1;
                    BlockPos blockpos = new BlockPos(logX, logY, logZ);
                    if (TreeUtil.isAirOrLeaves((LevelSimulatedReader)worldIn, (BlockPos)blockpos)) {
                        TreeUtil.placeDirectionalLogAt((LevelWriter)worldIn, (BlockPos)blockpos, (Direction)Direction.UP, (RandomSource)rand, (TreeConfiguration)config);
                        logsPlaced.add(blockpos.m_7949_());
                    }
                    if (k1 >= leafHeight) {
                        for (Direction direction : Direction.values()) {
                            if (direction.m_122434_().m_122480_() != Direction.Plane.HORIZONTAL) continue;
                            TreeUtil.placeLeafAt((LevelSimulatedRW)worldIn, (BlockPos)blockpos.m_121945_(direction), (RandomSource)rand, (TreeConfiguration)config);
                            BlockPos offsetPos = blockpos.m_121945_(direction).m_121945_(direction.m_122427_());
                            if (k1 <= leafHeight || k1 >= height - 1 || rand.m_188503_(4) == 0 && !worldIn.m_8055_(offsetPos.m_7495_()).m_60795_()) continue;
                            TreeUtil.placeLeafAt((LevelSimulatedRW)worldIn, (BlockPos)offsetPos, (RandomSource)rand, (TreeConfiguration)config);
                        }
                        if (k1 <= leafHeight + 1 || k1 >= height - 2) continue;
                        for (int k3 = -2; k3 <= 2; ++k3) {
                            for (int j4 = -2; j4 <= 2; ++j4) {
                                if (Math.abs(k3) == 2 && Math.abs(j4) == 2 || !rand.m_188499_()) continue;
                                TreeUtil.placeLeafAt((LevelSimulatedRW)worldIn, (BlockPos)blockpos.m_7918_(k3, 0, j4), (RandomSource)rand, (TreeConfiguration)config);
                            }
                        }
                        continue;
                    }
                    if ((k1 != branchHeight || branchHeight <= 3 || rand.m_188503_(5) == 0) && (k1 != bonusBranchHeight || bonusBranchHeight <= 2 || rand.m_188503_(3) == 0)) continue;
                    int branchSize = 1 + rand.m_188503_(2);
                    if (rand.m_188499_()) {
                        branchSize += 1 + rand.m_188503_(2);
                    }
                    ArrayList usedDirections = Lists.newArrayList();
                    while (usedDirections.size() < branchSize) {
                        Direction randomDirection = Direction.Plane.HORIZONTAL.m_235690_(rand);
                        if (usedDirections.contains(randomDirection)) continue;
                        usedDirections.add(randomDirection);
                    }
                    for (Direction direction : usedDirections) {
                        TreeUtil.placeLeafAt((LevelSimulatedRW)worldIn, (BlockPos)blockpos.m_121945_(direction), (RandomSource)rand, (TreeConfiguration)config);
                    }
                }
                TreeUtil.placeLeafAt((LevelSimulatedRW)worldIn, (BlockPos)position.m_7918_(0, height, 0), (RandomSource)rand, (TreeConfiguration)config);
                TreeUtil.updateLeaves((LevelAccessor)worldIn, (Set)logsPlaced);
                HashSet set3 = Sets.newHashSet();
                BiConsumer<BlockPos, BlockState> biconsumer3 = (p_225290_, p_225291_) -> {
                    set3.add(p_225290_.m_7949_());
                    worldIn.m_7731_(p_225290_, p_225291_, 19);
                };
                if (!config.f_68187_.isEmpty()) {
                    TreeDecorator.Context decoratorContext = new TreeDecorator.Context((LevelSimulatedReader)worldIn, biconsumer3, rand, (Set)logsPlaced, (Set)Sets.newHashSet(), (Set)Sets.newHashSet());
                    config.f_68187_.forEach(decorator -> decorator.m_214187_(decoratorContext));
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

