/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.common.levelgen.feature.MonkeyBrushFeature;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.core.util.TreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraftforge.common.Tags;

public class RainforestTreeFeature
extends Feature<TreeConfiguration> {
    private final List<Block> brushes = new ArrayList<Block>();
    private final boolean water;

    public RainforestTreeFeature(Codec<TreeConfiguration> config, boolean water) {
        super(config);
        this.water = water;
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        WorldGenLevel level = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos position = context.m_159777_();
        boolean morado = config.f_68185_.m_213972_(rand, position).m_60713_((Block)AtmosphericBlocks.MORADO_LOG.get());
        if (rand.m_188503_(250) == 0) {
            if (rand.m_188503_(2) == 0) {
                this.brushes.add((Block)AtmosphericBlocks.WARM_MONKEY_BRUSH.get());
            }
            if (rand.m_188503_(3) == 0) {
                this.brushes.add((Block)AtmosphericBlocks.HOT_MONKEY_BRUSH.get());
            }
            if (rand.m_188503_(4) == 0) {
                this.brushes.add((Block)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get());
            }
        } else {
            this.brushes.clear();
        }
        int branches = 2 + rand.m_188503_(3) - (!morado ? 0 : 1);
        int height = 4 + rand.m_188503_(2) + rand.m_188503_(3) + (!morado ? rand.m_188503_(3) : -1);
        boolean flag = true;
        if (position.m_123342_() > level.m_141937_() && position.m_123342_() + height + 1 <= level.m_151558_()) {
            for (int j = position.m_123342_(); j <= position.m_123342_() + 1 + height; ++j) {
                int k = 1;
                if (j == position.m_123342_()) {
                    k = 0;
                }
                if (j >= position.m_123342_() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.m_123341_() - k; l <= position.m_123341_() + k && flag; ++l) {
                    for (int i1 = position.m_123343_() - k; i1 <= position.m_123343_() + k && flag; ++i1) {
                        if (j >= level.m_141937_() && j < level.m_151558_()) {
                            if (!(!this.water ? !TreeUtil.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)blockpos$mutableblockpos.m_122178_(l, j, i1)) : !RainforestTreeFeature.isAirOrWaterOrLeaves((LevelSimulatedReader)level, (BlockPos)blockpos$mutableblockpos.m_122178_(l, j, i1)))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if ((TreeUtil.isValidGround((LevelAccessor)level, (BlockPos)position.m_7495_(), (SaplingBlock)((SaplingBlock)AtmosphericBlocks.ROSEWOOD_SAPLING.get())) || level.m_8055_(position.m_7495_()).m_204336_(Tags.Blocks.GRAVEL)) && position.m_123342_() < level.m_151558_() - branches - 1) {
                if (!this.water) {
                    TreeUtil.setDirtAt((LevelAccessor)level, (BlockPos)position.m_7495_());
                }
                HashSet logsPlaced = Sets.newHashSet();
                int logX = position.m_123341_();
                int logZ = position.m_123343_();
                boolean canopy = false;
                for (int k1 = 0; k1 < height; ++k1) {
                    int logY = position.m_123342_() + k1;
                    BlockPos blockpos = new BlockPos(logX, logY, logZ);
                    if (!this.water ? TreeUtil.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)blockpos) : RainforestTreeFeature.isAirOrWaterOrLeaves((LevelSimulatedReader)level, blockpos)) {
                        TreeUtil.placeDirectionalLogAt((LevelWriter)level, (BlockPos)blockpos, (Direction)Direction.UP, (RandomSource)rand, (TreeConfiguration)config);
                        logsPlaced.add(blockpos.m_7949_());
                    }
                    if (rand.m_188503_(6) != 0 || k1 <= 3 || canopy) continue;
                    int leafSize = 1 + rand.m_188503_(2);
                    for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
                        for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                            if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize || level.m_7433_(blockpos.m_7918_(k3, 0, j4), state -> state.m_60713_(Blocks.f_49990_))) continue;
                            TreeUtil.placeLeafAt((LevelSimulatedRW)level, (BlockPos)blockpos.m_7918_(k3, 0, j4), (RandomSource)rand, (TreeConfiguration)config);
                        }
                    }
                    canopy = true;
                }
                ArrayList<String> directions = new ArrayList<String>();
                for (int k2 = 0; k2 < branches; ++k2) {
                    int j4;
                    int k3;
                    Direction offset = Direction.Plane.HORIZONTAL.m_235690_(rand);
                    while (directions.contains(offset.toString())) {
                        offset = Direction.Plane.HORIZONTAL.m_235690_(rand);
                    }
                    directions.add(offset.toString());
                    int turns = 1 + rand.m_188503_(3);
                    BlockPos currentPos = position.m_6630_(height - 1);
                    int branchLength = 0;
                    int branchHeight = 0;
                    for (int k4 = 0; k4 < turns; ++k4) {
                        branchLength = !morado ? 1 + rand.m_188503_(2) + rand.m_188503_(2) : 1 + rand.m_188503_(2);
                        branchHeight = !morado ? 1 + rand.m_188503_(3) + rand.m_188503_(2) : 1 + rand.m_188503_(3);
                        this.createHorizontalLog(branchLength, (LevelSimulatedRW)level, currentPos, offset, rand, config, logsPlaced);
                        this.createVerticalLog(branchHeight, (LevelSimulatedRW)level, currentPos.m_5484_(offset, branchLength), rand, config, logsPlaced);
                        currentPos = currentPos.m_5484_(offset, branchLength).m_5484_(Direction.UP, branchHeight);
                    }
                    int leafSize = 2 + rand.m_188503_(2);
                    int leafSizeTop = 0;
                    leafSizeTop = leafSize == 2 ? leafSize - 1 : leafSize - 1 - rand.m_188503_(2);
                    for (k3 = -leafSize; k3 <= leafSize; ++k3) {
                        for (j4 = -leafSize; j4 <= leafSize; ++j4) {
                            if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize || level.m_7433_(currentPos.m_7918_(k3, 0, j4), state -> state.m_60713_(Blocks.f_49990_))) continue;
                            TreeUtil.placeLeafAt((LevelSimulatedRW)level, (BlockPos)currentPos.m_7918_(k3, 0, j4), (RandomSource)rand, (TreeConfiguration)config);
                        }
                    }
                    currentPos = currentPos.m_6630_(1);
                    for (k3 = -leafSizeTop; k3 <= leafSizeTop; ++k3) {
                        for (j4 = -leafSizeTop; j4 <= leafSizeTop; ++j4) {
                            if (Math.abs(k3) == leafSizeTop && Math.abs(j4) == leafSizeTop || level.m_7433_(currentPos.m_7918_(k3, 0, j4), state -> state.m_60713_(Blocks.f_49990_))) continue;
                            TreeUtil.placeLeafAt((LevelSimulatedRW)level, (BlockPos)currentPos.m_7918_(k3, 0, j4), (RandomSource)rand, (TreeConfiguration)config);
                        }
                    }
                    if (morado) {
                        for (k3 = -leafSizeTop; k3 <= leafSizeTop; ++k3) {
                            for (j4 = -leafSizeTop - 1; j4 <= leafSizeTop + 1; ++j4) {
                                if (Math.abs(k3) == leafSizeTop && Math.abs(j4) == leafSizeTop || !rand.m_188499_() || level.m_7433_(currentPos.m_7918_(k3, 0, j4), state -> state.m_60713_(Blocks.f_49990_))) continue;
                                TreeUtil.placeLeafAt((LevelSimulatedRW)level, (BlockPos)currentPos.m_7918_(k3, 0, j4), (RandomSource)rand, (TreeConfiguration)config);
                            }
                        }
                    }
                    if (!morado) continue;
                    currentPos = currentPos.m_6625_(2);
                    for (k3 = -leafSizeTop; k3 <= leafSizeTop; ++k3) {
                        for (j4 = -leafSizeTop - 1; j4 <= leafSizeTop + 1; ++j4) {
                            if (Math.abs(k3) == leafSizeTop && Math.abs(j4) == leafSizeTop || !rand.m_188499_() || level.m_7433_(currentPos.m_7918_(k3, 0, j4), state -> state.m_60713_(Blocks.f_49990_))) continue;
                            TreeUtil.placeLeafAt((LevelSimulatedRW)level, (BlockPos)currentPos.m_7918_(k3, 0, j4), (RandomSource)rand, (TreeConfiguration)config);
                        }
                    }
                }
                if (!this.brushes.isEmpty()) {
                    for (BlockPos pos : logsPlaced) {
                        for (Direction direction2 : Direction.values()) {
                            if (!level.m_7433_(pos.m_121945_(direction2), BlockBehaviour.BlockStateBase::m_60795_) || rand.m_188503_(3) != 0) continue;
                            level.m_7731_(pos.m_121945_(direction2), MonkeyBrushFeature.monkeyBrushState(this.brushes.get(rand.m_188503_(this.brushes.size())).m_49966_(), direction2), 18);
                        }
                    }
                }
                TreeUtil.updateLeaves((LevelAccessor)level, (Set)logsPlaced);
                HashSet set3 = Sets.newHashSet();
                BiConsumer<BlockPos, BlockState> biconsumer3 = (p_225290_, p_225291_) -> {
                    set3.add(p_225290_.m_7949_());
                    level.m_7731_(p_225290_, p_225291_, 19);
                };
                if (!config.f_68187_.isEmpty()) {
                    TreeDecorator.Context decoratorContext = new TreeDecorator.Context((LevelSimulatedReader)level, biconsumer3, rand, (Set)logsPlaced, (Set)Sets.newHashSet(), (Set)Sets.newHashSet());
                    config.f_68187_.forEach(decorator -> decorator.m_214187_(decoratorContext));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void createHorizontalLog(int branchLength, LevelSimulatedRW worldIn, BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config, Set<BlockPos> logsPlaced) {
        int logX = pos.m_123341_();
        int logY = pos.m_123342_();
        int logZ = pos.m_123343_();
        for (int k3 = 0; k3 < branchLength; ++k3) {
            BlockPos blockpos1 = new BlockPos(logX += direction.m_122429_(), logY, logZ += direction.m_122431_());
            if (!(!this.water ? TreeUtil.isAirOrLeaves((LevelSimulatedReader)worldIn, (BlockPos)blockpos1) : RainforestTreeFeature.isAirOrWaterOrLeaves((LevelSimulatedReader)worldIn, blockpos1))) continue;
            TreeUtil.placeDirectionalLogAt((LevelWriter)worldIn, (BlockPos)blockpos1, (Direction)direction, (RandomSource)random, (TreeConfiguration)config);
            logsPlaced.add(blockpos1.m_7949_());
        }
    }

    private void createVerticalLog(int branchHeight, LevelSimulatedRW level, BlockPos pos, RandomSource random, TreeConfiguration config, Set<BlockPos> logsPlaced) {
        int logX = pos.m_123341_();
        int logY = pos.m_123342_();
        int logZ = pos.m_123343_();
        boolean canopy = false;
        for (int k1 = 0; k1 < branchHeight; ++k1) {
            BlockPos blockpos = new BlockPos(logX, ++logY, logZ);
            if (!this.water ? TreeUtil.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)blockpos) : RainforestTreeFeature.isAirOrWaterOrLeaves((LevelSimulatedReader)level, blockpos)) {
                TreeUtil.placeDirectionalLogAt((LevelWriter)level, (BlockPos)blockpos, (Direction)Direction.UP, (RandomSource)random, (TreeConfiguration)config);
                logsPlaced.add(blockpos.m_7949_());
            }
            if (random.m_188503_(6) != 0 || canopy) continue;
            int leafSize = 1 + random.m_188503_(2);
            for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
                for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                    if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize || level.m_7433_(blockpos.m_7918_(k3, 0, j4), state -> state.m_60713_(Blocks.f_49990_))) continue;
                    TreeUtil.placeLeafAt((LevelSimulatedRW)level, (BlockPos)blockpos.m_7918_(k3, 0, j4), (RandomSource)random, (TreeConfiguration)config);
                }
            }
            canopy = true;
        }
    }

    public static boolean isAirOrWaterOrLeaves(LevelSimulatedReader world, BlockPos pos) {
        return TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || RainforestTreeFeature.isWater(world, pos);
    }

    public static boolean isWater(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, state -> state.m_60713_(Blocks.f_49990_));
    }
}

