/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.common.levelgen.feature.configurations.YuccaTreeConfiguration;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.blueprint.core.util.TreeUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public class YuccaTreeFeature
extends Feature<YuccaTreeConfiguration> {
    private Set<BlockPos> logPosSet;

    public YuccaTreeFeature(Codec<YuccaTreeConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<YuccaTreeConfiguration> context) {
        YuccaTreeConfiguration config = (YuccaTreeConfiguration)context.m_159778_();
        WorldGenLevel worldIn = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos position = context.m_159777_();
        this.logPosSet = Sets.newHashSet();
        if (config.baby) {
            int height = 2 + rand.m_188503_(2) + rand.m_188503_(2);
            boolean flag = true;
            if (position.m_123342_() > worldIn.m_141937_() && position.m_123342_() + height + 1 <= worldIn.m_151558_()) {
                for (int j = position.m_123342_(); j <= position.m_123342_() + 1 + height; ++j) {
                    int k = 1;
                    if (j == position.m_123342_()) {
                        k = 0;
                    }
                    if (j >= position.m_123342_() + 1 + height - 2) {
                        k = 2;
                    }
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                    for (int l = position.m_123341_() - k; l <= position.m_123341_() + k && flag; ++l) {
                        for (int i1 = position.m_123343_() - k; i1 <= position.m_123343_() + k && flag; ++i1) {
                            if (j >= worldIn.m_141937_() && j < worldIn.m_151558_()) {
                                if (TreeUtil.isAirOrLeaves((LevelSimulatedReader)worldIn, (BlockPos)blockpos$mutableblockpos.m_122178_(l, j, i1))) continue;
                                flag = false;
                                continue;
                            }
                            flag = false;
                        }
                    }
                }
                if (!flag) {
                    return false;
                }
                if (TreeUtil.isInTag((LevelSimulatedReader)worldIn, (BlockPos)position.m_7495_(), AtmosphericBlockTags.YUCCA_PLACEABLE) && position.m_123342_() < worldIn.m_151558_()) {
                    if (!TreeUtil.isInTag((LevelSimulatedReader)worldIn, (BlockPos)position.m_7495_(), (TagKey)BlockTags.f_13029_)) {
                        TreeUtil.setDirtAt((LevelAccessor)worldIn, (BlockPos)position.m_7495_());
                    }
                    int logX = position.m_123341_();
                    int logZ = position.m_123343_();
                    int logY = position.m_123342_();
                    for (int k1 = 0; k1 < height; ++k1) {
                        logY = position.m_123342_() + k1;
                        BlockPos blockpos = new BlockPos(logX, logY, logZ);
                        if (!TreeUtil.isAirOrLeaves((LevelSimulatedReader)worldIn, (BlockPos)blockpos)) continue;
                        this.placeLogAt((LevelWriter)worldIn, blockpos, Direction.UP, false, rand, config);
                    }
                    logY = position.m_123342_() + height - 1;
                    position = new BlockPos(logX, logY, logZ);
                    this.createBabyYuccaLeaves((LevelSimulatedRW)worldIn, position.m_7494_(), rand, config, false);
                    this.createBabyYuccaLeaves((LevelSimulatedRW)worldIn, position, rand, config, true);
                    this.createBabyYuccaLeaves((LevelSimulatedRW)worldIn, position.m_7495_(), rand, config, false);
                    if (config.patch) {
                        for (int j = 0; j < 64; ++j) {
                            BlockPos blockpos = position.m_7918_(rand.m_188503_(8) - rand.m_188503_(8), rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(8) - rand.m_188503_(8));
                            if (!worldIn.m_7433_(blockpos, BlockBehaviour.BlockStateBase::m_60795_) || blockpos.m_123342_() >= worldIn.m_151558_() || !config.flowerProvider.m_213972_(rand, blockpos).m_60710_((LevelReader)worldIn, blockpos)) continue;
                            this.placeFlowerAt((LevelSimulatedRW)worldIn, blockpos, rand, config);
                        }
                    }
                    TreeUtil.updateLeaves((LevelAccessor)worldIn, this.logPosSet);
                    return true;
                }
                return false;
            }
            return false;
        }
        int height = 4 + rand.m_188503_(2) + rand.m_188503_(2);
        int reduction = 2 + rand.m_188503_(3);
        if (config.petrified) {
            height -= reduction;
        }
        boolean flag = true;
        if (position.m_123342_() >= worldIn.m_141937_() && position.m_123342_() + height + 1 <= worldIn.m_151558_()) {
            for (int j = position.m_123342_(); j <= position.m_123342_() + 1 + height; ++j) {
                int k = 1;
                if (j == position.m_123342_()) {
                    k = 0;
                }
                if (j >= position.m_123342_() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.m_123341_() - k; l <= position.m_123341_() + k && flag; ++l) {
                    for (int i1 = position.m_123343_() - k; i1 <= position.m_123343_() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.m_151558_()) {
                            if (TreeUtil.isAirOrLeaves((LevelSimulatedReader)worldIn, (BlockPos)blockpos$mutableblockpos.m_122178_(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeUtil.isInTag((LevelSimulatedReader)worldIn, (BlockPos)position.m_7495_(), AtmosphericBlockTags.YUCCA_PLACEABLE) && position.m_123342_() < worldIn.m_151558_()) {
                BlockPos blockpos;
                if (!TreeUtil.isInTag((LevelSimulatedReader)worldIn, (BlockPos)position.m_7495_(), (TagKey)BlockTags.f_13029_)) {
                    TreeUtil.setDirtAt((LevelAccessor)worldIn, (BlockPos)position.m_7495_());
                }
                for (int ja = 0; ja < reduction; ++ja) {
                    if (!config.petrified) continue;
                    this.placeLogAt((LevelWriter)worldIn, position.m_6625_(ja), Direction.UP, false, rand, config);
                }
                int logX = position.m_123341_();
                int logZ = position.m_123343_();
                int logY = position.m_123342_();
                for (int k1 = 0; k1 < height; ++k1) {
                    logY = position.m_123342_() + k1;
                    BlockPos blockpos2 = new BlockPos(logX, logY, logZ);
                    if (!TreeUtil.isAirOrLeaves((LevelSimulatedReader)worldIn, (BlockPos)blockpos2)) continue;
                    this.placeLogAt((LevelWriter)worldIn, blockpos2, Direction.UP, false, rand, config);
                }
                logY = position.m_123342_() + height - 1;
                BlockPos newPos = this.createYuccaBranch(height, (LevelSimulatedRW)worldIn, position, Direction.NORTH, rand, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos.m_7494_(), rand, false, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos, rand, true, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos.m_7495_(), rand, false, config);
                newPos = this.createYuccaBranch(height, (LevelSimulatedRW)worldIn, position, Direction.EAST, rand, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos.m_7494_(), rand, false, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos, rand, true, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos.m_7495_(), rand, false, config);
                newPos = this.createYuccaBranch(height, (LevelSimulatedRW)worldIn, position, Direction.SOUTH, rand, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos.m_7494_(), rand, false, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos, rand, true, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos.m_7495_(), rand, false, config);
                newPos = this.createYuccaBranch(height, (LevelSimulatedRW)worldIn, position, Direction.WEST, rand, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos.m_7494_(), rand, false, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos, rand, true, config);
                this.createYuccaLeaves((LevelSimulatedRW)worldIn, newPos.m_7495_(), rand, false, config);
                if (config.patch) {
                    for (int j = 0; j < 64; ++j) {
                        blockpos = position.m_7918_(rand.m_188503_(8) - rand.m_188503_(8), rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(8) - rand.m_188503_(8));
                        if (!worldIn.m_7433_(blockpos, BlockBehaviour.BlockStateBase::m_60795_) || blockpos.m_123342_() >= worldIn.m_151558_() || !config.flowerProvider.m_213972_(rand, blockpos).m_60710_((LevelReader)worldIn, blockpos)) continue;
                        this.placeFlowerAt((LevelSimulatedRW)worldIn, blockpos, rand, config);
                    }
                }
                if (config.petrified && rand.m_188503_(12) == 0) {
                    for (int j = 0; j < 12; ++j) {
                        blockpos = position.m_7918_(rand.m_188503_(6) - rand.m_188503_(6), rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(6) - rand.m_188503_(6));
                        if (!worldIn.m_7433_(blockpos, BlockBehaviour.BlockStateBase::m_60795_) || blockpos.m_123342_() >= worldIn.m_151558_() || !TreeUtil.isInTag((LevelSimulatedReader)worldIn, (BlockPos)blockpos.m_7495_(), (TagKey)BlockTags.f_13029_)) continue;
                        TreeUtil.setForcedState((LevelWriter)worldIn, (BlockPos)blockpos, (BlockState)config.bundleProvider.m_213972_(rand, blockpos));
                    }
                }
                TreeUtil.updateLeaves((LevelAccessor)worldIn, this.logPosSet);
                HashSet set3 = Sets.newHashSet();
                BiConsumer<BlockPos, BlockState> biconsumer3 = (p_225290_, p_225291_) -> {
                    set3.add(p_225290_.m_7949_());
                    worldIn.m_7731_(p_225290_, p_225291_, 19);
                };
                if (!config.decorators.isEmpty()) {
                    TreeDecorator.Context decoratorContext = new TreeDecorator.Context((LevelSimulatedReader)worldIn, biconsumer3, rand, this.logPosSet, (Set)Sets.newHashSet(), (Set)Sets.newHashSet());
                    config.decorators.forEach(decorator -> decorator.m_214187_(decoratorContext));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void createYuccaLeaves(LevelSimulatedRW worldIn, BlockPos newPos, RandomSource rand, boolean square, YuccaTreeConfiguration config) {
        int leafSize = 1;
        for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
            for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                if (square) {
                    this.placeLeafAt(worldIn, newPos.m_7918_(k3, 0, j4), rand, config);
                    continue;
                }
                if (Math.abs(k3) != leafSize || Math.abs(j4) != leafSize) {
                    this.placeLeafAt(worldIn, newPos.m_7918_(k3, 0, j4), rand, config);
                    continue;
                }
                if (rand.m_188503_(4) != 0) continue;
                this.placeLeafAt(worldIn, newPos.m_7918_(k3, 0, j4), rand, config);
            }
        }
    }

    private BlockPos createYuccaBranch(int height, LevelSimulatedRW worldIn, BlockPos pos, Direction direction, RandomSource rand, YuccaTreeConfiguration config) {
        int logX = pos.m_123341_();
        int logZ = pos.m_123343_();
        int logY = pos.m_123342_() + height - 1;
        int length = 4 + rand.m_188503_(2);
        BlockPos blockpos = new BlockPos(logX, logY, logZ);
        boolean bundle = false;
        boolean anyBundle = false;
        for (int i = 0; i < length; ++i) {
            blockpos = new BlockPos(logX, logY, logZ);
            if (!anyBundle && rand.m_188503_(16) == 0) {
                bundle = true;
                anyBundle = true;
            } else {
                bundle = false;
            }
            this.createHorizontalLog(1, worldIn, blockpos, direction, bundle, rand, config);
            if (i == length) continue;
            if (direction == Direction.EAST || direction == Direction.WEST) {
                logX = direction == Direction.EAST ? (logX += rand.m_188503_(2)) : (logX -= rand.m_188503_(2));
            } else {
                logZ = direction == Direction.SOUTH ? (logZ += rand.m_188503_(2)) : (logZ -= rand.m_188503_(2));
            }
            ++logY;
        }
        return blockpos.m_121945_(direction);
    }

    private void createHorizontalLog(int branchLength, LevelSimulatedRW worldIn, BlockPos pos, Direction direction, boolean bundle, RandomSource rand, YuccaTreeConfiguration config) {
        int logX = pos.m_123341_();
        int logY = pos.m_123342_();
        int logZ = pos.m_123343_();
        for (int k3 = 0; k3 < branchLength; ++k3) {
            BlockPos blockpos1 = new BlockPos(logX += direction.m_122429_(), logY, logZ += direction.m_122431_());
            if (!TreeUtil.isAirOrLeaves((LevelSimulatedReader)worldIn, (BlockPos)blockpos1)) continue;
            if (!worldIn.m_7433_(blockpos1.m_7495_(), BlockBehaviour.BlockStateBase::m_60795_)) {
                bundle = false;
            }
            this.placeLogAt((LevelWriter)worldIn, blockpos1, Direction.UP, bundle, rand, config);
        }
    }

    private void placeLogAt(LevelWriter worldIn, BlockPos pos, Direction direction, boolean bundle, RandomSource rand, YuccaTreeConfiguration config) {
        BlockState logState = config.petrified ? config.trunkProvider.m_213972_(rand, pos) : (BlockState)config.trunkProvider.m_213972_(rand, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
        TreeUtil.setForcedState((LevelWriter)worldIn, (BlockPos)pos, (BlockState)logState);
        this.logPosSet.add(pos.m_7949_());
        if (bundle && !config.petrified) {
            TreeUtil.setForcedState((LevelWriter)worldIn, (BlockPos)pos.m_7495_(), (BlockState)config.branchProvider.m_213972_(rand, pos.m_7495_()));
        }
    }

    private void placeLeafAt(LevelSimulatedRW world, BlockPos pos, RandomSource rand, YuccaTreeConfiguration config) {
        if (TreeUtil.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos) && !config.petrified) {
            TreeUtil.setForcedState((LevelWriter)world, (BlockPos)pos, (BlockState)config.leavesProvider.m_213972_(rand, pos));
        }
        if (rand.m_188503_(8) == 0 && !config.petrified) {
            this.placeFlowerAt(world, pos.m_7494_(), rand, config);
        }
    }

    private void createBabyYuccaLeaves(LevelSimulatedRW worldIn, BlockPos newPos, RandomSource rand, YuccaTreeConfiguration config, boolean square) {
        int leafSize = 1;
        for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
            for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                if (square) {
                    this.placeLeafAt(worldIn, newPos.m_7918_(k3, 0, j4), rand, config);
                    continue;
                }
                if (Math.abs(k3) != leafSize || Math.abs(j4) != leafSize) {
                    this.placeLeafAt(worldIn, newPos.m_7918_(k3, 0, j4), rand, config);
                    continue;
                }
                if (rand.m_188503_(4) != 0) continue;
                this.placeLeafAt(worldIn, newPos.m_7918_(k3, 0, j4), rand, config);
            }
        }
    }

    private void placeFlowerAt(LevelSimulatedRW world, BlockPos pos, RandomSource rand, YuccaTreeConfiguration config) {
        if (world.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_)) {
            if (!world.m_7433_(pos.m_7494_(), BlockBehaviour.BlockStateBase::m_60795_)) {
                TreeUtil.setForcedState((LevelWriter)world, (BlockPos)pos, (BlockState)config.flowerProvider.m_213972_(rand, pos));
            } else if (rand.m_188503_(4) == 0) {
                TreeUtil.setForcedState((LevelWriter)world, (BlockPos)pos, (BlockState)config.tallFlowerBottomProvider.m_213972_(rand, pos));
                TreeUtil.setForcedState((LevelWriter)world, (BlockPos)pos.m_7494_(), (BlockState)config.tallFlowerTopProvider.m_213972_(rand, pos.m_7494_()));
            } else {
                TreeUtil.setForcedState((LevelWriter)world, (BlockPos)pos, (BlockState)config.flowerProvider.m_213972_(rand, pos));
            }
        }
    }
}

