/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core;

import com.teamabnormals.atmospheric.client.renderer.entity.PassionfruitSeedRenderer;
import com.teamabnormals.atmospheric.client.renderer.entity.model.PassionfruitSeedModel;
import com.teamabnormals.atmospheric.core.AtmosphericConfig;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericAdvancementProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericAdvancementModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericBiomeModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericChunkGeneratorModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericLootModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericModdedBiomeSliceProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericBiomeTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericBlockTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericEntityTypeTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericItemTagsProvider;
import com.teamabnormals.atmospheric.core.other.AtmosphericClientCompat;
import com.teamabnormals.atmospheric.core.other.AtmosphericCompat;
import com.teamabnormals.atmospheric.core.other.AtmosphericModelLayers;
import com.teamabnormals.atmospheric.core.other.AtmosphericVillagers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import com.teamabnormals.atmospheric.core.registry.AtmosphericNoiseParameters;
import com.teamabnormals.atmospheric.core.registry.AtmosphericParticleTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericPlacementModifierTypes;
import com.teamabnormals.atmospheric.core.registry.helper.AtmosphericBlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="atmospheric")
@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Atmospheric {
    public static final String MOD_ID = "atmospheric";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"atmospheric", helper -> helper.putSubHelper(ForgeRegistries.BLOCKS, (ISubRegistryHelper)new AtmosphericBlockSubRegistryHelper((RegistryHelper)helper)));

    public Atmospheric() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        REGISTRY_HELPER.register(bus);
        AtmosphericFeatures.FEATURES.register(bus);
        AtmosphericFeatures.AtmosphericConfiguredFeatures.CONFIGURED_FEATURES.register(bus);
        AtmosphericFeatures.AtmosphericPlacedFeatures.PLACED_FEATURES.register(bus);
        AtmosphericNoiseParameters.NOISE_PARAMETERS.register(bus);
        AtmosphericPlacementModifierTypes.PLACEMENT_MODIFIER_TYPES.register(bus);
        AtmosphericParticleTypes.PARTICLES.register(bus);
        AtmosphericMobEffects.EFFECTS.register(bus);
        AtmosphericMobEffects.POTIONS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AtmosphericConfig.COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)AtmosphericConfig.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AtmosphericVillagers.setupVillagerTypes();
            AtmosphericCompat.registerCompat();
            AtmosphericMobEffects.registerBrewingRecipes();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            AtmosphericClientCompat.registerBlockColors();
            AtmosphericClientCompat.registerRenderLayers();
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        AtmosphericBlockTagsProvider blockTags = new AtmosphericBlockTagsProvider(generator, existingFileHelper);
        generator.m_236039_(includeServer, (DataProvider)blockTags);
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericItemTagsProvider(generator, blockTags, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericEntityTypeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericBiomeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericAdvancementProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericAdvancementModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericLootModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericChunkGeneratorModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericModdedBiomeSliceProvider(generator));
        generator.m_236039_(includeServer, AtmosphericBiomeModifierProvider.create(generator, existingFileHelper));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(AtmosphericModelLayers.PASSIONFRUIT_SEED, PassionfruitSeedModel::createBodyLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)AtmosphericEntityTypes.PASSIONFRUIT_SEED.get(), PassionfruitSeedRenderer::new);
    }
}

