/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry;

import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericGeneration;
import com.teamabnormals.blueprint.core.util.registry.BiomeSubRegistryHelper;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtmosphericBiomes {
    public static final BiomeSubRegistryHelper HELPER = (BiomeSubRegistryHelper)Atmospheric.REGISTRY_HELPER.getBiomeSubHelper();
    public static final BiomeSubRegistryHelper.KeyedBiome RAINFOREST = HELPER.createBiome("rainforest", AtmosphericBiomes::rainforest);
    public static final BiomeSubRegistryHelper.KeyedBiome SPARSE_RAINFOREST = HELPER.createBiome("sparse_rainforest", AtmosphericBiomes::sparseRainforest);
    public static final BiomeSubRegistryHelper.KeyedBiome RAINFOREST_BASIN = HELPER.createBiome("rainforest_basin", AtmosphericBiomes::rainforestBasin);
    public static final BiomeSubRegistryHelper.KeyedBiome SPARSE_RAINFOREST_BASIN = HELPER.createBiome("sparse_rainforest_basin", AtmosphericBiomes::sparseRainforestBasin);
    public static final BiomeSubRegistryHelper.KeyedBiome DUNES = HELPER.createBiome("dunes", AtmosphericBiomes::dunes);
    public static final BiomeSubRegistryHelper.KeyedBiome FLOURISHING_DUNES = HELPER.createBiome("flourishing_dunes", AtmosphericBiomes::flourishingDunes);
    public static final BiomeSubRegistryHelper.KeyedBiome ROCKY_DUNES = HELPER.createBiome("rocky_dunes", AtmosphericBiomes::rockyDunes);
    public static final BiomeSubRegistryHelper.KeyedBiome PETRIFIED_DUNES = HELPER.createBiome("petrified_dunes", AtmosphericBiomes::petrifiedDunes);
    public static final BiomeSubRegistryHelper.KeyedBiome HOT_SPRINGS = HELPER.createBiome("hot_springs", AtmosphericBiomes::hotsprings);

    private static Biome rainforest() {
        MobSpawnSettings.Builder spawns = AtmosphericBiomes.baseRainforestSpawns();
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.rainforest(generation);
        return AtmosphericBiomes.rainforestBase(spawns, generation);
    }

    private static Biome sparseRainforest() {
        MobSpawnSettings.Builder spawns = AtmosphericBiomes.baseRainforestSpawns();
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.sparseRainforest(generation);
        return AtmosphericBiomes.rainforestBase(spawns, generation);
    }

    private static Biome rainforestBasin() {
        MobSpawnSettings.Builder spawns = AtmosphericBiomes.baseRainforestSpawns();
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.rainforestBasin(generation);
        return AtmosphericBiomes.rainforestBase(spawns, generation);
    }

    private static Biome sparseRainforestBasin() {
        MobSpawnSettings.Builder spawns = AtmosphericBiomes.baseRainforestSpawns();
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.sparseRainforestBasin(generation);
        return AtmosphericBiomes.rainforestBase(spawns, generation);
    }

    private static MobSpawnSettings.Builder baseRainforestSpawns() {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        return spawns;
    }

    private static Biome dunes() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.dunes(generation);
        return AtmosphericBiomes.dunesBase(generation);
    }

    private static Biome rockyDunes() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.withRockyDunesFeatures(generation);
        return AtmosphericBiomes.dunesBase(generation);
    }

    private static Biome petrifiedDunes() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.withPetrifiedDunesFeatures(generation);
        return AtmosphericBiomes.dunesBase(generation);
    }

    private static Biome flourishingDunes() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.flourishingDunes(generation);
        return AtmosphericBiomes.dunesBase(generation);
    }

    private static Biome rainforestBase(MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation) {
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.9f).m_47611_(0.95f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(6675400).m_48037_(408635).m_48019_(12638463).m_48040_(AtmosphericBiomes.getSkyColorWithTemperatureModifier(0.9f)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static Biome dunesBase(BiomeGenerationSettings.Builder generation) {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawns);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(14988944).m_48040_(AtmosphericBiomes.getSkyColorWithTemperatureModifier(2.0f)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static Biome hotsprings() {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        AtmosphericGeneration.withHotSpringsFeatures(generation, spawns);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(0.25f).m_47611_(0.4f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4445678).m_48037_(270131).m_48019_(12638463).m_48040_(AtmosphericBiomes.getSkyColorWithTemperatureModifier(0.25f)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = Mth.m_14036_((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }
}

