/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.common.block.AloeVeraBlock;
import com.teamabnormals.atmospheric.common.block.AloeVeraTallBlock;
import com.teamabnormals.atmospheric.common.block.BarrelCactusBlock;
import com.teamabnormals.atmospheric.common.block.YuccaFlowerDoubleBlock;
import com.teamabnormals.atmospheric.common.levelgen.feature.AspenTreeFeature;
import com.teamabnormals.atmospheric.common.levelgen.feature.CoarseDirtPatchFeature;
import com.teamabnormals.atmospheric.common.levelgen.feature.DuneRocksFeature;
import com.teamabnormals.atmospheric.common.levelgen.feature.MonkeyBrushFeature;
import com.teamabnormals.atmospheric.common.levelgen.feature.OceanFloorRaiserFeature;
import com.teamabnormals.atmospheric.common.levelgen.feature.PassionVineFeature;
import com.teamabnormals.atmospheric.common.levelgen.feature.PodzolFeature;
import com.teamabnormals.atmospheric.common.levelgen.feature.RainforestTreeFeature;
import com.teamabnormals.atmospheric.common.levelgen.feature.SurfaceFossilFeature;
import com.teamabnormals.atmospheric.common.levelgen.feature.WaterHyacinthPatchFeature;
import com.teamabnormals.atmospheric.common.levelgen.feature.YuccaTreeFeature;
import com.teamabnormals.atmospheric.common.levelgen.feature.configurations.LargeDiskConfiguration;
import com.teamabnormals.atmospheric.common.levelgen.feature.configurations.YuccaTreeConfiguration;
import com.teamabnormals.atmospheric.common.levelgen.placement.InSquareCenterPlacement;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BushFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.SpruceFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtmosphericFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"atmospheric");
    public static final RegistryObject<Feature<ProbabilityFeatureConfiguration>> PODZOL = FEATURES.register("podzol", () -> new PodzolFeature((Codec<ProbabilityFeatureConfiguration>)ProbabilityFeatureConfiguration.f_67858_));
    public static final RegistryObject<SurfaceFossilFeature> SURFACE_FOSSIL = FEATURES.register("surface_fossil", () -> new SurfaceFossilFeature((Codec<FossilFeatureConfiguration>)FossilFeatureConfiguration.f_159796_));
    public static final RegistryObject<Feature<LargeDiskConfiguration>> COARSE_DIRT_PATCH = FEATURES.register("coarse_dirt_patch", () -> new CoarseDirtPatchFeature(LargeDiskConfiguration.CODEC));
    public static final RegistryObject<Feature<BlockStateConfiguration>> DUNE_ROCK = FEATURES.register("dune_rock", () -> new DuneRocksFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.f_67546_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> WARM_MONKEY_BRUSH = FEATURES.register("warm_monkey_brush", () -> new MonkeyBrushFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, 1));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> HOT_MONKEY_BRUSH = FEATURES.register("hot_monkey_brush", () -> new MonkeyBrushFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, 2));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SCALDING_MONKEY_BRUSH = FEATURES.register("scalding_monkey_brush", () -> new MonkeyBrushFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, 3));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> WATER_HYACINTH_PATCH = FEATURES.register("water_hyacinth_patch", () -> new WaterHyacinthPatchFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> PASSION_VINE = FEATURES.register("passion_vine", () -> new PassionVineFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<TreeConfiguration>> ROSEWOOD_TREE = FEATURES.register("rosewood_tree", () -> new RainforestTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, false));
    public static final RegistryObject<Feature<TreeConfiguration>> ROSEWOOD_WATER_TREE = FEATURES.register("rosewood_water_tree", () -> new RainforestTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_, true));
    public static final RegistryObject<Feature<YuccaTreeConfiguration>> YUCCA_TREE = FEATURES.register("yucca_tree", () -> new YuccaTreeFeature(YuccaTreeConfiguration.CODEC));
    public static final RegistryObject<Feature<TreeConfiguration>> ASPEN_TREE = FEATURES.register("aspen_tree", () -> new AspenTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> OCEAN_FLOOR_RAISER = FEATURES.register("ocean_floor_raiser", () -> new OceanFloorRaiserFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));

    public static final class AtmosphericPlacedFeatures {
        public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"atmospheric");
        public static final RegistryObject<PlacedFeature> OAK_BUSH = AtmosphericPlacedFeatures.register("oak_bush", AtmosphericConfiguredFeatures.OAK_BUSH, List.of(PlacementUtils.m_206493_((Block)Blocks.f_50746_)));
        public static final RegistryObject<PlacedFeature> ROSEWOOD_BEES_0002 = AtmosphericPlacedFeatures.register("rosewood_bees_0002", AtmosphericConfiguredFeatures.ROSEWOOD_BEES_0002, List.of(PlacementUtils.m_206493_((Block)Blocks.f_50746_)));
        public static final RegistryObject<PlacedFeature> MORADO_BEES_0002 = AtmosphericPlacedFeatures.register("morado_bees_0002", AtmosphericConfiguredFeatures.MORADO_BEES_0002, List.of(PlacementUtils.m_206493_((Block)Blocks.f_50746_)));
        public static final RegistryObject<PlacedFeature> WATER_ROSEWOOD = AtmosphericPlacedFeatures.register("water_rosewood", AtmosphericConfiguredFeatures.WATER_ROSEWOOD, List.of());
        public static final RegistryObject<PlacedFeature> WATER_MORADO = AtmosphericPlacedFeatures.register("water_morado", AtmosphericConfiguredFeatures.WATER_MORADO, List.of());
        public static final RegistryObject<PlacedFeature> YUCCA = AtmosphericPlacedFeatures.register("yucca", AtmosphericConfiguredFeatures.YUCCA, List.of());
        public static final RegistryObject<PlacedFeature> YUCCA_WITH_FLOWERS = AtmosphericPlacedFeatures.register("yucca_with_flowers", AtmosphericConfiguredFeatures.YUCCA_WITH_FLOWERS, List.of());
        public static final RegistryObject<PlacedFeature> BABY_YUCCA = AtmosphericPlacedFeatures.register("baby_yucca", AtmosphericConfiguredFeatures.BABY_YUCCA, List.of());
        public static final RegistryObject<PlacedFeature> BABY_YUCCA_WITH_FLOWERS = AtmosphericPlacedFeatures.register("baby_yucca_with_flowers", AtmosphericConfiguredFeatures.BABY_YUCCA_WITH_FLOWERS, List.of());
        public static final RegistryObject<PlacedFeature> PETRIFIED_YUCCA = AtmosphericPlacedFeatures.register("petrified_yucca", AtmosphericConfiguredFeatures.PETRIFIED_YUCCA, List.of());
        public static final RegistryObject<PlacedFeature> RED_PETRIFIED_YUCCA = AtmosphericPlacedFeatures.register("red_petrified_yucca", AtmosphericConfiguredFeatures.RED_PETRIFIED_YUCCA, List.of());
        public static final RegistryObject<PlacedFeature> TREES_RAINFOREST = AtmosphericPlacedFeatures.register("trees_rainforest", AtmosphericConfiguredFeatures.TREES_RAINFOREST, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)30, (float)0.1f, (int)1), (Block)Blocks.f_50746_));
        public static final RegistryObject<PlacedFeature> BUSHES_SPARSE_RAINFOREST = AtmosphericPlacedFeatures.register("bushes_sparse_rainforest", AtmosphericConfiguredFeatures.OAK_BUSH, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)2, (float)0.1f, (int)3), (Block)Blocks.f_50746_));
        public static final RegistryObject<PlacedFeature> TREES_SPARSE_RAINFOREST = AtmosphericPlacedFeatures.register("trees_sparse_rainforest", AtmosphericConfiguredFeatures.TREES_SPARSE_RAINFOREST, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.1f, (int)30), (Block)Blocks.f_50746_));
        public static final RegistryObject<PlacedFeature> TREES_RAINFOREST_BASIN = AtmosphericPlacedFeatures.register("trees_rainforest_basin", AtmosphericConfiguredFeatures.TREES_RAINFOREST_BASIN, AtmosphericPlacedFeatures.waterTreePlacement(PlacementUtils.m_195364_((int)50, (float)0.1f, (int)1)));
        public static final RegistryObject<PlacedFeature> TREES_SPARSE_RAINFOREST_BASIN = AtmosphericPlacedFeatures.register("trees_sparse_rainforest_basin", AtmosphericConfiguredFeatures.TREES_RAINFOREST_BASIN, AtmosphericPlacedFeatures.waterTreePlacement(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)5)));
        public static final RegistryObject<PlacedFeature> OAK_RAINFOREST_BASIN = AtmosphericPlacedFeatures.register("oak_rainforest_basin", AtmosphericConfiguredFeatures.OAK_RAINFOREST_BASIN, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)10, (float)0.1f, (int)1), (Block)Blocks.f_50746_));
        public static final RegistryObject<PlacedFeature> TREES_DUNES = AtmosphericPlacedFeatures.register("trees_dunes", AtmosphericConfiguredFeatures.TREES_DUNES, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)1)));
        public static final RegistryObject<PlacedFeature> TREES_FLOURISHING_DUNES = AtmosphericPlacedFeatures.register("trees_flourishing_dunes", AtmosphericConfiguredFeatures.TREES_FLOURISHING_DUNES, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)2, (float)0.05f, (int)1)));
        public static final RegistryObject<PlacedFeature> TREES_ROCKY_DUNES = AtmosphericPlacedFeatures.register("trees_rocky_dunes", AtmosphericConfiguredFeatures.TREES_DUNES, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1)));
        public static final RegistryObject<PlacedFeature> TREES_PETRIFIED_DUNES = AtmosphericPlacedFeatures.register("trees_petrified_dunes", AtmosphericConfiguredFeatures.TREES_PETRIFIED_DUNES, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.5f, (int)2)));
        public static final RegistryObject<PlacedFeature> TREES_WOODED_BADLANDS = AtmosphericPlacedFeatures.register("trees_wooded_badlands", AtmosphericConfiguredFeatures.TREES_DUNES, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)1)));
        public static final RegistryObject<PlacedFeature> FLOURISHING_DUNES_YUCCA_TREES = AtmosphericPlacedFeatures.register("flourishing_dunes_yucca_trees", AtmosphericConfiguredFeatures.YUCCA_BEES_005_WITH_FLOWERS, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)1)));
        public static final RegistryObject<PlacedFeature> DESERT_YUCCA_TREES = AtmosphericPlacedFeatures.register("desert_yucca_trees", AtmosphericConfiguredFeatures.TREES_DUNES, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.005f, (int)1)));
        public static final RegistryObject<PlacedFeature> WINDSWEPT_SAVANNA_YUCCA_TREES = AtmosphericPlacedFeatures.register("windswept_savanna_yucca_trees", AtmosphericConfiguredFeatures.TREES_DUNES, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.125f, (int)1)));
        public static final RegistryObject<PlacedFeature> WARM_MONKEY_BRUSH = AtmosphericPlacedFeatures.register("warm_monkey_brush", AtmosphericConfiguredFeatures.WARM_MONKEY_BRUSH, List.of());
        public static final RegistryObject<PlacedFeature> HOT_MONKEY_BRUSH = AtmosphericPlacedFeatures.register("hot_monkey_brush", AtmosphericConfiguredFeatures.HOT_MONKEY_BRUSH, List.of());
        public static final RegistryObject<PlacedFeature> SCALDING_MONKEY_BRUSH = AtmosphericPlacedFeatures.register("scalding_monkey_brush", AtmosphericConfiguredFeatures.SCALDING_MONKEY_BRUSH, List.of());
        public static final RegistryObject<PlacedFeature> MONKEY_BRUSH = AtmosphericPlacedFeatures.register("monkey_brush", AtmosphericConfiguredFeatures.MONKEY_BRUSH, List.of(RarityFilter.m_191900_((int)12), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PODZOL = AtmosphericPlacedFeatures.register("bamboo", AtmosphericConfiguredFeatures.PODZOL, List.of(NoiseBasedCountPlacement.m_191731_((int)160, (double)80.0, (double)0.3), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PASSION_VINES = AtmosphericPlacedFeatures.register("passion_vines", AtmosphericConfiguredFeatures.PASSION_VINES, List.of(CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)64), (VerticalAnchor)VerticalAnchor.m_158922_((int)192)), BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_WATER_HYACINTH = AtmosphericPlacedFeatures.register("patch_water_hyacinth", AtmosphericConfiguredFeatures.PATCH_WATER_HYACINTH, List.of(RarityFilter.m_191900_((int)24), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_WATER_HYACINTH_SPARSE = AtmosphericPlacedFeatures.register("patch_water_hyacinth_sparse", AtmosphericConfiguredFeatures.PATCH_WATER_HYACINTH, List.of(RarityFilter.m_191900_((int)48), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_WATERLILY_RAINFOREST = AtmosphericPlacedFeatures.register("patch_waterlily_rainforest", AtmosphericConfiguredFeatures.PATCH_WATERLILY, VegetationPlacements.m_195474_((int)1));
        public static final RegistryObject<PlacedFeature> PATCH_WATERLILY_RAINFOREST_BASIN = AtmosphericPlacedFeatures.register("patch_waterlily_rainforest_basin", AtmosphericConfiguredFeatures.PATCH_WATERLILY, VegetationPlacements.m_195474_((int)4));
        public static final RegistryObject<PlacedFeature> DUNE_ROCK = AtmosphericPlacedFeatures.register("dune_rock", AtmosphericConfiguredFeatures.DUNE_ROCK, List.of(CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> DUNE_ROCK_EXTRA = AtmosphericPlacedFeatures.register("dune_rock_extra", AtmosphericConfiguredFeatures.DUNE_ROCK, List.of(CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> DUNE_ROCK_MANY = AtmosphericPlacedFeatures.register("dune_rock_many", AtmosphericConfiguredFeatures.DUNE_ROCK, List.of(CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_BARREL_CACTUS_DUNES = AtmosphericPlacedFeatures.register("patch_barrel_cactus_dunes", AtmosphericConfiguredFeatures.PATCH_BARREL_CACTUS, List.of(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_BARREL_CACTUS_ROCKY_DUNES = AtmosphericPlacedFeatures.register("patch_barrel_cactus_rocky_dunes", AtmosphericConfiguredFeatures.PATCH_BARREL_CACTUS, List.of(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_BARREL_CACTUS_FLOURISHING_DUNES = AtmosphericPlacedFeatures.register("patch_barrel_cactus_flourishing_dunes", AtmosphericConfiguredFeatures.PATCH_BARREL_CACTUS, List.of(PlacementUtils.m_195364_((int)0, (float)0.5f, (int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_BARREL_CACTUS_PETRIFIED_DUNES = AtmosphericPlacedFeatures.register("patch_barrel_cactus_petrified_dunes", AtmosphericConfiguredFeatures.PATCH_BARREL_CACTUS, List.of(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_MELON_DUNES = AtmosphericPlacedFeatures.register("patch_melon_dunes", AtmosphericConfiguredFeatures.PATCH_MELON_DUNES, List.of(RarityFilter.m_191900_((int)6), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_DUNE_GRASS = AtmosphericPlacedFeatures.register("patch_dune_grass", AtmosphericConfiguredFeatures.PATCH_DUNE_GRASS, List.of(PlacementUtils.m_195364_((int)1, (float)0.05f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_ARID_SPROUTS = AtmosphericPlacedFeatures.register("patch_arid_sprouts", AtmosphericConfiguredFeatures.PATCH_ARID_SPROUTS, VegetationPlacements.m_195474_((int)2));
        public static final RegistryObject<PlacedFeature> FLOWER_FLOURISHING_DUNES = AtmosphericPlacedFeatures.register("flower_flourishing_dunes", AtmosphericConfiguredFeatures.FLOWER_FLOURISHING_DUNES, List.of(RarityFilter.m_191900_((int)12), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_YUCCA_FLOWER = AtmosphericPlacedFeatures.register("patch_yucca_flower", AtmosphericConfiguredFeatures.PATCH_YUCCA_FLOWER, List.of(RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_YUCCA_FLOWER_EXTRA = AtmosphericPlacedFeatures.register("patch_yucca_flower_extra", AtmosphericConfiguredFeatures.PATCH_YUCCA_FLOWER, List.of(RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_SHORT_ALOE_VERA = AtmosphericPlacedFeatures.register("patch_short_aloe_vera", AtmosphericConfiguredFeatures.PATCH_SHORT_ALOE_VERA, List.of());
        public static final RegistryObject<PlacedFeature> PATCH_TALL_ALOE_VERA = AtmosphericPlacedFeatures.register("patch_tall_aloe_vera", AtmosphericConfiguredFeatures.PATCH_TALL_ALOE_VERA, List.of());
        public static final RegistryObject<PlacedFeature> PATCH_ALOE_VERA = AtmosphericPlacedFeatures.register("patch_aloe_vera", AtmosphericConfiguredFeatures.PATCH_ALOE_VERA, List.of(RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> PATCH_ALOE_VERA_EXTRA = AtmosphericPlacedFeatures.register("patch_aloe_vera_extra", AtmosphericConfiguredFeatures.PATCH_ALOE_VERA, List.of(RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> FOSSIL_DUNES = AtmosphericPlacedFeatures.register("fossil_dunes", AtmosphericConfiguredFeatures.SURFACE_FOSSIL, List.of(RarityFilter.m_191900_((int)24), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)64), (VerticalAnchor)VerticalAnchor.m_158922_((int)256)), BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> HOT_SPRINGS_ROCK = AtmosphericPlacedFeatures.register("hot_springs_rock", AtmosphericConfiguredFeatures.HOT_SPRINGS_ROCK, List.of(BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50440_})), CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> OCEAN_FLOOR_RAISER = AtmosphericPlacedFeatures.register("ocean_floor_raiser", AtmosphericConfiguredFeatures.OCEAN_FLOOR_RAISER, List.of(InSquareCenterPlacement.INSTANCE, PlacementUtils.f_195353_, BiomeFilter.m_191561_()));

        private static ImmutableList<PlacementModifier> waterTreePlacement(PlacementModifier modifier) {
            return ImmutableList.builder().add((Object)modifier).add((Object)InSquarePlacement.m_191715_()).add((Object)SurfaceWaterDepthFilter.m_191950_((int)10)).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_()).build();
        }

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placementModifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature((Holder)feature.getHolder().get(), (List)ImmutableList.copyOf((Collection)placementModifiers)));
        }
    }

    public static final class AtmosphericConfiguredFeatures {
        public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"atmospheric");
        private static final List<ResourceLocation> FOSSIL_STRUCTURES = List.of(new ResourceLocation("fossil/spine_1"), new ResourceLocation("fossil/spine_2"), new ResourceLocation("fossil/spine_3"), new ResourceLocation("fossil/spine_4"), new ResourceLocation("fossil/skull_1"), new ResourceLocation("fossil/skull_2"), new ResourceLocation("fossil/skull_3"), new ResourceLocation("fossil/skull_4"));
        private static final List<ResourceLocation> FOSSIL_COAL_STRUCTURES = List.of(new ResourceLocation("fossil/spine_1_coal"), new ResourceLocation("fossil/spine_2_coal"), new ResourceLocation("fossil/spine_3_coal"), new ResourceLocation("fossil/spine_4_coal"), new ResourceLocation("fossil/skull_1_coal"), new ResourceLocation("fossil/skull_2_coal"), new ResourceLocation("fossil/skull_3_coal"), new ResourceLocation("fossil/skull_4_coal"));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> ROSEWOOD = AtmosphericConfiguredFeatures.register("rosewood", () -> new ConfiguredFeature((Feature)ROSEWOOD_TREE.get(), (FeatureConfiguration)Configs.ROSEWOOD));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> ROSEWOOD_BEES_0002 = AtmosphericConfiguredFeatures.register("rosewood_bees_0002", () -> new ConfiguredFeature((Feature)ROSEWOOD_TREE.get(), (FeatureConfiguration)Configs.ROSEWOOD_BEES_0002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> ROSEWOOD_BEES_005 = AtmosphericConfiguredFeatures.register("rosewood_bees_005", () -> new ConfiguredFeature((Feature)ROSEWOOD_TREE.get(), (FeatureConfiguration)Configs.ROSEWOOD_BEES_005));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WATER_ROSEWOOD = AtmosphericConfiguredFeatures.register("water_rosewood", () -> new ConfiguredFeature((Feature)ROSEWOOD_WATER_TREE.get(), (FeatureConfiguration)Configs.ROSEWOOD));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> MORADO = AtmosphericConfiguredFeatures.register("morado", () -> new ConfiguredFeature((Feature)ROSEWOOD_TREE.get(), (FeatureConfiguration)Configs.MORADO));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> MORADO_BEES_0002 = AtmosphericConfiguredFeatures.register("morado_bees_0002", () -> new ConfiguredFeature((Feature)ROSEWOOD_TREE.get(), (FeatureConfiguration)Configs.MORADO_BEES_0002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> MORADO_BEES_005 = AtmosphericConfiguredFeatures.register("morado_bees_005", () -> new ConfiguredFeature((Feature)ROSEWOOD_TREE.get(), (FeatureConfiguration)Configs.MORADO_BEES_005));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WATER_MORADO = AtmosphericConfiguredFeatures.register("water_morado", () -> new ConfiguredFeature((Feature)ROSEWOOD_WATER_TREE.get(), (FeatureConfiguration)Configs.MORADO));
        public static final RegistryObject<ConfiguredFeature<YuccaTreeConfiguration, ?>> YUCCA = AtmosphericConfiguredFeatures.register("yucca", () -> new ConfiguredFeature((Feature)YUCCA_TREE.get(), (FeatureConfiguration)Configs.YUCCA));
        public static final RegistryObject<ConfiguredFeature<YuccaTreeConfiguration, ?>> YUCCA_WITH_FLOWERS = AtmosphericConfiguredFeatures.register("yucca_with_flowers", () -> new ConfiguredFeature((Feature)YUCCA_TREE.get(), (FeatureConfiguration)Configs.YUCCA_WITH_FLOWERS));
        public static final RegistryObject<ConfiguredFeature<YuccaTreeConfiguration, ?>> BABY_YUCCA = AtmosphericConfiguredFeatures.register("baby_yucca", () -> new ConfiguredFeature((Feature)YUCCA_TREE.get(), (FeatureConfiguration)Configs.BABY_YUCCA));
        public static final RegistryObject<ConfiguredFeature<YuccaTreeConfiguration, ?>> BABY_YUCCA_WITH_FLOWERS = AtmosphericConfiguredFeatures.register("baby_yucca_with_flowers", () -> new ConfiguredFeature((Feature)YUCCA_TREE.get(), (FeatureConfiguration)Configs.BABY_YUCCA_WITH_FLOWERS));
        public static final RegistryObject<ConfiguredFeature<YuccaTreeConfiguration, ?>> YUCCA_BEES_005 = AtmosphericConfiguredFeatures.register("yucca_bees_005", () -> new ConfiguredFeature((Feature)YUCCA_TREE.get(), (FeatureConfiguration)Configs.YUCCA_BEES_005));
        public static final RegistryObject<ConfiguredFeature<YuccaTreeConfiguration, ?>> YUCCA_BEES_005_WITH_FLOWERS = AtmosphericConfiguredFeatures.register("yucca_bees_005_with_flowers", () -> new ConfiguredFeature((Feature)YUCCA_TREE.get(), (FeatureConfiguration)Configs.YUCCA_BEES_005_WITH_FLOWERS));
        public static final RegistryObject<ConfiguredFeature<YuccaTreeConfiguration, ?>> PETRIFIED_YUCCA = AtmosphericConfiguredFeatures.register("petrified_yucca", () -> new ConfiguredFeature((Feature)YUCCA_TREE.get(), (FeatureConfiguration)Configs.PETRIFIED_YUCCA));
        public static final RegistryObject<ConfiguredFeature<YuccaTreeConfiguration, ?>> RED_PETRIFIED_YUCCA = AtmosphericConfiguredFeatures.register("red_petrified_yucca", () -> new ConfiguredFeature((Feature)YUCCA_TREE.get(), (FeatureConfiguration)Configs.RED_PETRIFIED_YUCCA));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> ASPEN = AtmosphericConfiguredFeatures.register("aspen", () -> new ConfiguredFeature((Feature)ASPEN_TREE.get(), (FeatureConfiguration)Configs.ASPEN));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> GRIMWOOD = AtmosphericConfiguredFeatures.register("grimwood", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)Configs.GRIMWOOD));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> KOUSA = AtmosphericConfiguredFeatures.register("kousa", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)Configs.KOUSA));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> OAK_BUSH = AtmosphericConfiguredFeatures.register("oak_bush", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49999_), (TrunkPlacer)new StraightTrunkPlacer(1, 0, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50050_), (FoliagePlacer)new BushFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)1), 2), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).m_68251_()));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_RAINFOREST = AtmosphericConfiguredFeatures.register("trees_rainforest", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.f_195385_, 0.03333334f), new WeightedPlacedFeature((Holder)AtmosphericPlacedFeatures.OAK_BUSH.getHolder().get(), 0.16666667f), new WeightedPlacedFeature((Holder)AtmosphericPlacedFeatures.MORADO_BEES_0002.getHolder().get(), 0.1f)), (Holder)AtmosphericPlacedFeatures.ROSEWOOD_BEES_0002.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_SPARSE_RAINFOREST = AtmosphericConfiguredFeatures.register("trees_sparse_rainforest", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)AtmosphericPlacedFeatures.MORADO_BEES_0002.getHolder().get(), 0.05f)), (Holder)AtmosphericPlacedFeatures.ROSEWOOD_BEES_0002.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_RAINFOREST_BASIN = AtmosphericConfiguredFeatures.register("trees_rainforest_basin", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)AtmosphericPlacedFeatures.WATER_MORADO.getHolder().get(), 0.1f)), (Holder)AtmosphericPlacedFeatures.WATER_ROSEWOOD.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> OAK_RAINFOREST_BASIN = AtmosphericConfiguredFeatures.register("oak_rainforest_basin", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.f_195385_, 0.16666667f)), (Holder)AtmosphericPlacedFeatures.OAK_BUSH.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> PODZOL = AtmosphericConfiguredFeatures.register("podzol", () -> new ConfiguredFeature((Feature)PODZOL.get(), (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.2f)));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PASSION_VINES = AtmosphericConfiguredFeatures.register("passion_vines", () -> new ConfiguredFeature((Feature)PASSION_VINE.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PATCH_WATER_HYACINTH = AtmosphericConfiguredFeatures.register("patch_water_hyacinth", () -> new ConfiguredFeature((Feature)WATER_HYACINTH_PATCH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_WATERLILY = AtmosphericConfiguredFeatures.register("patch_waterlily_rainforest", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(10, 7, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50196_))))));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> WARM_MONKEY_BRUSH = AtmosphericConfiguredFeatures.register("warm_monkey_brush", () -> new ConfiguredFeature((Feature)WARM_MONKEY_BRUSH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> HOT_MONKEY_BRUSH = AtmosphericConfiguredFeatures.register("hot_monkey_brush", () -> new ConfiguredFeature((Feature)HOT_MONKEY_BRUSH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> SCALDING_MONKEY_BRUSH = AtmosphericConfiguredFeatures.register("scalding_monkey_brush", () -> new ConfiguredFeature((Feature)SCALDING_MONKEY_BRUSH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> MONKEY_BRUSH = AtmosphericConfiguredFeatures.register("monkey_brush", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)AtmosphericPlacedFeatures.SCALDING_MONKEY_BRUSH.getHolder().get(), 0.16666667f), new WeightedPlacedFeature((Holder)AtmosphericPlacedFeatures.HOT_MONKEY_BRUSH.getHolder().get(), 0.33333334f)), (Holder)AtmosphericPlacedFeatures.WARM_MONKEY_BRUSH.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<BlockStateConfiguration, ?>> DUNE_ROCK = AtmosphericConfiguredFeatures.register("forest_rock", () -> new ConfiguredFeature((Feature)DUNE_ROCK.get(), (FeatureConfiguration)new BlockStateConfiguration(((Block)AtmosphericBlocks.ARID_SANDSTONE.get()).m_49966_())));
        public static final RegistryObject<ConfiguredFeature<FossilFeatureConfiguration, ?>> SURFACE_FOSSIL = AtmosphericConfiguredFeatures.register("surface_fossil", () -> new ConfiguredFeature((Feature)((SurfaceFossilFeature)((Object)((Object)SURFACE_FOSSIL.get()))), (FeatureConfiguration)new FossilFeatureConfiguration(FOSSIL_STRUCTURES, FOSSIL_COAL_STRUCTURES, ProcessorLists.f_177022_, ProcessorLists.f_177023_, 4)));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_BARREL_CACTUS = AtmosphericConfiguredFeatures.register("patch_barrel_cactus", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.BARREL_CACTUS.get())), BarrelCactusBlock.AGE, (IntProvider)UniformInt.m_146622_((int)0, (int)3))), List.of((Block)AtmosphericBlocks.RED_ARID_SAND.get()))));
        public static final RegistryObject<ConfiguredFeature<LargeDiskConfiguration, ?>> PATCH_DUNE_GRASS = AtmosphericConfiguredFeatures.register("patch_dune_grass", () -> new ConfiguredFeature((Feature)COARSE_DIRT_PATCH.get(), (FeatureConfiguration)new LargeDiskConfiguration(Blocks.f_50546_.m_49966_(), (IntProvider)UniformInt.m_146622_((int)1, (int)7), 2, Lists.newArrayList((Object[])new BlockState[]{((Block)AtmosphericBlocks.RED_ARID_SAND.get()).m_49966_(), ((Block)AtmosphericBlocks.ARID_SAND.get()).m_49966_()}))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_ARID_SPROUTS = AtmosphericConfiguredFeatures.register("patch_arid_sprouts", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206470_((int)32, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.ARID_SPROUTS.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_FLOURISHING_DUNES = AtmosphericConfiguredFeatures.register("flower_flourishing_dunes", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(64, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.GILIA.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_MELON_DUNES = AtmosphericConfiguredFeatures.register("patch_melon_dunes", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(64, 7, 3, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50186_)), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_190419_(), (BlockPredicate)BlockPredicate.m_224771_((Vec3i)Direction.DOWN.m_122436_(), List.of((Block)AtmosphericBlocks.ARID_SAND.get(), (Block)AtmosphericBlocks.RED_ARID_SAND.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_DUNES = AtmosphericConfiguredFeatures.register("trees_dunes", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)AtmosphericPlacedFeatures.YUCCA_WITH_FLOWERS.getHolder().get(), 0.25f)), (Holder)AtmosphericPlacedFeatures.YUCCA.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_PETRIFIED_DUNES = AtmosphericConfiguredFeatures.register("trees_petrified_dunes", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)AtmosphericPlacedFeatures.RED_PETRIFIED_YUCCA.getHolder().get(), 0.25f)), (Holder)AtmosphericPlacedFeatures.PETRIFIED_YUCCA.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_FLOURISHING_DUNES = AtmosphericConfiguredFeatures.register("trees_flourishing_dunes", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)AtmosphericPlacedFeatures.BABY_YUCCA_WITH_FLOWERS.getHolder().get(), 0.25f)), (Holder)AtmosphericPlacedFeatures.BABY_YUCCA.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_YUCCA_FLOWER = AtmosphericConfiguredFeatures.register("patch_yucca_flower", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)AtmosphericBlocks.YUCCA_FLOWER.get()).m_49966_(), 1).m_146271_((Object)((Block)AtmosphericBlocks.TALL_YUCCA_FLOWER.get()).m_49966_(), 2).m_146270_())), List.of((Block)AtmosphericBlocks.ARID_SAND.get(), (Block)AtmosphericBlocks.RED_ARID_SAND.get()))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_SHORT_ALOE_VERA = AtmosphericConfiguredFeatures.register("patch_short_aloe_vera", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)AtmosphericBlocks.ALOE_VERA.get()).m_49966_().m_61124_((Property)AloeVeraBlock.AGE, (Comparable)Integer.valueOf(5))))), List.of((Block)AtmosphericBlocks.RED_ARID_SAND.get()))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_TALL_ALOE_VERA = AtmosphericConfiguredFeatures.register("patch_tall_aloe_vera", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)AtmosphericBlocks.TALL_ALOE_VERA.get()).m_49966_().m_61124_((Property)AloeVeraTallBlock.AGE, (Comparable)Integer.valueOf(8))))), List.of((Block)AtmosphericBlocks.ARID_SAND.get()))));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> PATCH_ALOE_VERA = AtmosphericConfiguredFeatures.register("patch_aloe_vera", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)AtmosphericPlacedFeatures.PATCH_TALL_ALOE_VERA.getHolder().get(), 0.5f)), (Holder)AtmosphericPlacedFeatures.PATCH_SHORT_ALOE_VERA.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<BlockStateConfiguration, ?>> HOT_SPRINGS_ROCK = AtmosphericConfiguredFeatures.register("hot_springs_rock", () -> new ConfiguredFeature(Feature.f_65780_, (FeatureConfiguration)new BlockStateConfiguration(Blocks.f_50079_.m_49966_())));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> OCEAN_FLOOR_RAISER = AtmosphericConfiguredFeatures.register("ocean_floor_raiser", () -> new ConfiguredFeature((Feature)OCEAN_FLOOR_RAISER.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> RegistryObject<ConfiguredFeature<FC, ?>> register(String name, Supplier<ConfiguredFeature<FC, F>> feature) {
            return CONFIGURED_FEATURES.register(name, feature);
        }
    }

    public static final class Configs {
        private static final BeehiveDecorator BEEHIVE_0002 = new BeehiveDecorator(0.002f);
        private static final BeehiveDecorator BEEHIVE_005 = new BeehiveDecorator(0.05f);
        public static final TreeConfiguration ROSEWOOD = Configs.createRosewood().m_68251_();
        public static final TreeConfiguration ROSEWOOD_BEES_0002 = Configs.createRosewood().m_68249_(List.of(BEEHIVE_0002)).m_68251_();
        public static final TreeConfiguration ROSEWOOD_BEES_005 = Configs.createRosewood().m_68249_(List.of(BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration MORADO = Configs.createMorado().m_68251_();
        public static final TreeConfiguration MORADO_BEES_0002 = Configs.createMorado().m_68249_(List.of(BEEHIVE_0002)).m_68251_();
        public static final TreeConfiguration MORADO_BEES_005 = Configs.createMorado().m_68249_(List.of(BEEHIVE_005)).m_68251_();
        public static final YuccaTreeConfiguration YUCCA = Configs.createYucca().build();
        public static final YuccaTreeConfiguration YUCCA_WITH_FLOWERS = Configs.createYucca().hasPatch().build();
        public static final YuccaTreeConfiguration YUCCA_BEES_005 = Configs.createYucca().decorators(List.of(BEEHIVE_005)).build();
        public static final YuccaTreeConfiguration YUCCA_BEES_005_WITH_FLOWERS = Configs.createYucca().hasPatch().decorators(List.of(BEEHIVE_005)).build();
        public static final YuccaTreeConfiguration BABY_YUCCA = Configs.createYucca().setBaby().build();
        public static final YuccaTreeConfiguration BABY_YUCCA_WITH_FLOWERS = Configs.createYucca().setBaby().hasPatch().build();
        public static final YuccaTreeConfiguration PETRIFIED_YUCCA = new YuccaTreeConfiguration.YuccaTreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.ARID_SANDSTONE.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.ARID_SANDSTONE.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.ARID_SANDSTONE_WALL.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.ROASTED_YUCCA_BUNDLE.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.ARID_SANDSTONE_WALL.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.ARID_SANDSTONE_WALL.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.ARID_SANDSTONE_WALL.get()))).isPetrified().build();
        public static final YuccaTreeConfiguration RED_PETRIFIED_YUCCA = new YuccaTreeConfiguration.YuccaTreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.RED_ARID_SANDSTONE.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.RED_ARID_SANDSTONE.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.RED_ARID_SANDSTONE_WALL.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.ROASTED_YUCCA_BUNDLE.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.RED_ARID_SANDSTONE_WALL.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.RED_ARID_SANDSTONE_WALL.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.RED_ARID_SANDSTONE_WALL.get()))).isPetrified().build();
        public static final TreeConfiguration ASPEN = Configs.createCustomTree((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)AtmosphericBlocks.ASPEN_LOG.get()).m_49966_(), 3).m_146271_((Object)((Block)AtmosphericBlocks.WATCHFUL_ASPEN_LOG.get()).m_49966_(), 2).m_146270_()), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.ASPEN_LEAVES.get()))).m_68251_();
        public static final TreeConfiguration GRIMWOOD = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.GRIMWOOD_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.GRIMWOOD_LEAVES.get())), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)UniformInt.m_146622_((int)2, (int)3), (IntProvider)UniformInt.m_146622_((int)0, (int)2), (IntProvider)UniformInt.m_146622_((int)1, (int)2)), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68244_().m_68251_();
        public static final TreeConfiguration KOUSA = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.KOUSA_LOG.get())), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.KOUSA_LEAVES.get())), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_().m_68251_();

        private static TreeConfiguration.TreeConfigurationBuilder createRosewood() {
            return Configs.createCustomTree(((Block)AtmosphericBlocks.ROSEWOOD_LOG.get()).m_49966_(), ((Block)AtmosphericBlocks.ROSEWOOD_LEAVES.get()).m_49966_());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createMorado() {
            return Configs.createCustomTree((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.MORADO_LOG.get())), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)AtmosphericBlocks.MORADO_LEAVES.get()).m_49966_(), 2).m_146271_((Object)((Block)AtmosphericBlocks.FLOWERING_MORADO_LEAVES.get()).m_49966_(), 6).m_146270_()));
        }

        private static YuccaTreeConfiguration.YuccaTreeConfigurationBuilder createYucca() {
            return new YuccaTreeConfiguration.YuccaTreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.YUCCA_LOG.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.YUCCA_LEAVES.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.YUCCA_BRANCH.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.YUCCA_BUNDLE.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AtmosphericBlocks.YUCCA_FLOWER.get())), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)AtmosphericBlocks.TALL_YUCCA_FLOWER.get()).m_49966_().m_61124_((Property)YuccaFlowerDoubleBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER))), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)AtmosphericBlocks.TALL_YUCCA_FLOWER.get()).m_49966_().m_61124_((Property)YuccaFlowerDoubleBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER))));
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCustomTree(BlockStateProvider logProvider, BlockStateProvider leavesProvider) {
            return new TreeConfiguration.TreeConfigurationBuilder(logProvider, (TrunkPlacer)new StraightTrunkPlacer(0, 0, 0), leavesProvider, (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0), 0), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).m_68244_();
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCustomTree(BlockState logState, BlockState leavesState) {
            return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)logState), (TrunkPlacer)new StraightTrunkPlacer(0, 0, 0), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)leavesState), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0), 0), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).m_68244_();
        }
    }
}

