/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo;

import com.github.nyuppo.config.SheepHornSettings;
import com.github.nyuppo.config.VariantBlacklist;
import com.github.nyuppo.config.VariantSettings;
import com.github.nyuppo.config.Variants;
import com.github.nyuppo.networking.C2SRequestVariantPacket;
import com.github.nyuppo.networking.MMVPacketHandler;
import com.github.nyuppo.variant.BreedingResultModifier;
import com.github.nyuppo.variant.CustomEyesModifier;
import com.github.nyuppo.variant.CustomVariantNameModifier;
import com.github.nyuppo.variant.CustomWoolModifier;
import com.github.nyuppo.variant.DiscardableModifier;
import com.github.nyuppo.variant.MobVariant;
import com.github.nyuppo.variant.MoonPhaseModifier;
import com.github.nyuppo.variant.NametagOverrideModifier;
import com.github.nyuppo.variant.ShearedWoolColorModifier;
import com.github.nyuppo.variant.ShinyModifier;
import com.github.nyuppo.variant.SpawnableBiomesModifier;
import com.github.nyuppo.variant.VariantModifier;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="moremobvariants")
public class MoreMobVariants {
    public static final String MOD_ID = "moremobvariants";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String NBT_KEY = "VariantID";
    public static final String MUDDY_NBT_KEY = "IsMuddy";
    public static final String MUDDY_TIMEOUT_NBT_KEY = "MuddyTimeLeft";
    public static final String SHEEP_HORN_COLOUR_NBT_KEY = "HornColour";
    public static final TagKey<Block> PIG_MUD_BLOCKS = BlockTags.create((ResourceLocation)new ResourceLocation("moremobvariants", "pig_mud_blocks"));
    public static final TagKey<Biome> SPAWN_MOSSY_SKELETONS = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "spawn_mossy_skeletons"));
    public static final TagKey<Biome> INCREASED_SANDY_SKELETONS = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "increased_sandy_skeletons"));
    public static final TagKey<Biome> SHEEP_SPAWN_WITH_HORNS = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "sheep_spawn_with_horns"));
    public static final TagKey<Biome> SPAWN_PALE_WOLF = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "wolf_pale_spawns"));
    public static final TagKey<Biome> SPAWN_RUSTY_WOLF = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "wolf_rusty_spawns"));
    public static final TagKey<Biome> SPAWN_SPOTTED_WOLF = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "wolf_spotted_spawns"));
    public static final TagKey<Biome> SPAWN_BLACK_WOLF = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "wolf_black_spawns"));
    public static final TagKey<Biome> SPAWN_STRIPED_WOLF = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "wolf_striped_spawns"));
    public static final TagKey<Biome> SPAWN_SNOWY_WOLF = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "wolf_snowy_spawns"));
    public static final TagKey<Biome> SPAWN_ASHEN_WOLF = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "wolf_ashen_spawns"));
    public static final TagKey<Biome> SPAWN_WOODS_WOLF = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "wolf_woods_spawns"));
    public static final TagKey<Biome> SPAWN_CHESTNUT_WOLF = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "wolf_chestnut_spawns"));
    public static final TagKey<Biome> ADDITIONAL_WOLF_SPAWNS = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("moremobvariants", "additional_wolf_spawns"));
    Set<EntityType> validEntities = Set.of(EntityType.f_20553_, EntityType.f_20555_, EntityType.f_20557_, EntityType.f_20510_, EntityType.f_20520_, EntityType.f_20524_, EntityType.f_20479_, EntityType.f_20499_, EntityType.f_20501_);

    public MoreMobVariants() {
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinLevel);
        MinecraftForge.EVENT_BUS.addListener(this::onBabyEntitySpawn);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onReload);
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_() && this.validEntities.contains(event.getEntity().m_6095_())) {
            MMVPacketHandler.sendToServer(new C2SRequestVariantPacket(event.getEntity().m_20148_()));
        }
    }

    @SubscribeEvent
    public void onBabyEntitySpawn(BabyEntitySpawnEvent event) {
        if (event.getChild() != null && this.validEntities.contains(event.getChild().m_6095_())) {
            AgeableMob child = event.getChild();
            MobVariant variant = Variants.getChildVariant(child.m_6095_(), (ServerLevel)child.f_19853_, (AgeableMob)event.getParentA(), (AgeableMob)event.getParentB());
            CompoundTag childNbt = new CompoundTag();
            child.m_20240_(childNbt);
            childNbt.m_128359_(NBT_KEY, variant.getIdentifier().toString());
            if (child instanceof Sheep) {
                CompoundTag nbtParent1 = new CompoundTag();
                event.getParentA().m_20240_(nbtParent1);
                CompoundTag nbtParent2 = new CompoundTag();
                event.getParentB().m_20240_(nbtParent2);
                String colour = "";
                if (nbtParent1.m_128441_(SHEEP_HORN_COLOUR_NBT_KEY) && !nbtParent1.m_128461_(SHEEP_HORN_COLOUR_NBT_KEY).isEmpty() && nbtParent2.m_128441_(SHEEP_HORN_COLOUR_NBT_KEY) && !nbtParent2.m_128461_(SHEEP_HORN_COLOUR_NBT_KEY).isEmpty() && child.f_19853_.m_213780_().m_188500_() <= SheepHornSettings.getInheritChance()) {
                    colour = child.f_19853_.m_213780_().m_188499_() ? nbtParent1.m_128461_(SHEEP_HORN_COLOUR_NBT_KEY) : nbtParent2.m_128461_(SHEEP_HORN_COLOUR_NBT_KEY);
                } else {
                    SheepHornSettings.SheepHornColour col = SheepHornSettings.getRandomSheepHornColour(child.f_19853_.m_213780_(), (Holder<Biome>)child.f_19853_.m_204166_(child.m_20183_()));
                    if (col != null) {
                        colour = col.getId();
                    }
                }
                childNbt.m_128359_(SHEEP_HORN_COLOUR_NBT_KEY, colour);
            }
            child.m_20258_(childNbt);
            event.setChild(child);
        }
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Giving mobs a fresh coat of paint...");
        event.enqueueWork(MMVPacketHandler::registerPackets);
    }

    @SubscribeEvent
    public void onReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimpleJsonResourceReloadListener(new Gson(), MOD_ID){
            private final ResourceLocation SETTINGS_ID;
            private final ResourceLocation SHEEP_HORN_SETTINGS_ID;
            {
                this.SETTINGS_ID = new ResourceLocation(MoreMobVariants.MOD_ID, "settings/settings.json");
                this.SHEEP_HORN_SETTINGS_ID = new ResourceLocation(MoreMobVariants.MOD_ID, "settings/sheep_horn_settings.json");
            }

            protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profilerFiller) {
                Optional sheepHornSettings;
                LOGGER.info("Reloading config...");
                Variants.clearAllVariants();
                for (ResourceLocation id : manager.m_214159_("variants", path -> path.m_135815_().endsWith(".json")).keySet()) {
                    String path2 = id.m_135815_().substring("variants/".length(), id.m_135815_().length() - ".json".length());
                    String[] split = path2.split("/");
                    if (manager.m_213713_(id).isPresent()) {
                        try (InputStream stream = ((Resource)manager.m_213713_(id).get()).m_215507_();){
                            this.applyVariant(new InputStreamReader(stream, StandardCharsets.UTF_8), id.m_135827_(), split[0], split[1]);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error occured while loading " + split[0] + " variant '" + split[1] + "' (" + id.m_214299_() + ")", (Throwable)e);
                        }
                        continue;
                    }
                    LOGGER.error(id.m_214299_() + " was not present.");
                }
                Variants.validateEmptyVariants();
                VariantBlacklist.clearAllBlacklists();
                for (ResourceLocation id : manager.m_214159_("blacklist", path -> path.m_135815_().endsWith(".json")).keySet()) {
                    String mob = id.m_135815_().substring("blacklist/".length(), id.m_135815_().length() - ".json".length());
                    if (manager.m_213713_(id).isPresent()) {
                        try (InputStream stream = ((Resource)manager.m_213713_(id).get()).m_215507_();){
                            this.applyBlacklist(new InputStreamReader(stream, StandardCharsets.UTF_8), mob);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error occured while loading blacklist config " + id.m_214299_(), (Throwable)e);
                            VariantBlacklist.clearBlacklist(Variants.getMob(mob));
                        }
                        continue;
                    }
                    LOGGER.error(id.m_214299_() + " was not present.");
                }
                Variants.applyBlacklists();
                Optional settings = manager.m_213713_(this.SETTINGS_ID);
                if (settings.isPresent()) {
                    try (InputStream stream = ((Resource)manager.m_213713_(this.SETTINGS_ID).get()).m_215507_();){
                        this.applySettings(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occured while loading settings config " + this.SETTINGS_ID.m_214299_(), (Throwable)e);
                        VariantSettings.resetSettings();
                    }
                }
                if ((sheepHornSettings = manager.m_213713_(this.SHEEP_HORN_SETTINGS_ID)).isPresent()) {
                    try (InputStream stream = ((Resource)manager.m_213713_(this.SHEEP_HORN_SETTINGS_ID).get()).m_215507_();){
                        this.applySheepHornSettings(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occured while loading sheep horn settings config " + this.SHEEP_HORN_SETTINGS_ID.m_214299_(), (Throwable)e);
                        SheepHornSettings.resetSettings();
                    }
                }
            }

            private void applyVariant(Reader reader, String namespace, String mobId, String variantId) {
                JsonElement element = JsonParser.parseReader((Reader)reader);
                int weight = 0;
                ArrayList<VariantModifier> modifiers = new ArrayList<VariantModifier>();
                if (element.getAsJsonObject().size() != 0) {
                    JsonElement breeding;
                    if (element.getAsJsonObject().has("weight")) {
                        weight = element.getAsJsonObject().get("weight").getAsInt();
                    } else if (!element.getAsJsonObject().has("nametag_override")) {
                        LOGGER.error("Variant " + namespace + ":" + mobId + "/" + variantId + " has no weight, skipping.");
                        return;
                    }
                    if (element.getAsJsonObject().has("name")) {
                        modifiers.add(new CustomVariantNameModifier(element.getAsJsonObject().get("name").getAsString()));
                    }
                    if (element.getAsJsonObject().has("shiny") && element.getAsJsonObject().get("shiny").getAsBoolean()) {
                        modifiers.add(new ShinyModifier());
                    }
                    if (element.getAsJsonObject().has("discard_chance")) {
                        modifiers.add(new DiscardableModifier(element.getAsJsonObject().get("discard_chance").getAsDouble()));
                    }
                    if (element.getAsJsonObject().has("biome_tag")) {
                        String[] biomesIdentifier = element.getAsJsonObject().get("biome_tag").getAsString().split(":");
                        TagKey biomes = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(biomesIdentifier[0], biomesIdentifier[1]));
                        modifiers.add(new SpawnableBiomesModifier((TagKey<Biome>)biomes));
                    }
                    if (element.getAsJsonObject().has("breeding") && (breeding = element.getAsJsonObject().get("breeding")).getAsJsonObject().has("parent1") && breeding.getAsJsonObject().has("parent2") && breeding.getAsJsonObject().has("breeding_chance")) {
                        String[] parent1 = breeding.getAsJsonObject().get("parent1").getAsString().split(":");
                        String[] parent2 = breeding.getAsJsonObject().get("parent2").getAsString().split(":");
                        double breedingChance = breeding.getAsJsonObject().get("breeding_chance").getAsDouble();
                        modifiers.add(new BreedingResultModifier(new ResourceLocation(parent1[0], parent1[1]), new ResourceLocation(parent2[0], parent2[1]), breedingChance));
                    }
                    if (element.getAsJsonObject().has("custom_wool") && element.getAsJsonObject().get("custom_wool").getAsBoolean()) {
                        modifiers.add(new CustomWoolModifier());
                    }
                    if (element.getAsJsonObject().has("has_color_when_sheared") && element.getAsJsonObject().get("has_color_when_sheared").getAsBoolean()) {
                        modifiers.add(new ShearedWoolColorModifier());
                    }
                    if (element.getAsJsonObject().has("custom_eyes") && element.getAsJsonObject().get("custom_eyes").getAsBoolean()) {
                        modifiers.add(new CustomEyesModifier());
                    }
                    if (element.getAsJsonObject().has("nametag_override")) {
                        modifiers.add(new NametagOverrideModifier(element.getAsJsonObject().get("nametag_override").getAsString()));
                    }
                    if (element.getAsJsonObject().has("minimum_moon_size")) {
                        modifiers.add(new MoonPhaseModifier(element.getAsJsonObject().get("minimum_moon_size").getAsFloat()));
                    }
                }
                Variants.addVariant(Variants.getMob(mobId), new MobVariant(new ResourceLocation(namespace, variantId), weight, modifiers));
            }

            private void applyBlacklist(Reader reader, String mob) {
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element.getAsJsonObject().size() != 0 && element.getAsJsonObject().has("blacklist")) {
                    JsonArray blacklist = element.getAsJsonObject().get("blacklist").getAsJsonArray();
                    for (JsonElement entry : blacklist) {
                        String[] entrySplit = entry.getAsString().split(":");
                        VariantBlacklist.blacklist(Variants.getMob(mob), new ResourceLocation(entrySplit[0], entrySplit[1]));
                    }
                }
            }

            private void applySettings(Reader reader) {
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element.getAsJsonObject().size() != 0) {
                    if (element.getAsJsonObject().has("enable_muddy_pigs")) {
                        VariantSettings.setEnableMuddyPigs(element.getAsJsonObject().get("enable_muddy_pigs").getAsBoolean());
                    }
                    if (element.getAsJsonObject().has("muddy_pig_timeout")) {
                        VariantSettings.setMuddyPigTimeout(element.getAsJsonObject().get("muddy_pig_timeout").getAsInt());
                    }
                    if (element.getAsJsonObject().has("child_random_variant_chance")) {
                        VariantSettings.setChildRandomVariantChance(element.getAsJsonObject().get("child_random_variant_chance").getAsDouble());
                    }
                }
            }

            private void applySheepHornSettings(Reader reader) {
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element.getAsJsonObject().size() != 0) {
                    if (element.getAsJsonObject().has("chance")) {
                        SheepHornSettings.setHornsChance(element.getAsJsonObject().get("chance").getAsDouble());
                    }
                    if (element.getAsJsonObject().has("inherit_parents_chance")) {
                        SheepHornSettings.setInheritChance(element.getAsJsonObject().get("inherit_parents_chance").getAsDouble());
                    }
                    if (element.getAsJsonObject().has("weights")) {
                        JsonElement weights = element.getAsJsonObject().get("weights");
                        if (weights.getAsJsonObject().has("brown")) {
                            SheepHornSettings.setWeight(SheepHornSettings.SheepHornColour.BROWN, weights.getAsJsonObject().get("brown").getAsInt());
                        }
                        if (weights.getAsJsonObject().has("gray")) {
                            SheepHornSettings.setWeight(SheepHornSettings.SheepHornColour.GRAY, weights.getAsJsonObject().get("gray").getAsInt());
                        }
                        if (weights.getAsJsonObject().has("black")) {
                            SheepHornSettings.setWeight(SheepHornSettings.SheepHornColour.BLACK, weights.getAsJsonObject().get("black").getAsInt());
                        }
                        if (weights.getAsJsonObject().has("beige")) {
                            SheepHornSettings.setWeight(SheepHornSettings.SheepHornColour.BEIGE, weights.getAsJsonObject().get("beige").getAsInt());
                        }
                    }
                }
            }
        });
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

