/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;

class WeightedRandomBag<T> {
    private List<Entry> entries = new ArrayList<Entry>();
    private double accumulatedWeight;
    private final RandomSource random;

    public WeightedRandomBag(RandomSource random) {
        this.random = random;
    }

    public void addEntry(T object, double weight) {
        this.accumulatedWeight += weight;
        Entry e = new Entry();
        e.object = object;
        e.accumulatedWeight = this.accumulatedWeight;
        this.entries.add(e);
    }

    public T getRandom() {
        double r = this.random.m_188500_() * this.accumulatedWeight;
        for (Entry entry : this.entries) {
            if (!(entry.accumulatedWeight >= r)) continue;
            return entry.object;
        }
        return null;
    }

    private class Entry {
        double accumulatedWeight;
        T object;

        private Entry() {
        }
    }
}

