/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.mixin;

import com.github.nyuppo.MoreMobVariants;
import com.github.nyuppo.config.VariantSettings;
import com.github.nyuppo.config.Variants;
import com.github.nyuppo.mixin.MobVariantsMixin;
import com.github.nyuppo.networking.MMVPacketHandler;
import com.github.nyuppo.networking.S2CRespondVariantPacket;
import com.github.nyuppo.variant.MobVariant;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Pig.class})
public abstract class PigVariantsMixin
extends MobVariantsMixin {
    private MobVariant variant = Variants.getDefaultVariant(EntityType.f_20510_);
    private boolean isMuddy = false;
    private int muddyTimeLeft = -1;

    @Override
    protected void onAddAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128359_("VariantID", this.variant.getIdentifier().toString());
        nbt.m_128379_("IsMuddy", this.isMuddy);
        nbt.m_128405_("MuddyTimeLeft", this.muddyTimeLeft);
    }

    @Override
    protected void onReadAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        this.variant = !nbt.m_128461_("VariantID").isEmpty() ? (nbt.m_128461_("VariantID").contains(":") ? Variants.getVariant(EntityType.f_20510_, new ResourceLocation(nbt.m_128461_("VariantID"))) : Variants.getVariant(EntityType.f_20510_, MoreMobVariants.id(nbt.m_128461_("VariantID")))) : Variants.getRandomVariant(EntityType.f_20510_, ((Pig)this).f_19853_.m_213780_().m_188505_(), (Holder<Biome>)((Pig)this).f_19853_.m_204166_(((Pig)this).m_20183_()), null, Float.valueOf(((Pig)this).f_19853_.m_46940_()));
        this.isMuddy = nbt.m_128471_("IsMuddy");
        this.muddyTimeLeft = nbt.m_128451_("MuddyTimeLeft");
        MinecraftServer server = ((Entity)this).m_20194_();
        if (server != null) {
            MMVPacketHandler.sendToAllClients(new S2CRespondVariantPacket(((Entity)this).m_19879_(), this.variant.getIdentifier().toString(), this.isMuddy, this.muddyTimeLeft));
        }
    }

    @Override
    protected void onFinalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData entityData, CompoundTag entityNbt, CallbackInfoReturnable<SpawnGroupData> cir) {
        this.variant = Variants.getRandomVariant(EntityType.f_20510_, world.m_213780_().m_188505_(), (Holder<Biome>)world.m_204166_(((Pig)this).m_20183_()), null, Float.valueOf(world.m_46940_()));
        if (world.m_204166_(((Pig)this).m_20183_()).m_203656_(BiomeTags.f_207626_) && world.m_213780_().m_188500_() < 0.02) {
            this.isMuddy = true;
        }
    }

    @Override
    protected void onTick(CallbackInfo ci) {
        if (VariantSettings.getEnableMuddyPigs()) {
            int muddyPigTimeout = VariantSettings.getMuddyPigTimeout();
            if (this.muddyTimeLeft == -1) {
                if (((Pig)this).f_19853_.m_8055_(((Pig)this).m_20183_()).m_204336_(MoreMobVariants.PIG_MUD_BLOCKS) || ((Pig)this).f_19853_.m_8055_(((Pig)this).m_20183_().m_7495_()).m_204336_(MoreMobVariants.PIG_MUD_BLOCKS)) {
                    this.isMuddy = true;
                    if (muddyPigTimeout > 0) {
                        this.muddyTimeLeft = 20 * muddyPigTimeout;
                    }
                } else if (((Pig)this).m_20070_()) {
                    this.isMuddy = false;
                    this.muddyTimeLeft = -1;
                }
            }
            if (muddyPigTimeout > 0 && this.muddyTimeLeft > 0) {
                --this.muddyTimeLeft;
                if (this.muddyTimeLeft == 0) {
                    this.isMuddy = false;
                    this.muddyTimeLeft = -1;
                }
            }
        }
    }
}

