/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.mojang.logging.LogUtils;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.schematics.SchematicInstances;
import com.simibubi.create.content.schematics.SchematicProcessor;
import com.simibubi.create.content.schematics.client.SchematicEditScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import org.slf4j.Logger;

public class SchematicItem
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();

    public SchematicItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack create(String schematic, String owner) {
        ItemStack blueprint = AllItems.SCHEMATIC.asStack();
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("Deployed", false);
        tag.m_128359_("Owner", owner);
        tag.m_128359_("File", schematic);
        tag.m_128365_("Anchor", (Tag)NbtUtils.m_129224_((BlockPos)BlockPos.f_121853_));
        tag.m_128359_("Rotation", Rotation.NONE.name());
        tag.m_128359_("Mirror", Mirror.NONE.name());
        blueprint.m_41751_(tag);
        SchematicItem.writeSize(blueprint);
        return blueprint;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            if (stack.m_41783_().m_128441_("File")) {
                tooltip.add((Component)Components.literal(ChatFormatting.GOLD + stack.m_41783_().m_128461_("File")));
            }
        } else {
            tooltip.add((Component)Lang.translateDirect("schematic.invalid", new Object[0]).m_130940_(ChatFormatting.RED));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public static void writeSize(ItemStack blueprint) {
        CompoundTag tag = blueprint.m_41783_();
        StructureTemplate t = SchematicItem.loadSchematic(blueprint);
        tag.m_128365_("Bounds", (Tag)NBTHelper.writeVec3i(t.m_163801_()));
        blueprint.m_41751_(tag);
        SchematicInstances.clearHash(blueprint);
    }

    public static StructurePlaceSettings getSettings(ItemStack blueprint) {
        return SchematicItem.getSettings(blueprint, true);
    }

    public static StructurePlaceSettings getSettings(ItemStack blueprint, boolean processNBT) {
        CompoundTag tag = blueprint.m_41783_();
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.m_74379_(Rotation.valueOf((String)tag.m_128461_("Rotation")));
        settings.m_74377_(Mirror.valueOf((String)tag.m_128461_("Mirror")));
        if (processNBT) {
            settings.m_74383_((StructureProcessor)SchematicProcessor.INSTANCE);
        }
        return settings;
    }

    public static StructureTemplate loadSchematic(ItemStack blueprint) {
        Path file;
        Path dir;
        StructureTemplate t = new StructureTemplate();
        String owner = blueprint.m_41783_().m_128461_("Owner");
        String schematic = blueprint.m_41783_().m_128461_("File");
        if (!schematic.endsWith(".nbt")) {
            return t;
        }
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            dir = Paths.get("schematics", "uploaded").toAbsolutePath();
            file = Paths.get(owner, schematic);
        } else {
            dir = Paths.get("schematics", new String[0]).toAbsolutePath();
            file = Paths.get(schematic, new String[0]);
        }
        Path path = dir.resolve(file).normalize();
        if (!path.startsWith(dir)) {
            return t;
        }
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(path, StandardOpenOption.READ))));){
            CompoundTag nbt = NbtIo.m_128934_((DataInput)stream, (NbtAccounter)new NbtAccounter(0x20000000L));
            t.m_74638_(nbt);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read schematic", (Throwable)e);
        }
        return t;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() != null && !this.onItemUse(context.m_43723_(), context.m_43724_())) {
            return super.m_6225_(context);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!this.onItemUse(playerIn, handIn)) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
    }

    private boolean onItemUse(Player player, InteractionHand hand) {
        if (!player.m_6144_() || hand != InteractionHand.MAIN_HAND) {
            return false;
        }
        if (!player.m_21120_(hand).m_41782_()) {
            return false;
        }
        if (!player.f_19853_.m_5776_()) {
            return true;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::displayBlueprintScreen);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayBlueprintScreen() {
        ScreenOpener.open(new SchematicEditScreen());
    }
}

