/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.mutable.MutableInt;

public class ItemHelper {
    public static void dropContents(Level world, BlockPos pos, IItemHandler inv) {
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)inv.getStackInSlot(slot));
        }
    }

    public static List<ItemStack> multipliedOutput(ItemStack in, ItemStack out) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemStack result = out.m_41777_();
        result.m_41764_(in.m_41613_() * out.m_41613_());
        while (result.m_41613_() > result.m_41741_()) {
            stacks.add(result.m_41620_(result.m_41741_()));
        }
        stacks.add(result);
        return stacks;
    }

    public static void addToList(ItemStack stack, List<ItemStack> stacks) {
        for (ItemStack s : stacks) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)s)) continue;
            int transferred = Math.min(s.m_41741_() - s.m_41613_(), stack.m_41613_());
            s.m_41769_(transferred);
            stack.m_41774_(transferred);
        }
        if (stack.m_41613_() > 0) {
            stacks.add(stack);
        }
    }

    public static boolean isSameInventory(IItemHandler h1, IItemHandler h2) {
        if (h1 == null || h2 == null) {
            return false;
        }
        if (h1.getSlots() != h2.getSlots()) {
            return false;
        }
        for (int slot = 0; slot < h1.getSlots(); ++slot) {
            if (h1.getStackInSlot(slot) == h2.getStackInSlot(slot)) continue;
            return false;
        }
        return true;
    }

    public static int calcRedstoneFromInventory(@Nullable IItemHandler inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        int totalSlots = inv.getSlots();
        for (int j = 0; j < inv.getSlots(); ++j) {
            int slotLimit = inv.getSlotLimit(j);
            if (slotLimit == 0) {
                --totalSlots;
                continue;
            }
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.m_41619_()) continue;
            f += (float)itemstack.m_41613_() / (float)Math.min(slotLimit, itemstack.m_41741_());
            ++i;
        }
        if (totalSlots == 0) {
            return 0;
        }
        return Mth.m_14143_((float)((f /= (float)totalSlots) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static List<Pair<Ingredient, MutableInt>> condenseIngredients(NonNullList<Ingredient> recipeIngredients) {
        ArrayList<Pair<Ingredient, MutableInt>> actualIngredients = new ArrayList<Pair<Ingredient, MutableInt>>();
        block0: for (Ingredient igd : recipeIngredients) {
            block1: for (Pair pair : actualIngredients) {
                ItemStack[] stacks2;
                ItemStack[] stacks1 = ((Ingredient)pair.getFirst()).m_43908_();
                if (stacks1.length != (stacks2 = igd.m_43908_()).length) continue;
                for (int i = 0; i <= stacks1.length; ++i) {
                    if (i == stacks1.length) {
                        ((MutableInt)pair.getSecond()).increment();
                        continue block0;
                    }
                    if (!ItemStack.m_41728_((ItemStack)stacks1[i], (ItemStack)stacks2[i])) continue block1;
                }
            }
            actualIngredients.add(Pair.of(igd, new MutableInt(1)));
        }
        return actualIngredients;
    }

    public static boolean matchIngredients(Ingredient i1, Ingredient i2) {
        ItemStack[] stacks2;
        if (i1 == i2) {
            return true;
        }
        ItemStack[] stacks1 = i1.m_43908_();
        if (stacks1 == (stacks2 = i2.m_43908_())) {
            return true;
        }
        if (stacks1.length == stacks2.length) {
            for (int i = 0; i < stacks1.length; ++i) {
                if (ItemStack.m_41746_((ItemStack)stacks1[i], (ItemStack)stacks2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean matchAllIngredients(NonNullList<Ingredient> ingredients) {
        if (ingredients.size() <= 1) {
            return true;
        }
        Ingredient firstIngredient = (Ingredient)ingredients.get(0);
        for (int i = 1; i < ingredients.size(); ++i) {
            if (ItemHelper.matchIngredients(firstIngredient, (Ingredient)ingredients.get(i))) continue;
            return false;
        }
        return true;
    }

    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, boolean simulate) {
        return ItemHelper.extract(inv, test, ExtractionCountMode.UPTO, 64, simulate);
    }

    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, int exactAmount, boolean simulate) {
        return ItemHelper.extract(inv, test, ExtractionCountMode.EXACTLY, exactAmount, simulate);
    }

    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, ExtractionCountMode mode, int amount, boolean simulate) {
        boolean amountRequired;
        ItemStack extracting = ItemStack.f_41583_;
        boolean checkHasEnoughItems = amountRequired = mode == ExtractionCountMode.EXACTLY;
        boolean hasEnoughItems = !checkHasEnoughItems;
        boolean potentialOtherMatch = false;
        int maxExtractionCount = amount;
        block0: while (true) {
            extracting = ItemStack.f_41583_;
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                int amountToExtractFromThisSlot = Math.min(maxExtractionCount - extracting.m_41613_(), inv.getStackInSlot(slot).m_41741_());
                ItemStack stack = inv.extractItem(slot, amountToExtractFromThisSlot, true);
                if (stack.m_41619_() || !test.test(stack)) continue;
                if (!extracting.m_41619_() && !ItemHelper.canItemStackAmountsStack(stack, extracting)) {
                    potentialOtherMatch = true;
                    continue;
                }
                if (extracting.m_41619_()) {
                    extracting = stack.m_41777_();
                } else {
                    extracting.m_41769_(stack.m_41613_());
                }
                if (!simulate && hasEnoughItems) {
                    inv.extractItem(slot, stack.m_41613_(), false);
                }
                if (extracting.m_41613_() < maxExtractionCount) continue;
                if (!checkHasEnoughItems) break block0;
                hasEnoughItems = true;
                checkHasEnoughItems = false;
                continue block0;
            }
            if (!extracting.m_41619_() && !hasEnoughItems && potentialOtherMatch) {
                ItemStack blackListed = extracting.m_41777_();
                test = test.and(i -> !ItemHandlerHelper.canItemStacksStack((ItemStack)i, (ItemStack)blackListed));
                continue;
            }
            if (!checkHasEnoughItems) break;
            checkHasEnoughItems = false;
        }
        if (amountRequired && extracting.m_41613_() < amount) {
            return ItemStack.f_41583_;
        }
        return extracting;
    }

    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, Function<ItemStack, Integer> amountFunction, boolean simulate) {
        ItemStack extracting = ItemStack.f_41583_;
        int maxExtractionCount = 64;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack;
            if (extracting.m_41619_()) {
                int maxExtractionCountForItem;
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (stackInSlot.m_41619_() || !test.test(stackInSlot) || (maxExtractionCountForItem = amountFunction.apply(stackInSlot).intValue()) == 0) continue;
                maxExtractionCount = Math.min(maxExtractionCount, maxExtractionCountForItem);
            }
            if (!test.test(stack = inv.extractItem(slot, maxExtractionCount - extracting.m_41613_(), true)) || !extracting.m_41619_() && !ItemHelper.canItemStackAmountsStack(stack, extracting)) continue;
            if (extracting.m_41619_()) {
                extracting = stack.m_41777_();
            } else {
                extracting.m_41769_(stack.m_41613_());
            }
            if (!simulate) {
                inv.extractItem(slot, stack.m_41613_(), false);
            }
            if (extracting.m_41613_() >= maxExtractionCount) break;
        }
        return extracting;
    }

    public static boolean canItemStackAmountsStack(ItemStack a, ItemStack b) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b) && a.m_41613_() + b.m_41613_() <= a.m_41741_();
    }

    public static ItemStack findFirstMatch(IItemHandler inv, Predicate<ItemStack> test) {
        int slot = ItemHelper.findFirstMatchingSlotIndex(inv, test);
        if (slot == -1) {
            return ItemStack.f_41583_;
        }
        return inv.getStackInSlot(slot);
    }

    public static int findFirstMatchingSlotIndex(IItemHandler inv, Predicate<ItemStack> test) {
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack toTest = inv.getStackInSlot(slot);
            if (!test.test(toTest)) continue;
            return slot;
        }
        return -1;
    }

    public static ItemStack limitCountToMaxStackSize(ItemStack stack, boolean simulate) {
        int max;
        int count = stack.m_41613_();
        if (count <= (max = stack.m_41741_())) {
            return ItemStack.f_41583_;
        }
        ItemStack remainder = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(count - max));
        if (!simulate) {
            stack.m_41764_(max);
        }
        return remainder;
    }

    public static enum ExtractionCountMode {
        EXACTLY,
        UPTO;

    }
}

