/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gui;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.ponder.ui.PonderTagIndexScreen;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CreateMainMenuScreen
extends AbstractSimiScreen {
    public static final CubeMap PANORAMA_RESOURCES = new CubeMap(Create.asResource("textures/gui/title/background/panorama"));
    public static final ResourceLocation PANORAMA_OVERLAY_TEXTURES = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    public static final PanoramaRenderer PANORAMA = new PanoramaRenderer(PANORAMA_RESOURCES);
    private static final Component CURSEFORGE_TOOLTIP = Components.literal("CurseForge").m_130938_(s -> s.m_178520_(16545884).m_131136_(Boolean.valueOf(true)));
    private static final Component MODRINTH_TOOLTIP = Components.literal("Modrinth").m_130938_(s -> s.m_178520_(4182827).m_131136_(Boolean.valueOf(true)));
    public static final String CURSEFORGE_LINK = "https://www.curseforge.com/minecraft/mc-mods/create";
    public static final String MODRINTH_LINK = "https://modrinth.com/mod/create";
    public static final String ISSUE_TRACKER_LINK = "https://github.com/Creators-of-Create/Create/issues";
    public static final String SUPPORT_LINK = "https://github.com/Creators-of-Create/Create/wiki/Supporting-the-Project";
    protected final Screen parent;
    protected boolean returnOnClose;
    private PanoramaRenderer vanillaPanorama;
    private long firstRenderTime;
    private Button gettingStarted;

    public CreateMainMenuScreen(Screen parent) {
        this.parent = parent;
        this.returnOnClose = true;
        if (parent instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)parent;
            this.vanillaPanorama = titleScreen.f_96729_;
        } else {
            this.vanillaPanorama = new PanoramaRenderer(TitleScreen.f_96716_);
        }
    }

    @Override
    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.firstRenderTime == 0L) {
            this.firstRenderTime = Util.m_137550_();
        }
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        float f = (float)(Util.m_137550_() - this.firstRenderTime) / 1000.0f;
        float alpha = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        float elapsedPartials = this.f_96541_.m_91297_();
        if (this.parent instanceof TitleScreen) {
            if (alpha < 1.0f) {
                this.vanillaPanorama.m_110003_(elapsedPartials, 1.0f);
            }
            PANORAMA.m_110003_(elapsedPartials, alpha);
            RenderSystem.m_157456_((int)0, (ResourceLocation)PANORAMA_OVERLAY_TEXTURES);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            CreateMainMenuScreen.m_93160_((PoseStack)ms, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
        }
        RenderSystem.m_69482_();
        for (int side : Iterate.positiveAndNegative) {
            ms.m_85836_();
            ms.m_85837_((double)(this.f_96543_ / 2), 60.0, 200.0);
            ms.m_85841_((float)(24 * side), (float)(24 * side), 32.0f);
            ms.m_85837_(-1.75 * (double)(alpha * alpha / 2.0f + 0.5f), 0.25, 0.0);
            TransformStack.cast((PoseStack)ms).rotateX(45.0);
            GuiGameElement.of(AllBlocks.LARGE_COGWHEEL.getDefaultState()).rotateBlock(0.0, (float)Util.m_137550_() / 32.0f * (float)side, 0.0).render(ms);
            ms.m_85837_(-1.0, 0.0, -1.0);
            GuiGameElement.of(AllBlocks.COGWHEEL.getDefaultState()).rotateBlock(0.0, (float)Util.m_137550_() / -16.0f * (float)side + 22.5f, 0.0).render(ms);
            ms.m_85849_();
        }
        RenderSystem.m_69478_();
        ms.m_85836_();
        ms.m_85837_((double)(this.f_96543_ / 2 - 32), 32.0, -10.0);
        ms.m_85836_();
        ms.m_85841_(0.25f, 0.25f, 0.25f);
        AllGuiTextures.LOGO.render(ms, 0, 0, (GuiComponent)this);
        ms.m_85849_();
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(-2013265920)).flatBorder(new Color(0x1000000))).at(-32.0f, 56.0f, 100.0f)).withBounds(128, 11)).render(ms);
        ms.m_85849_();
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0, 200.0);
        CreateMainMenuScreen.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)Components.literal("Create").m_130940_(ChatFormatting.BOLD).m_7220_((Component)Components.literal(" v0.5.1i").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.WHITE})), (int)(this.f_96543_ / 2), (int)89, (int)-1787033);
        ms.m_85849_();
        RenderSystem.m_69465_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.returnOnClose = true;
        this.addButtons();
    }

    private void addButtons() {
        int yStart = this.f_96544_ / 4 + 40;
        int center = this.f_96543_ / 2;
        int bHeight = 20;
        int bShortWidth = 98;
        int bLongWidth = 200;
        this.m_142416_((GuiEventListener)new Button(center - 100, yStart + 92, bLongWidth, bHeight, (Component)Lang.translateDirect("menu.return", new Object[0]), $ -> this.linkTo(this.parent)));
        this.m_142416_((GuiEventListener)new Button(center - 100, yStart + 24 + -16, bLongWidth, bHeight, (Component)Lang.translateDirect("menu.configure", new Object[0]), $ -> this.linkTo(BaseConfigScreen.forCreate(this))));
        this.gettingStarted = new Button(center + 2, yStart + 48 + -16, bShortWidth, bHeight, (Component)Lang.translateDirect("menu.ponder_index", new Object[0]), $ -> this.linkTo(new PonderTagIndexScreen()));
        this.gettingStarted.f_93623_ = !(this.parent instanceof TitleScreen);
        this.m_142416_((GuiEventListener)this.gettingStarted);
        this.m_142416_((GuiEventListener)new PlatformIconButton(center - 100, yStart + 48 + -16, bShortWidth / 2, bHeight, AllGuiTextures.CURSEFORGE_LOGO, 0.085f, b -> this.linkTo(CURSEFORGE_LINK), (b, ps, mx, my) -> this.m_96602_(ps, CURSEFORGE_TOOLTIP, mx, my)));
        this.m_142416_((GuiEventListener)new PlatformIconButton(center - 50, yStart + 48 + -16, bShortWidth / 2, bHeight, AllGuiTextures.MODRINTH_LOGO, 0.0575f, b -> this.linkTo(MODRINTH_LINK), (b, ps, mx, my) -> this.m_96602_(ps, MODRINTH_TOOLTIP, mx, my)));
        this.m_142416_((GuiEventListener)new Button(center + 2, yStart + 68, bShortWidth, bHeight, (Component)Lang.translateDirect("menu.report_bugs", new Object[0]), $ -> this.linkTo(ISSUE_TRACKER_LINK)));
        this.m_142416_((GuiEventListener)new Button(center - 100, yStart + 68, bShortWidth, bHeight, (Component)Lang.translateDirect("menu.support", new Object[0]), $ -> this.linkTo(SUPPORT_LINK)));
    }

    @Override
    protected void renderWindowForeground(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        super.renderWindowForeground(ms, mouseX, mouseY, partialTicks);
        this.f_169369_.forEach(w -> w.m_6305_(ms, mouseX, mouseY, partialTicks));
        if (this.parent instanceof TitleScreen) {
            if (mouseX < this.gettingStarted.f_93620_ || mouseX > this.gettingStarted.f_93620_ + 98) {
                return;
            }
            if (mouseY < this.gettingStarted.f_93621_ || mouseY > this.gettingStarted.f_93621_ + 20) {
                return;
            }
            this.m_96597_(ms, TooltipHelper.cutTextComponent((Component)Lang.translateDirect("menu.only_ingame", new Object[0]), TooltipHelper.Palette.ALL_GRAY), mouseX, mouseY);
        }
    }

    private void linkTo(Screen screen) {
        this.returnOnClose = false;
        ScreenOpener.open(screen);
    }

    private void linkTo(String url) {
        this.returnOnClose = false;
        ScreenOpener.open((Screen)new ConfirmLinkScreen(p_213069_2_ -> {
            if (p_213069_2_) {
                Util.m_137581_().m_137646_(url);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, url, true));
    }

    @Override
    public boolean m_7043_() {
        return true;
    }

    protected static class PlatformIconButton
    extends Button {
        protected final AllGuiTextures icon;
        protected final float scale;

        public PlatformIconButton(int pX, int pY, int pWidth, int pHeight, AllGuiTextures icon, float scale, Button.OnPress pOnPress, Button.OnTooltip pOnTooltip) {
            super(pX, pY, pWidth, pHeight, Components.immutableEmpty(), pOnPress, pOnTooltip);
            this.icon = icon;
            this.scale = scale;
        }

        protected void m_7906_(PoseStack pPoseStack, Minecraft pMinecraft, int pMouseX, int pMouseY) {
            pPoseStack.m_85836_();
            pPoseStack.m_85837_((double)((float)(this.f_93620_ + this.f_93618_ / 2) - (float)this.icon.width * this.scale / 2.0f), (double)((float)(this.f_93621_ + this.f_93619_ / 2) - (float)this.icon.height * this.scale / 2.0f), 0.0);
            pPoseStack.m_85841_(this.scale, this.scale, 1.0f);
            this.icon.render(pPoseStack, 0, 0);
            pPoseStack.m_85849_();
        }
    }
}

