/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.lavabucket.hourglass.client.gui.ScreenAlignment;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SleepGui {
    private static ItemStack clock = new ItemStack((ItemLike)Items.f_42524_);

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.START && ((Boolean)HourglassConfig.CLIENT_CONFIG.preventClockWobble.get()).booleanValue() && minecraft.f_91073_ != null && !minecraft.m_91104_() && SleepGui.clockEnabled()) {
            minecraft.m_91291_().m_174264_(clock, (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0);
        }
    }

    @SubscribeEvent
    public static void onGuiEvent(ScreenEvent.Render.Post event) {
        if (event.getScreen() instanceof InBedChatScreen && SleepGui.clockEnabled()) {
            SleepGui.renderSleepInterface(event.getScreen().getMinecraft());
        }
    }

    public static void renderSleepInterface(Minecraft minecraft) {
        Screen screen = minecraft.f_91080_;
        if (!(screen instanceof InBedChatScreen)) {
            return;
        }
        int scale = (Integer)HourglassConfig.CLIENT_CONFIG.clockScale.get();
        int margin = (Integer)HourglassConfig.CLIENT_CONFIG.clockMargin.get();
        ScreenAlignment alignment = (ScreenAlignment)((Object)HourglassConfig.CLIENT_CONFIG.clockAlignment.get());
        float x = alignment == ScreenAlignment.TOP_LEFT || alignment == ScreenAlignment.CENTER_LEFT || alignment == ScreenAlignment.BOTTOM_LEFT ? (float)margin : (alignment == ScreenAlignment.TOP_CENTER || alignment == ScreenAlignment.CENTER_CENTER || alignment == ScreenAlignment.BOTTOM_CENTER ? (float)(screen.f_96543_ / 2 - scale / 2) : (float)(screen.f_96543_ - scale - margin));
        float y = alignment == ScreenAlignment.TOP_LEFT || alignment == ScreenAlignment.TOP_CENTER || alignment == ScreenAlignment.TOP_RIGHT ? (float)margin : (alignment == ScreenAlignment.CENTER_LEFT || alignment == ScreenAlignment.CENTER_CENTER || alignment == ScreenAlignment.CENTER_RIGHT ? (float)(screen.f_96544_ / 2 - scale / 2) : (float)(screen.f_96544_ - scale - margin));
        SleepGui.renderClock(minecraft, x, y, scale);
    }

    public static void renderClock(Minecraft minecraft, float x, float y, float scale) {
        ItemRenderer itemRenderer = minecraft.m_91291_();
        PoseStack stack = RenderSystem.m_157191_();
        stack.m_85836_();
        stack.m_85837_((double)x, (double)y, 0.0);
        stack.m_85841_(scale /= 16.0f, scale, 0.0f);
        itemRenderer.m_115203_(clock, 0, 0);
        stack.m_85849_();
    }

    public static boolean clockEnabled() {
        return (Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get() != false && (Boolean)HourglassConfig.SERVER_CONFIG.displayBedClock.get() != false;
    }
}

